/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.BranchTagPropertyUpdateDialog;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.util.LinkList;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizardCommentPage;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizardCopyPage;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizardRepositoryPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagWizard
extends Wizard {
    private IResource[] resources;
    private ISVNRemoteResource[] remoteResources;
    private BranchTagWizardRepositoryPage repositoryPage;
    private BranchTagWizardCopyPage copyPage;
    private BranchTagWizardCommentPage commentPage;
    private boolean createOnServer;
    private boolean makeParents;
    private boolean switchAfterBranchTag;
    private String issue;
    private SVNUrl toUrl;
    private SVNRevision revision;
    private Alias newAlias;
    private long revisionNumber = 0L;
    private String comment;
    private boolean alreadyExists;
    private boolean sameStructure;

    public BranchTagWizard(IResource[] resources) {
        this.resources = resources;
        this.setWindowTitle(Policy.bind("BranchTagDialog.title"));
    }

    public BranchTagWizard(ISVNRemoteResource[] remoteResources) {
        this.remoteResources = remoteResources;
        this.setWindowTitle(Policy.bind("BranchTagDialog.title"));
    }

    public void addPages() {
        this.repositoryPage = new BranchTagWizardRepositoryPage();
        this.addPage((IWizardPage)this.repositoryPage);
        this.copyPage = new BranchTagWizardCopyPage();
        this.copyPage.setRevisionNumber(this.revisionNumber);
        this.addPage((IWizardPage)this.copyPage);
        this.commentPage = new BranchTagWizardCommentPage();
        this.addPage((IWizardPage)this.commentPage);
    }

    public boolean performFinish() {
        if (!this.confirmUserData()) {
            return false;
        }
        this.comment = this.commentPage.getComment();
        this.repositoryPage.saveUrl();
        this.createOnServer = !this.copyPage.workingCopyButton.getSelection();
        this.makeParents = this.repositoryPage.makeParentsButton.getSelection();
        boolean bl = this.sameStructure = this.repositoryPage.sameStructureButton != null && this.repositoryPage.sameStructureButton.getSelection();
        if (this.commentPage.switchAfterBranchTagCheckBox != null) {
            this.switchAfterBranchTag = this.commentPage.switchAfterBranchTagCheckBox.getSelection();
        }
        if (this.copyPage.serverButton.getSelection()) {
            this.revision = SVNRevision.HEAD;
        }
        try {
            this.toUrl = new SVNUrl(this.repositoryPage.getUrlText());
            if (this.copyPage.revisionButton.getSelection()) {
                this.revision = SVNRevision.getRevision((String)this.copyPage.getRevision());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)e.getMessage());
            return false;
        }
        if (!this.multipleSelections()) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    ISVNInfo svnInfo = null;
                    SVNUrl[] sourceUrls = BranchTagWizard.this.getUrls();
                    try {
                        try {
                            SVNProviderPlugin.disableConsoleLogging();
                            ISVNRepositoryLocation repository = SVNProviderPlugin.getPlugin().getRepository(sourceUrls[0].toString());
                            ISVNClientAdapter svnClient = repository.getSVNClient();
                            svnInfo = svnClient.getInfo(BranchTagWizard.this.toUrl);
                        }
                        catch (Exception exception) {}
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        SVNProviderPlugin.enableConsoleLogging();
                        throw throwable;
                    }
                    {
                        Object var5_7 = null;
                    }
                    SVNProviderPlugin.enableConsoleLogging();
                    BranchTagWizard.this.alreadyExists = svnInfo != null;
                }
            });
            if (this.alreadyExists) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)Policy.bind("BranchTagDialog.alreadyExists", this.toUrl.toString()));
                return false;
            }
        }
        if (this.resources != null) {
            this.updateTagsProperty(this.toUrl);
        }
        return true;
    }

    private boolean confirmUserData() {
        ProjectProperties projectProperties = this.commentPage.getProjectProperties();
        if (projectProperties != null) {
            int issueCount = 0;
            if (projectProperties.getMessage() != null) {
                this.issue = this.commentPage.getIssue();
                if (this.issue.length() > 0) {
                    String issueError = projectProperties.validateIssue(this.issue);
                    if (issueError != null) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)issueError);
                        return false;
                    }
                    ++issueCount;
                }
            }
            if (projectProperties.getLogregex() != null) {
                try {
                    LinkList linkList = projectProperties.getLinkList(this.commentPage.getComment());
                    String[] urls = linkList.getUrls();
                    issueCount += urls.length;
                }
                catch (Exception e) {
                    this.handle(e, null, null);
                }
            }
            if (projectProperties.isWarnIfNoIssue() && issueCount == 0 && (projectProperties.getMessage() != null && projectProperties.getLogregex() == null ? !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)Policy.bind("BranchTagDialog.0", projectProperties.getLabel())) : (projectProperties.getMessage() == null && projectProperties.getLogregex() != null ? !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)Policy.bind("BranchTagDialog.1", projectProperties.getLabel())) : projectProperties.getMessage() != null && projectProperties.getLogregex() != null && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)Policy.bind("BranchTagDialog.2", projectProperties.getLabel()))))) {
                return false;
            }
        }
        return true;
    }

    private void updateTagsProperty(SVNUrl toUrl) {
        try {
            if (this.resources.length > 1) {
                return;
            }
            ISVNProperty property = null;
            property = this.repositoryPage.getSvnResource().getSvnProperty("subclipse:tags");
            if (property == null) {
                return;
            }
            this.newAlias = new Alias();
            this.newAlias.setBranch(toUrl.toString().toUpperCase().indexOf("TAGS") == -1);
            String relativePath = toUrl.toString().substring(this.repositoryPage.getSvnResource().getRepository().getUrl().toString().length());
            this.newAlias.setRelativePath(relativePath);
            SVNRevision revision = null;
            if (this.copyPage.revisionButton.getSelection()) {
                revision = SVNRevision.getRevision((String)this.copyPage.getRevision());
            } else {
                ISVNClientAdapter svnClient = this.repositoryPage.getSvnResource().getRepository().getSVNClient();
                ISVNInfo svnInfo = svnClient.getInfo(this.repositoryPage.getUrl());
                revision = SVNRevision.getRevision((String)svnInfo.getRevision().toString());
            }
            this.newAlias.setRevision(Integer.parseInt(revision.toString()));
            this.newAlias.setName(toUrl.getLastPathSegment());
            BranchTagPropertyUpdateDialog dialog = new BranchTagPropertyUpdateDialog(this.getShell(), this.getResource(), this.newAlias, "BranchTagPropertyUpdateDialog");
            this.newAlias = dialog.open() == 0 ? dialog.getNewAlias() : null;
        }
        catch (Exception exception) {}
    }

    public boolean multipleSelections() {
        return this.resources != null && this.resources.length > 1 || this.remoteResources != null && this.remoteResources.length > 1;
    }

    public IResource[] getResources() {
        return this.resources;
    }

    public IResource getResource() {
        if (this.resources == null || this.resources.length < 1) {
            return null;
        }
        return this.resources[0];
    }

    public ISVNRemoteResource[] getRemoteResources() {
        return this.remoteResources;
    }

    public ISVNRemoteResource getRemoteResource() {
        if (this.remoteResources == null || this.remoteResources.length < 1) {
            return null;
        }
        return this.remoteResources[0];
    }

    public SVNUrl getUrl() {
        return this.repositoryPage.getUrl();
    }

    public SVNUrl[] getUrls() {
        return this.repositoryPage.getUrls();
    }

    public SVNUrl getToUrl() {
        return this.toUrl;
    }

    public String getUrlText() {
        return this.repositoryPage.getUrlText();
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isCreateOnServer() {
        return this.createOnServer;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public boolean isMakeParents() {
        return this.makeParents;
    }

    public boolean isSameStructure() {
        return this.sameStructure;
    }

    public Alias getNewAlias() {
        return this.newAlias;
    }

    public String getCommonRoot() {
        return this.repositoryPage.getCommonRoot();
    }

    public boolean isSwitchAfterBranchTag() {
        return this.switchAfterBranchTag;
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    protected void handle(Exception exception, String title, String message) {
        SVNUIPlugin.openError(this.getShell(), title, message, exception, 12);
    }
}

