/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.svnproperties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.SVNPropertyDeleteAction;
import org.tigris.subversion.subclipse.ui.actions.SVNPropertyModifyAction;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardSetPropertyPage;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class SvnPropertiesView
extends ViewPart {
    public static final String VIEW_ID = "org.tigris.subversion.subclipse.ui.svnproperties.SvnPropertiesView";
    private TableViewer tableViewer;
    private TextViewer textViewer;
    private ISVNLocalResource resource;
    private Action refreshAction;
    private Action addPropertyAction;
    private Action modifyPropertyAction;
    private Action deletePropertyAction;
    private Label statusLabel;
    private ISelectionListener pageSelectionListener;
    private IResourceStateChangeListener resourceStateChangeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void dispose() {
        SVNProviderPlugin.removeResourceStateChangeListener((IResourceStateChangeListener)this.resourceStateChangeListener);
        this.resourceStateChangeListener = null;
        this.getSite().getPage().removePostSelectionListener(this.pageSelectionListener);
        super.dispose();
    }

    private TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(table);
        this.createColumns(table, layout);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        return this.tableViewer;
    }

    protected TextViewer createText(Composite parent) {
        return new TextViewer(parent, 586);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        this.statusLabel = new Label(parent, 16384);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.statusLabel.setLayoutData((Object)gridData);
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.tableViewer = this.createTable((Composite)sashForm);
        this.textViewer = this.createText((Composite)sashForm);
        sashForm.setWeights(new int[]{70, 30});
        this.contributeActions();
        this.pageSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                SvnPropertiesView.this.handlePartSelectionChanged(part, selection);
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.pageSelectionListener);
        this.resourceStateChangeListener = new ResourceStateChangeListener();
        SVNProviderPlugin.addResourceStateChangeListener((IResourceStateChangeListener)this.resourceStateChangeListener);
    }

    private void handlePartSelectionChanged(IWorkbenchPart part, ISelection selection) {
        block10: {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            try {
                Object adapter;
                Object first = ((IStructuredSelection)selection).getFirstElement();
                if (!(first instanceof IAdaptable)) break block10;
                IAdaptable a = (IAdaptable)first;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof IResource)) break block10;
                IResource resource = (IResource)adapter;
                if (!resource.isAccessible()) {
                    this.showSvnProperties(null);
                    break block10;
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.tigris.subversion.subclipse.core.ISVNLocalResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ISVNLocalResource svnResource = (ISVNLocalResource)resource.getAdapter((Class)clazz2);
                this.showSvnProperties(svnResource);
            }
            catch (SVNException sVNException) {}
        }
    }

    private Action getRefreshAction() {
        if (this.refreshAction == null) {
            SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
            this.refreshAction = new Action(Policy.bind("SvnPropertiesView.refreshLabel"), plugin.getImageDescriptor("elcl16/refresh.gif")){

                public void run() {
                    SvnPropertiesView.this.refresh();
                }
            };
            this.refreshAction.setToolTipText(Policy.bind("SvnPropertiesView.refresh"));
            this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
            this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("clcl16/refresh.gif"));
        }
        return this.refreshAction;
    }

    private Action getAddPropertyAction() {
        if (this.addPropertyAction == null) {
            SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
            this.addPropertyAction = new Action(Policy.bind("SvnPropertiesView.addPropertyLabel"), plugin.getImageDescriptor("Menu Set Property")){

                public void run() {
                    SvnWizardSetPropertyPage setPropertyPage = new SvnWizardSetPropertyPage(SvnPropertiesView.this.resource);
                    SvnWizard wizard = new SvnWizard(setPropertyPage);
                    SvnWizardDialog dialog = new SvnWizardDialog(SvnPropertiesView.this.getSite().getShell(), (IWizard)wizard);
                    wizard.setParentDialog((Dialog)dialog);
                    if (dialog.open() != 0) {
                        return;
                    }
                    try {
                        if (setPropertyPage.getPropertyValue() != null) {
                            SvnPropertiesView.this.resource.setSvnProperty(setPropertyPage.getPropertyName(), setPropertyPage.getPropertyValue(), setPropertyPage.getRecurse());
                        } else {
                            SvnPropertiesView.this.resource.setSvnProperty(setPropertyPage.getPropertyName(), setPropertyPage.getPropertyFile(), setPropertyPage.getRecurse());
                        }
                    }
                    catch (SVNException e) {
                        SVNUIPlugin.openError(SvnPropertiesView.this.getSite().getShell(), Policy.bind("SvnPropertiesView.errorAddTitle"), Policy.bind("SvnPropertiesView.errorAddMessage"), e);
                    }
                }
            };
            this.addPropertyAction.setToolTipText(Policy.bind("SvnPropertiesView.addPropertyTooltip"));
        }
        return this.addPropertyAction;
    }

    private Action getModifyPropertyAction() {
        if (this.modifyPropertyAction == null) {
            this.modifyPropertyAction = new Action(Policy.bind("SvnPropertiesView.modifyPropertyLabel")){

                public void run() {
                    SVNPropertyModifyAction delegate = new SVNPropertyModifyAction();
                    delegate.init((IAction)this);
                    delegate.selectionChanged((IAction)this, SvnPropertiesView.this.tableViewer.getSelection());
                    delegate.run((IAction)this);
                }
            };
        }
        return this.modifyPropertyAction;
    }

    private Action getDeletePropertyAction() {
        if (this.deletePropertyAction == null) {
            this.deletePropertyAction = new Action(Policy.bind("SvnPropertiesView.deletePropertyLabel")){

                public void run() {
                    SVNPropertyDeleteAction delegate = new SVNPropertyDeleteAction();
                    delegate.init((IAction)this);
                    delegate.selectionChanged((IAction)this, SvnPropertiesView.this.tableViewer.getSelection());
                    delegate.run((IAction)this);
                }
            };
        }
        return this.deletePropertyAction;
    }

    public void contributeActions() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                SvnPropertiesView.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.getDeletePropertyAction());
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IAction)this.getRefreshAction());
        tbm.update(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewer.getControl(), "org.tigris.subversion.subclipse.ui.properties_view_context");
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                SvnPropertiesView.this.getModifyPropertyAction().run();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    SvnPropertiesView.this.textViewer.setDocument((IDocument)new Document(""));
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    SvnPropertiesView.this.textViewer.setDocument((IDocument)new Document(""));
                    return;
                }
                ISVNProperty property = (ISVNProperty)ss.getFirstElement();
                SvnPropertiesView.this.textViewer.setDocument((IDocument)new Document(property.getValue()));
            }
        });
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    SvnPropertiesView.this.getDeletePropertyAction().run();
                }
            }
        });
    }

    private void fillTableMenu(IMenuManager manager) {
        manager.add((IAction)this.getRefreshAction());
        Action action = this.getAddPropertyAction();
        try {
            if (this.resource != null) {
                action.setEnabled(this.resource.isManaged());
            } else {
                action.setEnabled(false);
            }
        }
        catch (SVNException sVNException) {
            action.setEnabled(false);
        }
        manager.add((IAction)action);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void createColumns(Table table, TableLayout layout) {
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("SvnPropertiesView.propertyName"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("SvnPropertiesView.propertyValue"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(120, true));
    }

    public void setFocus() {
    }

    public void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    SvnPropertiesView.this.updateStatus();
                    SvnPropertiesView.this.tableViewer.setInput((Object)SvnPropertiesView.this.getSvnProperties());
                    SvnPropertiesView.this.tableViewer.refresh();
                }
                catch (SVNException sVNException) {}
            }
        });
    }

    private void updateStatus() {
        if (this.resource == null) {
            this.statusLabel.setText("");
            return;
        }
        try {
            LocalResourceStatus status = this.resource.getStatus();
            if (!this.resource.isManaged()) {
                this.statusLabel.setText(Policy.bind("SvnPropertiesView.resourceNotManaged"));
            } else if (status.getPropStatus().equals((Object)SVNStatusKind.MODIFIED)) {
                this.statusLabel.setText(Policy.bind("SvnPropertiesView.somePropertiesModified"));
            } else if (status.getPropStatus().equals((Object)SVNStatusKind.NORMAL)) {
                this.statusLabel.setText(Policy.bind("SvnPropertiesView.noPropertiesModified"));
            } else if (status.getPropStatus().equals((Object)SVNStatusKind.CONFLICTED)) {
                this.statusLabel.setText(Policy.bind("SvnPropertiesView.conflictOnProperties"));
            }
        }
        catch (SVNException sVNException) {
            this.statusLabel.setText(Policy.bind("SvnPropertiesView.errorGettingStatus"));
        }
    }

    public void showSvnProperties(ISVNLocalResource resource) throws SVNException {
        this.resource = resource;
        if (resource != null) {
            this.setContentDescription(Policy.bind("SvnPropertiesView.titleWithArgument", resource.getName()));
        } else {
            this.setContentDescription("");
        }
        this.refresh();
    }

    private ISVNProperty[] getSvnProperties() throws SVNException {
        if (this.resource == null) {
            return null;
        }
        if (this.resource.isManaged()) {
            return this.resource.getSvnProperties();
        }
        return null;
    }

    class ResourceStateChangeListener
    implements IResourceStateChangeListener {
        ResourceStateChangeListener() {
        }

        public void resourceSyncInfoChanged(IResource[] changedResources) {
            int i = 0;
            while (i < changedResources.length) {
                if (SvnPropertiesView.this.resource != null && changedResources[i].equals((Object)SvnPropertiesView.this.resource.getIResource())) {
                    SvnPropertiesView.this.refresh();
                }
                ++i;
            }
        }

        public void resourceModified(IResource[] changedResources) {
        }

        public void projectConfigured(IProject project) {
        }

        public void projectDeconfigured(IProject project) {
        }
    }

    class PropertiesLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            ISVNProperty svnProperty = (ISVNProperty)element;
            String result = null;
            switch (columnIndex) {
                case 0: {
                    result = svnProperty.getName();
                    break;
                }
                case 1: {
                    result = svnProperty.getValue();
                }
            }
            if (result == null) {
                result = "";
            }
            return result;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

