/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.UpdateResourcesCommand;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class UpdateOperation
extends RepositoryProviderOperation {
    private final SVNRevision revision;
    private int depth = -2;
    private boolean setDepth = false;
    private boolean ignoreExternals = false;
    private boolean force = true;
    private boolean canRunAsJob = true;

    public UpdateOperation(IWorkbenchPart part, IResource resource, SVNRevision revision) {
        super(part, new IResource[]{resource});
        this.revision = revision;
    }

    public UpdateOperation(IWorkbenchPart part, IResource[] resources, SVNRevision revision) {
        super(part, resources);
        this.revision = revision;
    }

    protected String getTaskName() {
        return Policy.bind("UpdateOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("UpdateOperation.0", provider.getProject().getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, 100);
        try {
            try {
                SVNWorkspaceSubscriber.getInstance().updateRemote(resources);
                UpdateResourcesCommand command = new UpdateResourcesCommand(provider.getSVNWorkspaceRoot(), resources, this.revision);
                command.setDepth(this.depth);
                command.setSetDepth(this.setDepth);
                command.setIgnoreExternals(this.ignoreExternals);
                command.setForce(this.force);
                command.run(Policy.subMonitorFor(monitor, 100));
            }
            catch (SVNException e) {
                this.collectStatus(e.getStatus());
            }
            catch (TeamException e) {
                this.collectStatus(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        monitor.done();
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }

    protected boolean canRunAsJob() {
        return this.canRunAsJob;
    }
}

