/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.SwitchToUrlCommand;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchOperation
extends RepositoryProviderOperation {
    private SVNRevision svnRevision;
    private HashMap urlMap = new HashMap();
    private int depth = -2;
    private boolean setDepth = false;
    private boolean ignoreExternals = false;
    private boolean force = true;
    private boolean canRunAsJob = true;

    public SwitchOperation(IWorkbenchPart part, IResource[] resources, SVNUrl[] svnUrls, SVNRevision svnRevision) {
        super(part, resources);
        this.svnRevision = svnRevision;
        int i = 0;
        while (i < resources.length) {
            this.urlMap.put(resources[i], svnUrls[i]);
            ++i;
        }
    }

    protected String getTaskName() {
        return Policy.bind("SwitchOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("SwitchOperation.0", provider.getProject().getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask("Switch to Branch/Tag", resources.length);
        try {
            try {
                int i = 0;
                while (i < resources.length) {
                    monitor.subTask("Switching " + resources[i].getName() + ". . .");
                    SVNUrl svnUrl = (SVNUrl)this.urlMap.get(resources[i]);
                    SVNWorkspaceSubscriber.getInstance().updateRemote(resources);
                    SwitchToUrlCommand command = new SwitchToUrlCommand(provider.getSVNWorkspaceRoot(), resources[i], svnUrl, this.svnRevision);
                    command.setDepth(this.depth);
                    command.setSetDepth(this.setDepth);
                    command.setIgnoreExternals(this.ignoreExternals);
                    command.setForce(this.force);
                    command.run(monitor);
                    monitor.worked(1);
                    ++i;
                }
            }
            catch (SVNException e) {
                this.collectStatus(e.getStatus());
            }
            catch (TeamException e) {
                this.collectStatus(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        monitor.done();
    }

    protected boolean canRunAsJob() {
        return this.canRunAsJob;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }
}

