/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.history;

import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.history.HistoryFolder;
import org.tigris.subversion.subclipse.ui.history.SVNHistoryPage;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ChangePathsTreeViewer
extends TreeViewer {
    ILogEntry currentLogEntry;
    Font currentPathFont;
    static final LogEntryChangePath[] EMPTY_CHANGE_PATHS = new LogEntryChangePath[0];

    public ChangePathsTreeViewer(Composite parent, SVNHistoryPage page) {
        this(parent, (IContentProvider)new ChangePathsTreeContentProvider(page));
    }

    public ChangePathsTreeViewer(Composite parent, IContentProvider contentProvider) {
        super(parent, 770);
        GridData data = new GridData(1808);
        this.getControl().setLayoutData((Object)data);
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChangePathsTreeViewer.this.currentPathFont != null) {
                    ChangePathsTreeViewer.this.currentPathFont.dispose();
                }
            }
        });
        this.setLabelProvider((IBaseLabelProvider)new ChangePathLabelProvider());
        this.setContentProvider(contentProvider);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.currentLogEntry = (ILogEntry)input;
        this.expandAll();
        TreeItem[] items = ((Tree)this.getControl()).getItems();
        if (items != null && items.length > 0) {
            this.setSelection(Collections.singletonList(items[0]));
            ((Tree)this.getControl()).showSelection();
        }
    }

    public void setCurrentLogEntry(ILogEntry currentLogEntry) {
        this.currentLogEntry = currentLogEntry;
    }

    class ChangePathLabelProvider
    extends LabelProvider
    implements IFontProvider,
    IColorProvider {
        ChangePathLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof LogEntryChangePath) {
                LogEntryChangePath changePath = (LogEntryChangePath)element;
                String path = changePath.getPath();
                int n = path.lastIndexOf(47);
                if (n > -1) {
                    path = path.substring(n + 1);
                }
                if (changePath.getCopySrcPath() == null) {
                    return path;
                }
                return String.valueOf(path) + " [" + Policy.bind("ChangePathsTableProvider.copiedfrom", changePath.getCopySrcPath(), changePath.getCopySrcRevision().toString()) + "]";
            }
            if (element instanceof HistoryFolder) {
                HistoryFolder f = (HistoryFolder)element;
                if (f.getCopySrcPath() == null) {
                    return String.valueOf(f.getPath()) + (f.getChildCount() == 0 ? "" : " [" + f.getChildCount() + "]");
                }
                return String.valueOf(f.getPath()) + (f.getChildCount() == 0 ? " [" : " [" + f.getChildCount() + "] [") + Policy.bind("ChangePathsTableProvider.copiedfrom", f.getCopySrcPath(), f.getCopySrcRevision().toString()) + "]";
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            String id = null;
            if (element instanceof LogEntryChangePath) {
                LogEntryChangePath changePath = (LogEntryChangePath)element;
                switch (changePath.getAction()) {
                    case 'A': {
                        id = "pending16/fileadd_pending.gif";
                        break;
                    }
                    case 'D': {
                        id = "pending16/filedelete_pending.gif";
                        break;
                    }
                    default: {
                        id = "pending16/filemodified_pending.gif";
                        break;
                    }
                }
            } else if (element instanceof HistoryFolder) {
                HistoryFolder folder = (HistoryFolder)element;
                if (folder.getChildren().length == 0) {
                    switch (folder.getAction()) {
                        case 'A': {
                            id = "pending16/fileadd_pending.gif";
                            break;
                        }
                        case 'D': {
                            id = "pending16/filedelete_pending.gif";
                            break;
                        }
                        default: {
                            id = "pending16/filemodified_pending.gif";
                            break;
                        }
                    }
                } else {
                    switch (folder.getAction()) {
                        case 'A': {
                            id = "pending16/folderadd_pending.gif";
                            break;
                        }
                        case 'D': {
                            id = "pending16/folderdelete_pending.gif";
                            break;
                        }
                        case 'M': {
                            id = "pending16/foldermodified_pending.gif";
                            break;
                        }
                        default: {
                            id = "pending16/folder_pending.gif";
                        }
                    }
                }
            }
            if (id == null) {
                return null;
            }
            return SVNUIPlugin.getImage(id);
        }

        public Font getFont(Object element) {
            if (element == null || ChangePathsTreeViewer.this.currentLogEntry == null || !(element instanceof LogEntryChangePath)) {
                return null;
            }
            ISVNRemoteResource remoteResource = ChangePathsTreeViewer.this.currentLogEntry.getRemoteResource();
            if (remoteResource == null) {
                return null;
            }
            SVNUrl currentUrl = remoteResource.getUrl();
            if (currentUrl == null) {
                return null;
            }
            SVNUrl url = ((LogEntryChangePath)element).getUrl();
            if (currentUrl.equals((Object)url)) {
                if (ChangePathsTreeViewer.this.currentPathFont == null) {
                    Font defaultFont = JFaceResources.getDefaultFont();
                    FontData[] data = defaultFont.getFontData();
                    int i = 0;
                    while (i < data.length) {
                        data[i].setStyle(1);
                        ++i;
                    }
                    ChangePathsTreeViewer.this.currentPathFont = new Font((Device)ChangePathsTreeViewer.this.getControl().getDisplay(), data);
                }
                return ChangePathsTreeViewer.this.currentPathFont;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (ChangePathsTreeViewer.this.currentLogEntry == null) {
                return null;
            }
            ISVNResource resource = ChangePathsTreeViewer.this.currentLogEntry.getResource();
            if (resource == null) {
                return null;
            }
            boolean isPartOfSelection = false;
            if (element instanceof HistoryFolder) {
                HistoryFolder historyFolder = (HistoryFolder)element;
                isPartOfSelection = (String.valueOf(resource.getRepository().getUrl().toString()) + historyFolder.getPath()).startsWith(ChangePathsTreeViewer.this.currentLogEntry.getResource().getUrl().toString());
            }
            if (element instanceof LogEntryChangePath) {
                LogEntryChangePath logEntryChangePath = (LogEntryChangePath)element;
                isPartOfSelection = (String.valueOf(resource.getRepository().getUrl().toString()) + logEntryChangePath.getPath()).startsWith(ChangePathsTreeViewer.this.currentLogEntry.getResource().getUrl().toString());
            }
            if (!isPartOfSelection) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }
    }

    static class ChangePathsTreeContentProvider
    implements ITreeContentProvider {
        private final SVNHistoryPage page;

        ChangePathsTreeContentProvider(SVNHistoryPage page) {
            this.page = page;
        }

        public Object[] getChildren(Object parentElement) {
            if (this.page != null && !this.page.isShowChangePaths()) {
                return null;
            }
            if (parentElement instanceof HistoryFolder) {
                return ((HistoryFolder)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof HistoryFolder) {
                HistoryFolder folder = (HistoryFolder)element;
                return folder.getChildren().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (this.page != null && !this.page.isShowChangePaths() || !(inputElement instanceof ILogEntry)) {
                return EMPTY_CHANGE_PATHS;
            }
            if (this.page != null) {
                LogEntryChangePath[] cfr_ignored_0 = this.page.currentLogEntryChangePath;
            }
            ILogEntry logEntry = (ILogEntry)inputElement;
            if (SVNProviderPlugin.getPlugin().getSVNClientManager().isFetchChangePathOnDemand()) {
                if (this.page != null && this.page.currentLogEntryChangePath != null) {
                    return this.getGroups(this.page.currentLogEntryChangePath);
                }
                if (this.page != null) {
                    this.page.scheduleFetchChangePathJob(logEntry);
                }
                return EMPTY_CHANGE_PATHS;
            }
            return this.getGroups(logEntry.getLogEntryChangePaths());
        }

        private Object[] getGroups(LogEntryChangePath[] changePaths) {
            HashSet<String> folderNames = new HashSet<String>();
            int i = 0;
            while (i < changePaths.length) {
                folderNames.add(this.getFolderName(changePaths[i]));
                ++i;
            }
            TreeMap<String, HistoryFolder> folders = new TreeMap<String, HistoryFolder>();
            int i2 = 0;
            while (i2 < changePaths.length) {
                HistoryFolder folder;
                LogEntryChangePath changePath = changePaths[i2];
                String path = changePath.getPath();
                if (folderNames.contains(path)) {
                    folder = (HistoryFolder)folders.get(path);
                    if (folder == null) {
                        folder = new HistoryFolder(changePath);
                        folders.put(path, folder);
                    }
                } else {
                    path = this.getFolderName(changePath);
                    folder = (HistoryFolder)folders.get(path);
                    if (folder == null) {
                        folder = new HistoryFolder(path);
                        folders.put(path, folder);
                    }
                    folder.add(changePath);
                }
                ++i2;
            }
            return folders.values().toArray(new Object[folders.size()]);
        }

        private String getFolderName(LogEntryChangePath changePath) {
            String path = changePath.getPath();
            int n = path.lastIndexOf(47);
            return n > -1 ? path.substring(0, n) : path;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.page != null) {
                this.page.currentLogEntryChangePath = null;
            }
        }
    }
}

