/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.dialogs.SvnDialog;
import org.tigris.subversion.subclipse.ui.operations.ShowDifferencesAsUnifiedDiffOperationWC;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ShowDifferencesAsUnifiedDiffDialogWC
extends SvnDialog {
    private IResource resource;
    private IWorkbenchPart targetPart;
    private Button compareButton;
    private Button diffButton;
    private Text fileText;
    private Button browseButton;
    private UrlCombo toUrlText;
    private Button toHeadButton;
    private Text toRevisionText;
    private Button toLogButton;
    private Button okButton;
    private boolean success;
    private File file;
    private SVNUrl toUrl;
    private SVNRevision toRevision;
    private ISVNLocalResource svnResource;
    private boolean diffToOutputFile;

    public ShowDifferencesAsUnifiedDiffDialogWC(Shell parentShell, IResource resource, IWorkbenchPart targetPart) {
        super(parentShell, "ShowDifferencesAsUnifiedDiffDialogWC");
        this.resource = resource;
        this.targetPart = targetPart;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.branchTag"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group fromGroup = new Group(composite, 0);
        fromGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareFrom"));
        GridLayout fromLayout = new GridLayout();
        fromLayout.numColumns = 2;
        fromGroup.setLayout((Layout)fromLayout);
        GridData data = new GridData(4, 4, true, false);
        fromGroup.setLayoutData((Object)data);
        Label pathLabel = new Label((Composite)fromGroup, 0);
        pathLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.path"));
        Text pathText = new Text((Composite)fromGroup, 2048);
        data = new GridData(768);
        pathText.setLayoutData((Object)data);
        pathText.setEditable(false);
        pathText.setText(this.resource.getFullPath().toString());
        Group toGroup = new Group(composite, 0);
        toGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareTo"));
        GridLayout toLayout = new GridLayout();
        toLayout.numColumns = 3;
        toGroup.setLayout((Layout)toLayout);
        data = new GridData(4, 4, true, false);
        toGroup.setLayoutData((Object)data);
        Label toUrlLabel = new Label((Composite)toGroup, 0);
        toUrlLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.url"));
        this.toUrlText = new UrlCombo((Composite)toGroup, 0);
        this.toUrlText.init(this.resource.getProject().getName());
        this.toUrlText.setLayoutData(new GridData(768));
        ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
        this.toUrlText.setText(localResource.getUrl().toString());
        Button urlBrowseButton = new Button((Composite)toGroup, 8);
        urlBrowseButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.browse"));
        urlBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(ShowDifferencesAsUnifiedDiffDialogWC.this.getShell(), ShowDifferencesAsUnifiedDiffDialogWC.this.resource);
                if (ShowDifferencesAsUnifiedDiffDialogWC.this.resource instanceof IContainer) {
                    dialog.setFoldersOnly(true);
                }
                if (dialog.open() == 1) {
                    return;
                }
                String url = dialog.getUrl();
                if (url != null) {
                    ShowDifferencesAsUnifiedDiffDialogWC.this.toUrlText.setText(url);
                }
                ShowDifferencesAsUnifiedDiffDialogWC.this.setOkButtonStatus();
            }
        });
        Composite toRevisionGroup = new Composite((Composite)toGroup, 0);
        GridLayout toRevisionLayout = new GridLayout();
        toRevisionLayout.numColumns = 3;
        toRevisionLayout.marginWidth = 0;
        toRevisionLayout.marginHeight = 0;
        toRevisionGroup.setLayout((Layout)toRevisionLayout);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        toRevisionGroup.setLayoutData((Object)data);
        this.toHeadButton = new Button(toRevisionGroup, 32);
        this.toHeadButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.toHeadButton.setLayoutData((Object)data);
        this.toHeadButton.setSelection(true);
        Label revisionLabel = new Label(toRevisionGroup, 0);
        revisionLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.revision"));
        this.toRevisionText = new Text(toRevisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.toRevisionText.setLayoutData((Object)data);
        this.toRevisionText.setEnabled(false);
        this.toLogButton = new Button(toRevisionGroup, 8);
        this.toLogButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.showLog"));
        this.toLogButton.setEnabled(false);
        this.toLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowDifferencesAsUnifiedDiffDialogWC.this.showLog(e.getSource());
            }
        });
        Group fileGroup = new Group(composite, 0);
        fileGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareType"));
        GridLayout fileLayout = new GridLayout();
        fileLayout.numColumns = 3;
        fileGroup.setLayout((Layout)fileLayout);
        data = new GridData(4, 4, true, false);
        fileGroup.setLayoutData((Object)data);
        this.compareButton = new Button((Composite)fileGroup, 16);
        this.compareButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.graphical"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.compareButton.setLayoutData((Object)data);
        this.diffButton = new Button((Composite)fileGroup, 16);
        this.diffButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.diff"));
        this.compareButton.setSelection(true);
        this.fileText = new Text((Composite)fileGroup, 2048);
        data = new GridData(768);
        this.fileText.setLayoutData((Object)data);
        this.fileText.setEnabled(false);
        this.browseButton = new Button((Composite)fileGroup, 8);
        this.browseButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.fileBrowse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ShowDifferencesAsUnifiedDiffDialogWC.this.getShell(), 8192);
                dialog.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.fileDialogText"));
                dialog.setFileName("revision.diff");
                String outFile = dialog.open();
                if (outFile != null) {
                    ShowDifferencesAsUnifiedDiffDialogWC.this.fileText.setText(outFile);
                }
            }
        });
        this.toUrlText.setFocus();
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ShowDifferencesAsUnifiedDiffDialogWC.this.setOkButtonStatus();
            }
        };
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowDifferencesAsUnifiedDiffDialogWC.this.toRevisionText.setEnabled(!ShowDifferencesAsUnifiedDiffDialogWC.this.toHeadButton.getSelection());
                ShowDifferencesAsUnifiedDiffDialogWC.this.toLogButton.setEnabled(!ShowDifferencesAsUnifiedDiffDialogWC.this.toHeadButton.getSelection() && ShowDifferencesAsUnifiedDiffDialogWC.this.toUrlText.getText().trim().length() > 0);
                ShowDifferencesAsUnifiedDiffDialogWC.this.setOkButtonStatus();
                if (e.getSource() == ShowDifferencesAsUnifiedDiffDialogWC.this.toHeadButton && !ShowDifferencesAsUnifiedDiffDialogWC.this.toHeadButton.getSelection()) {
                    ShowDifferencesAsUnifiedDiffDialogWC.this.toRevisionText.selectAll();
                    ShowDifferencesAsUnifiedDiffDialogWC.this.toRevisionText.setFocus();
                }
            }
        };
        SelectionAdapter compareTypeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ShowDifferencesAsUnifiedDiffDialogWC.this.diffButton.getSelection()) {
                    ShowDifferencesAsUnifiedDiffDialogWC.this.fileText.setEnabled(true);
                    ShowDifferencesAsUnifiedDiffDialogWC.this.browseButton.setEnabled(true);
                    ShowDifferencesAsUnifiedDiffDialogWC.this.fileText.selectAll();
                    ShowDifferencesAsUnifiedDiffDialogWC.this.fileText.setFocus();
                } else {
                    ShowDifferencesAsUnifiedDiffDialogWC.this.fileText.setEnabled(false);
                    ShowDifferencesAsUnifiedDiffDialogWC.this.browseButton.setEnabled(false);
                }
                ShowDifferencesAsUnifiedDiffDialogWC.this.setOkButtonStatus();
            }
        };
        this.fileText.addModifyListener(modifyListener);
        this.toUrlText.getCombo().addModifyListener(modifyListener);
        this.toRevisionText.addModifyListener(modifyListener);
        this.toHeadButton.addSelectionListener((SelectionListener)selectionListener);
        this.compareButton.addSelectionListener((SelectionListener)compareTypeListener);
        this.diffButton.addSelectionListener((SelectionListener)compareTypeListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.toRevisionText.addFocusListener((FocusListener)focusListener);
        this.fileText.addFocusListener((FocusListener)focusListener);
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
        }
        return button;
    }

    protected void okPressed() {
        this.success = true;
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    if (ShowDifferencesAsUnifiedDiffDialogWC.this.toHeadButton.getSelection()) {
                        ShowDifferencesAsUnifiedDiffDialogWC.this.toRevision = SVNRevision.HEAD;
                    } else {
                        int toRevisionInt = Integer.parseInt(ShowDifferencesAsUnifiedDiffDialogWC.this.toRevisionText.getText().trim());
                        long toRevisionLong = toRevisionInt;
                        ShowDifferencesAsUnifiedDiffDialogWC.this.toRevision = (SVNRevision)new SVNRevision.Number(toRevisionLong);
                    }
                    ShowDifferencesAsUnifiedDiffDialogWC.this.toUrl = new SVNUrl(ShowDifferencesAsUnifiedDiffDialogWC.this.toUrlText.getText().trim());
                    File path = new File(ShowDifferencesAsUnifiedDiffDialogWC.this.resource.getLocation().toString());
                    ShowDifferencesAsUnifiedDiffDialogWC.this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)ShowDifferencesAsUnifiedDiffDialogWC.this.resource);
                    ISVNClientAdapter svnClient = ShowDifferencesAsUnifiedDiffDialogWC.this.svnResource.getRepository().getSVNClient();
                    ISVNInfo svnInfo = svnClient.getInfo(ShowDifferencesAsUnifiedDiffDialogWC.this.toUrl, ShowDifferencesAsUnifiedDiffDialogWC.this.toRevision, ShowDifferencesAsUnifiedDiffDialogWC.this.toRevision);
                    SVNNodeKind nodeKind = svnInfo.getNodeKind();
                    if (ShowDifferencesAsUnifiedDiffDialogWC.this.resource instanceof IContainer) {
                        if (nodeKind.toInt() == SVNNodeKind.FILE.toInt()) {
                            MessageDialog.openError((Shell)ShowDifferencesAsUnifiedDiffDialogWC.this.getShell(), (String)Policy.bind("ShowDifferencesAsUnifiedDiffDialog.branchTag"), (String)Policy.bind("ShowDifferencesAsUnifiedDiffDialog.fileToFolder"));
                            ShowDifferencesAsUnifiedDiffDialogWC.this.success = false;
                            return;
                        }
                    } else if (nodeKind.toInt() == SVNNodeKind.DIR.toInt()) {
                        MessageDialog.openError((Shell)ShowDifferencesAsUnifiedDiffDialogWC.this.getShell(), (String)Policy.bind("ShowDifferencesAsUnifiedDiffDialog.branchTag"), (String)Policy.bind("ShowDifferencesAsUnifiedDiffDialog.fileToFolder"));
                        ShowDifferencesAsUnifiedDiffDialogWC.this.success = false;
                        return;
                    }
                    if (ShowDifferencesAsUnifiedDiffDialogWC.this.diffButton.getSelection()) {
                        ShowDifferencesAsUnifiedDiffDialogWC.this.diffToOutputFile = true;
                        ShowDifferencesAsUnifiedDiffDialogWC.this.file = new File(ShowDifferencesAsUnifiedDiffDialogWC.this.fileText.getText().trim());
                        if (ShowDifferencesAsUnifiedDiffDialogWC.this.file.exists() && !MessageDialog.openQuestion((Shell)ShowDifferencesAsUnifiedDiffDialogWC.this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)Policy.bind("HistoryView.overwriteOutfile", ShowDifferencesAsUnifiedDiffDialogWC.this.file.getName()))) {
                            return;
                        }
                        new ShowDifferencesAsUnifiedDiffOperationWC(ShowDifferencesAsUnifiedDiffDialogWC.this.targetPart, path, ShowDifferencesAsUnifiedDiffDialogWC.this.toUrl, ShowDifferencesAsUnifiedDiffDialogWC.this.toRevision, ShowDifferencesAsUnifiedDiffDialogWC.this.file).run();
                    } else {
                        ShowDifferencesAsUnifiedDiffDialogWC.this.diffToOutputFile = false;
                        ShowDifferencesAsUnifiedDiffDialogWC.this.success = true;
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)ShowDifferencesAsUnifiedDiffDialogWC.this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)e.getMessage());
                    ShowDifferencesAsUnifiedDiffDialogWC.this.success = false;
                }
            }
        });
        if (!this.success) {
            return;
        }
        this.toUrlText.saveUrl();
        super.okPressed();
    }

    private void setOkButtonStatus() {
        boolean canFinish = true;
        if (this.diffButton.getSelection() && this.fileText.getText().trim().length() == 0) {
            canFinish = false;
        }
        if (this.toUrlText.getText().trim().length() == 0) {
            canFinish = false;
        }
        if (!this.toHeadButton.getSelection() && this.toRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        }
        this.okButton.setEnabled(canFinish);
    }

    private void showLog(Object sourceButton) {
        try {
            SVNUrl url = new SVNUrl(this.toUrlText.getText().trim());
            ISVNRemoteFile remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository().getRemoteFile(url);
            HistoryDialog dialog = new HistoryDialog(this.getShell(), (ISVNRemoteResource)remoteResource);
            if (dialog.open() == 1) {
                return;
            }
            ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
            if (selectedEntries.length == 0) {
                return;
            }
            this.toRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)e.getMessage());
        }
        this.setOkButtonStatus();
    }

    public SVNUrl getToUrl() {
        return this.toUrl;
    }

    public SVNRevision getToRevision() {
        return this.toRevision;
    }

    public ISVNLocalResource getSvnResource() {
        return this.svnResource;
    }

    public boolean isDiffToOutputFile() {
        return this.diffToOutputFile;
    }
}

