/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.history.HistoryTableProvider;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.subclipse.ui.operations.UpdateOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNCompareRevisionsInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    private IFile resource;
    private ILogEntry[] logEntries;
    private TableViewer viewer;
    private Action getContentsAction;
    private Action getRevisionAction;
    private Shell shell;
    private HistoryTableProvider historyTableProvider;
    static /* synthetic */ Class class$0;

    public SVNCompareRevisionsInput(IFile resource, ILogEntry[] logEntries) {
        super(new CompareConfiguration());
        this.resource = resource;
        this.logEntries = logEntries;
        this.updateCurrentEdition();
        this.initializeActions();
    }

    public Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        c.setLayoutData((Object)new GridData(1808));
        this.historyTableProvider.setSortColumn(this.viewer, 0);
        this.historyTableProvider.setSortColumn(this.viewer, 0);
        return c;
    }

    public Viewer createDiffViewer(Composite parent) {
        this.shell = parent.getShell();
        this.viewer = this.getHistoryTableProvider().createTable(parent);
        Table table = this.viewer.getTable();
        table.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Policy.bind("SVNCompareRevisionsInput.structureCompare"));
        this.viewer.setContentProvider((IContentProvider)new VersionCompareContentProvider());
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mm) {
                mm.add((IAction)SVNCompareRevisionsInput.this.getContentsAction);
                mm.add((IAction)SVNCompareRevisionsInput.this.getRevisionAction);
            }
        });
        table.setMenu(mm.createContextMenu((Control)table));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    SVNCompareRevisionsInput.this.getContentsAction.setEnabled(false);
                    SVNCompareRevisionsInput.this.getRevisionAction.setEnabled(false);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                SVNCompareRevisionsInput.this.getContentsAction.setEnabled(ss.size() == 1);
                SVNCompareRevisionsInput.this.getRevisionAction.setEnabled(ss.size() == 1);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)table, "org.tigris.subversion.subclipse.ui.compare_revision_view_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getContentsAction, "org.tigris.subversion.subclipse.ui.get_file_contents_action_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.tigris.subversion.subclipse.ui.get_file_revision_action_context");
        this.viewer.resetFilters();
        return this.viewer;
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        String resourceName = this.resource.getName();
        this.setTitle(Policy.bind("SVNCompareRevisionsInput.compareResourceAndVersions", new Object[]{resourceName}));
        cc.setLeftEditable(true);
        cc.setRightEditable(false);
        String leftLabel = Policy.bind("SVNCompareRevisionsInput.workspace", new Object[]{resourceName});
        cc.setLeftLabel(leftLabel);
        String rightLabel = Policy.bind("SVNCompareRevisionsInput.repository", new Object[]{resourceName});
        cc.setRightLabel(rightLabel);
    }

    private void initializeActions() {
        this.getContentsAction = new Action(Policy.bind("HistoryView.getContentsAction"), null){

            public void run() {
                try {
                    new ProgressMonitorDialog(SVNCompareRevisionsInput.this.shell).run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                            IStructuredSelection selection = (IStructuredSelection)SVNCompareRevisionsInput.access$5(4.access$0(this.this$1)).getSelection();
                            if (selection.size() != 1) {
                                return;
                            }
                            VersionCompareDiffNode node = (VersionCompareDiffNode)((Object)selection.getFirstElement());
                            ResourceEditionNode right = (ResourceEditionNode)node.getRight();
                            ISVNRemoteResource edition = right.getRemoteResource();
                            try {
                                try {
                                    monitor.beginTask(null, 100);
                                    InputStream in = edition.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 50)).getContents();
                                    SVNCompareRevisionsInput.access$0(4.access$0(this.this$1)).setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var7_10 = null;
                                monitor.done();
                                throw throwable;
                            }
                            {
                                Object var7_11 = null;
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    SVNCompareRevisionsInput.this.handle(e);
                }
                SVNCompareRevisionsInput.this.updateCurrentEdition();
                SVNCompareRevisionsInput.this.viewer.refresh();
            }

            static /* synthetic */ SVNCompareRevisionsInput access$0(4 var0) {
                return var0.SVNCompareRevisionsInput.this;
            }
        };
        this.getRevisionAction = new Action(Policy.bind("HistoryView.getRevisionAction"), null){

            public void run() {
                try {
                    new ProgressMonitorDialog(SVNCompareRevisionsInput.this.shell).run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(this, null){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IStructuredSelection selection = (IStructuredSelection)SVNCompareRevisionsInput.access$5(6.access$0(this.this$1)).getSelection();
                            if (selection.size() != 1) {
                                return;
                            }
                            VersionCompareDiffNode node = (VersionCompareDiffNode)((Object)selection.getFirstElement());
                            ResourceEditionNode right = (ResourceEditionNode)node.getRight();
                            ISVNRemoteFile edition = (ISVNRemoteFile)right.getRemoteResource();
                            new UpdateOperation(null, (IResource)SVNCompareRevisionsInput.access$0(6.access$0(this.this$1)), (SVNRevision)edition.getLastChangedRevision()).run(monitor);
                            6.access$0(this.this$1).getHistoryTableProvider().setRemoteResource((ISVNRemoteResource)edition);
                            SVNCompareRevisionsInput.access$5(6.access$0(this.this$1)).refresh();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    SVNCompareRevisionsInput.this.handle(e);
                }
            }

            static /* synthetic */ SVNCompareRevisionsInput access$0(6 var0) {
                return var0.SVNCompareRevisionsInput.this;
            }
        };
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        this.initLabels();
        DiffNode diffRoot = new DiffNode(0);
        int i = 0;
        while (i < this.logEntries.length) {
            TypedBufferedContent left = new TypedBufferedContent(this.resource);
            ResourceRevisionNode right = new ResourceRevisionNode(this.logEntries[i]);
            diffRoot.add((IDiffElement)new VersionCompareDiffNode((ITypedElement)left, right));
            ++i;
        }
        return diffRoot;
    }

    private void updateCurrentEdition() {
        try {
            this.getHistoryTableProvider().setRemoteResource((ISVNRemoteResource)((ISVNRemoteFile)SVNWorkspaceRoot.getBaseResourceFor((IResource)this.resource)));
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e));
        }
    }

    private void handle(Exception e) {
        this.setMessage(SVNUIPlugin.openError(this.shell, null, null, e, 12).getMessage());
    }

    public HistoryTableProvider getHistoryTableProvider() {
        if (this.historyTableProvider == null) {
            this.historyTableProvider = new HistoryTableProvider();
        }
        return this.historyTableProvider;
    }

    public void replaceLocalWithCurrentlySelectedRevision() throws CoreException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        VersionCompareDiffNode node = (VersionCompareDiffNode)((Object)selection.getFirstElement());
        ResourceRevisionNode right = (ResourceRevisionNode)node.getRight();
        TypedBufferedContent left = (TypedBufferedContent)node.getLeft();
        left.setContent(Utils.readBytes(right.getContents()));
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    class TypedBufferedContent
    extends ResourceNode {
        public TypedBufferedContent(IFile resource) {
            super((IResource)resource);
        }

        protected InputStream createStream() throws CoreException {
            return ((IFile)this.getResource()).getContents();
        }

        public void setContent(byte[] contents) {
            if (contents == null) {
                contents = new byte[]{};
            }
            ByteArrayInputStream is = new ByteArrayInputStream(contents);
            IRunnableWithProgress runnable = new IRunnableWithProgress(this, is){
                final /* synthetic */ TypedBufferedContent this$1;
                private final /* synthetic */ InputStream val$is;
                {
                    this.this$1 = typedBufferedContent;
                    this.val$is = inputStream;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IFile file = SVNCompareRevisionsInput.access$0(TypedBufferedContent.access$0(this.this$1));
                        if (this.val$is != null) {
                            if (!file.exists()) {
                                file.create(this.val$is, false, monitor);
                            } else {
                                file.setContents(this.val$is, false, true, monitor);
                            }
                        } else {
                            file.delete(false, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(SVNCompareRevisionsInput.this.shell).run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                SVNUIPlugin.openError(SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), Policy.bind("TeamFile.saveChanges", SVNCompareRevisionsInput.this.resource.getName()), null, e);
            }
            catch (InterruptedException interruptedException) {}
            this.fireContentChanged();
        }

        public ITypedElement replace(ITypedElement child, ITypedElement other) {
            return null;
        }

        static /* synthetic */ SVNCompareRevisionsInput access$0(TypedBufferedContent typedBufferedContent) {
            return typedBufferedContent.SVNCompareRevisionsInput.this;
        }
    }

    class ResourceRevisionNode
    extends ResourceEditionNode {
        ILogEntry entry;

        public ResourceRevisionNode(ILogEntry entry) {
            super(entry.getRemoteResource());
            this.entry = entry;
        }

        public ILogEntry getLogEntry() {
            return this.entry;
        }

        public String getName() {
            IFile resource = SVNCompareRevisionsInput.this.resource;
            try {
                ISVNRemoteFile currentEdition = (ISVNRemoteFile)SVNWorkspaceRoot.getBaseResourceFor((IResource)resource);
                if (currentEdition == null || !currentEdition.getLastChangedRevision().equals((Object)this.entry.getRevision())) {
                    return this.entry.getRevision().toString();
                }
                Policy.bind("currentRevision", this.entry.getRevision().toString());
            }
            catch (TeamException e) {
                SVNCompareRevisionsInput.this.handle((Exception)((Object)e));
            }
            return super.getName();
        }
    }

    class VersionCompareDiffNode
    extends DiffNode
    implements IAdaptable {
        public VersionCompareDiffNode(ITypedElement left, ITypedElement right) {
            super(left, right);
        }

        public String getName() {
            return this.getRight().getName();
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.tigris.subversion.subclipse.core.history.ILogEntry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return ((ResourceRevisionNode)this.getRight()).getLogEntry();
            }
            return null;
        }
    }

    class VersionCompareContentProvider
    implements IStructuredContentProvider {
        VersionCompareContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DiffContainer) {
                return ((DiffContainer)inputElement).getChildren();
            }
            return null;
        }
    }
}

