/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.team.ui.SaveablePartDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.compare.SVNCompareRevisionsInput;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CompareWithRevisionAction
extends WorkbenchWindowAction {
    private boolean refresh;

    protected ISVNRemoteFile getSelectedRemoteFile() {
        IResource[] resources = this.getSelectedResources();
        if (resources.length != 1) {
            return null;
        }
        if (!(resources[0] instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)resources[0];
        try {
            return (ISVNRemoteFile)SVNWorkspaceRoot.getBaseResourceFor((IResource)file);
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e), null, null);
            return null;
        }
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.refresh = false;
        final ISVNRemoteFile[] file = new ISVNRemoteFile[1];
        final ILogEntry[][] entries = new ILogEntry[1][];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                file[0] = CompareWithRevisionAction.this.getSelectedRemoteFile();
            }
        }, false, 2);
        if (file[0] == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Policy.bind("CompareWithRevisionAction.noRevisions"), (String)Policy.bind("CompareWithRevisionAction.noRevisionsLong"));
            return;
        }
        if (!file[0].getResource().isSynchronized(2)) {
            this.refresh = MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("DifferencesDialog.compare"), (String)Policy.bind("CompareWithRemoteAction.fileChanged"));
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask(Policy.bind("CompareWithRevisionAction.fetching"), 100);
                    AliasManager tagManager = null;
                    IResource[] resources = CompareWithRevisionAction.this.getSelectedResources();
                    if (CompareWithRevisionAction.this.refresh) {
                        resources[0].refreshLocal(2, monitor);
                    }
                    if (resources.length == 1) {
                        tagManager = new AliasManager(resources[0]);
                    }
                    GetLogsCommand logCmd = new GetLogsCommand((ISVNRemoteResource)file[0], SVNRevision.HEAD, SVNRevision.HEAD, (SVNRevision)new SVNRevision.Number(0L), false, 0L, tagManager, false);
                    logCmd.run(Policy.subMonitorFor(monitor, 100));
                    entries[0] = logCmd.getLogEntries();
                    monitor.done();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 1);
        if (entries[0] == null) {
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SVNCompareRevisionsInput input = new SVNCompareRevisionsInput((IFile)CompareWithRevisionAction.this.getSelectedResources()[0], entries[0]);
                if (SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_compare_revision_in_dialog")) {
                    input.run((IProgressMonitor)new NullProgressMonitor());
                    SaveablePartDialog cd = CompareWithRevisionAction.this.createCompareDialog(CompareWithRevisionAction.this.getShell(), input);
                    cd.setBlockOnOpen(true);
                    cd.open();
                } else {
                    CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)CompareWithRevisionAction.this.getTargetPage());
                }
            }
        }, false, 2);
    }

    protected SaveablePartDialog createCompareDialog(Shell shell, SVNCompareRevisionsInput input) {
        return new SaveablePartDialog(shell, (ISaveableWorkbenchPart)input);
    }

    protected String getErrorTitle() {
        return Policy.bind("CompareWithRevisionAction.compare");
    }

    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) throws SVNException {
        return !svnResource.isFolder() && super.isEnabledForSVNResource(svnResource);
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected String getImageId() {
        return "Menu Compare";
    }
}

