/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public abstract class CompareWithRemoteAction
extends WorkbenchWindowAction {
    private final SVNRevision revision;
    private boolean refresh;

    public CompareWithRemoteAction(SVNRevision revision) {
        this.revision = revision;
    }

    public void execute(IAction action) {
        this.refresh = false;
        IResource[] resources = this.getSelectedResources();
        if (resources.length != 1) {
            return;
        }
        if (resources[0] instanceof IFile && !resources[0].isSynchronized(2)) {
            this.refresh = MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("DifferencesDialog.compare"), (String)Policy.bind("CompareWithRemoteAction.fileChanged"));
        }
        try {
            final ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[0]);
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        if (CompareWithRemoteAction.this.refresh) {
                            localResource.getResource().refreshLocal(2, monitor);
                        }
                        CompareUI.openCompareEditorOnPage((CompareEditorInput)new SVNLocalCompareInput(localResource, CompareWithRemoteAction.this.revision), (IWorkbenchPage)CompareWithRemoteAction.this.getTargetPage());
                    }
                    catch (Exception e) {
                        CompareWithRemoteAction.this.handle(e, null, null);
                    }
                }
            }, false, 2);
        }
        catch (Exception e) {
            this.handle(e, null, null);
        }
    }

    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) throws SVNException {
        return super.isEnabledForSVNResource(svnResource) || svnResource.getParent().isManaged();
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForInaccessibleResources() {
        return true;
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected String getImageId() {
        return "Menu Compare";
    }
}

