/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.operations.CommitOperation;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardCommitPage;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class CommitAction
extends WorkbenchWindowAction {
    protected String commitComment;
    protected IResource[] resourcesToCommit;
    protected String url;
    protected boolean hasUnaddedResources;
    protected boolean commit;
    protected boolean keepLocks;
    protected IResource[] selectedResources;
    private String proposedComment;
    private boolean canRunAsJob = true;
    private HashMap statusMap;

    public CommitAction() {
    }

    public CommitAction(String proposedComment) {
        this.proposedComment = proposedComment;
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.statusMap = new HashMap();
        final IResource[] resources = this.getSelectedResources();
        final ArrayList resourcesToBeAdded = new ArrayList();
        final ArrayList resourcesToBeDeleted = new ArrayList();
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IResource[] modified = CommitAction.this.getModifiedResources(resources, monitor);
                        if (modified.length == 0) {
                            MessageDialog.openInformation((Shell)CommitAction.this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.noChanges"));
                            CommitAction.this.commit = false;
                        } else {
                            ProjectProperties projectProperties = ProjectProperties.getProjectProperties(modified[0]);
                            CommitAction.this.commit = CommitAction.this.confirmCommit(modified, projectProperties);
                        }
                        if (CommitAction.this.commit) {
                            int i = 0;
                            while (i < CommitAction.this.resourcesToCommit.length) {
                                IResource resource = CommitAction.this.resourcesToCommit[i];
                                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                                if (!svnResource.isManaged()) {
                                    resourcesToBeAdded.add(resource);
                                }
                                if (svnResource.getStatus().isMissing()) {
                                    resourcesToBeDeleted.add(resource);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, true, 2);
            if (!this.commit) {
                return;
            }
            CommitOperation commitOperation = new CommitOperation(this.getTargetPart(), resources, resourcesToBeAdded.toArray(new IResource[resourcesToBeAdded.size()]), resourcesToBeDeleted.toArray(new IResource[resourcesToBeDeleted.size()]), this.resourcesToCommit, this.commitComment, this.keepLocks);
            commitOperation.setCanRunAsJob(this.canRunAsJob);
            commitOperation.run();
        }
    }

    protected IResource[] getModifiedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws SVNException {
        IResource[] allResources = this.getSelectedResources(true);
        ArrayList<IResource> allSelections = new ArrayList<IResource>();
        int i = 0;
        while (i < allResources.length) {
            allSelections.add(allResources[i]);
            ++i;
        }
        ArrayList<IFile> conflictFiles = new ArrayList<IFile>();
        ArrayList<IResource> modified = new ArrayList<IResource>();
        ArrayList<IResource> unversionedFolders = new ArrayList<IResource>();
        this.hasUnaddedResources = false;
        int i2 = 0;
        while (i2 < resources.length) {
            IResource resource = resources[i2];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            if (svnResource.getRepository() != null) {
                if (resources.length == 1) {
                    this.url = svnResource.getStatus().getUrlString();
                    if (this.url == null || resource.getType() == 1) {
                        this.url = Util.getParentUrl((ISVNLocalResource)svnResource);
                    }
                }
                boolean descend = true;
                if (resource instanceof IContainer) {
                    int j = 0;
                    block2: while (j < allResources.length) {
                        if (allResources[j] != resource) {
                            IContainer parent = allResources[j].getParent();
                            while (parent != null) {
                                if (parent.equals((Object)resource)) {
                                    descend = false;
                                    break block2;
                                }
                                parent = parent.getParent();
                            }
                        }
                        ++j;
                    }
                }
                GetStatusCommand command = new GetStatusCommand(svnResource, descend, false);
                command.run(iProgressMonitor);
                ISVNStatus[] statuses = command.getStatuses();
                int j = 0;
                while (j < statuses.length) {
                    ISVNLocalResource localResource;
                    IResource currentResource;
                    if ((SVNStatusUtils.isReadyForCommit((ISVNStatus)statuses[j]) || SVNStatusUtils.isMissing((ISVNStatus)statuses[j])) && (currentResource = SVNWorkspaceRoot.getResourceFor((IResource)resource, (ISVNStatus)statuses[j])) != null && (descend || allSelections.contains(currentResource)) && !(localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)currentResource)).isIgnored()) {
                        if (!SVNStatusUtils.isManaged((ISVNStatus)statuses[j])) {
                            this.hasUnaddedResources = true;
                            if (currentResource.getType() != 1 && !this.isSymLink(currentResource)) {
                                unversionedFolders.add(currentResource);
                            } else if (!modified.contains(currentResource)) {
                                modified.add(currentResource);
                                if (currentResource instanceof IContainer) {
                                    this.statusMap.put(currentResource, statuses[j].getPropStatus());
                                } else {
                                    this.statusMap.put(currentResource, statuses[j].getTextStatus());
                                }
                            }
                        } else if (!modified.contains(currentResource)) {
                            modified.add(currentResource);
                            if (currentResource instanceof IContainer) {
                                this.statusMap.put(currentResource, statuses[j].getPropStatus());
                            } else {
                                this.statusMap.put(currentResource, statuses[j].getTextStatus());
                                if (SVNStatusUtils.isTextConflicted((ISVNStatus)statuses[j])) {
                                    IFile conflictWorkingFile;
                                    IFile conflictOldFile;
                                    IFile conflictNewFile = (IFile)File2Resource.getResource((File)statuses[j].getConflictNew());
                                    if (conflictNewFile != null) {
                                        conflictFiles.add(conflictNewFile);
                                    }
                                    if ((conflictOldFile = (IFile)File2Resource.getResource((File)statuses[j].getConflictOld())) != null) {
                                        conflictFiles.add(conflictOldFile);
                                    }
                                    if ((conflictWorkingFile = (IFile)File2Resource.getResource((File)statuses[j].getConflictWorking())) != null) {
                                        conflictFiles.add(conflictWorkingFile);
                                    }
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        IResource[] unaddedResources = this.getUnaddedResources(unversionedFolders, iProgressMonitor);
        int i3 = 0;
        while (i3 < unaddedResources.length) {
            if (!modified.contains(unaddedResources[i3])) {
                modified.add(unaddedResources[i3]);
            }
            ++i3;
        }
        Iterator iter = conflictFiles.iterator();
        while (iter.hasNext()) {
            IFile conflictFile = (IFile)iter.next();
            modified.remove(conflictFile);
            this.statusMap.remove(conflictFile);
        }
        return modified.toArray(new IResource[modified.size()]);
    }

    public int getHighestProblemSeverity(IResource[] resources) {
        int mostSeriousSeverity = -1;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            try {
                IMarker[] problems = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                int j = 0;
                while (j < problems.length) {
                    IMarker problem = problems[j];
                    int severity = problem.getAttribute("severity", 0);
                    if (severity > mostSeriousSeverity) {
                        mostSeriousSeverity = severity;
                    }
                    ++j;
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return mostSeriousSeverity;
    }

    protected boolean confirmCommit(IResource[] modifiedResources, ProjectProperties projectProperties) throws SVNException {
        if (this.onTagPath(modifiedResources) && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.tag"))) {
            return false;
        }
        int highestProblemSeverity = this.getHighestProblemSeverity(modifiedResources);
        IPreferenceStore preferenceStore = SVNUIPlugin.getPlugin().getPreferenceStore();
        switch (highestProblemSeverity) {
            case 1: {
                MessageDialogWithToggle warningDialog;
                String allowCommitsWithWarnings = preferenceStore.getString("pref_commit_with_warning");
                if (!"prompt".equals(allowCommitsWithWarnings) && !"never".equals(allowCommitsWithWarnings) || 2 == (warningDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.shell, (String)Policy.bind("CommitWizard.commitResources"), (String)Policy.bind("CommitWizard.warningMarkers"), (String)Policy.bind("CommitWizard.warningQuestion"), (boolean)false, (IPreferenceStore)preferenceStore, (String)"pref_commit_with_warning")).getReturnCode()) break;
                return false;
            }
            case 2: {
                MessageDialogWithToggle errorDialog;
                String allowCommitsWithErrors = preferenceStore.getString("pref_commit_with_errors");
                if (!"prompt".equals(allowCommitsWithErrors) && !"never".equals(allowCommitsWithErrors) || 2 == (errorDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.shell, (String)Policy.bind("CommitWizard.commitResources"), (String)Policy.bind("CommitWizard.errorMarkers"), (String)Policy.bind("CommitWizard.errorQuestion"), (boolean)false, (IPreferenceStore)preferenceStore, (String)"pref_commit_with_errors")).getReturnCode()) break;
                return false;
            }
        }
        SvnWizardCommitPage commitPage = new SvnWizardCommitPage(modifiedResources, this.url, projectProperties, this.statusMap, null, false);
        SvnWizard wizard = new SvnWizard(commitPage);
        SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
        if (this.proposedComment == null || this.proposedComment.length() == 0) {
            commitPage.setComment(this.getProposedComment(modifiedResources));
        } else {
            commitPage.setComment(this.proposedComment);
        }
        wizard.setParentDialog((Dialog)dialog);
        boolean commitOK = dialog.open() == 0;
        this.url = null;
        this.commitComment = commitPage.getComment();
        this.resourcesToCommit = commitPage.getSelectedResources();
        this.keepLocks = commitPage.isKeepLocks();
        return commitOK;
    }

    private boolean onTagPath(IResource[] modifiedResources) throws SVNException {
        if (this.url == null) {
            IResource resource = modifiedResources[0];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            String firstUrl = svnResource.getStatus().getUrlString();
            if (firstUrl == null || resource.getType() == 1) {
                firstUrl = Util.getParentUrl((ISVNLocalResource)svnResource);
            }
            if (firstUrl.indexOf("/tags/") != -1) {
                return true;
            }
        } else if (this.url.indexOf("/tags/") != -1) {
            return true;
        }
        return false;
    }

    protected String getErrorTitle() {
        return Policy.bind("CommitAction.commitFailed");
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabled() throws TeamException {
        IResource[] resources = super.getSelectedResources();
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (SVNWorkspaceRoot.isLinkedResource((IResource)resource)) {
                return false;
            }
            if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)SVNProviderPlugin.getTypeId()) == null) {
                return false;
            }
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            if (!this.isEnabledForSVNResource(svnResource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IResource[] getUnaddedResources(List resources, IProgressMonitor iProgressMonitor) throws SVNException {
        final ArrayList unadded = new ArrayList();
        final SVNException[] exception = new SVNException[1];
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!resource.exists()) continue;
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource aResource) {
                        block6: {
                            ISVNLocalResource svnResource;
                            block5: {
                                svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)aResource);
                                if (!svnResource.isIgnored()) break block5;
                                return false;
                            }
                            if (!svnResource.isManaged()) break block6;
                            return true;
                        }
                        try {
                            if (aResource.getType() == 2 && CommitAction.this.isSymLink(aResource)) {
                                return false;
                            }
                        }
                        catch (SVNException e) {
                            exception[0] = e;
                        }
                        unadded.add(aResource);
                        return aResource.getType() == 2;
                    }
                }, 2, false);
            }
            catch (CoreException e) {
                throw SVNException.wrapException((CoreException)e);
            }
            if (exception[0] == null) continue;
            throw exception[0];
        }
        if (unadded.size() > 0) {
            this.hasUnaddedResources = true;
        }
        return unadded.toArray(new IResource[unadded.size()]);
    }

    protected boolean isSymLink(IResource resource) {
        File file;
        block3: {
            file = resource.getLocation().toFile();
            try {
                if (file.exists()) break block3;
                return true;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        String cnnpath = file.getCanonicalPath();
        String abspath = file.getAbsolutePath();
        return !abspath.equals(cnnpath);
    }

    protected IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return super.getSelectedResources();
        }
        return this.selectedResources;
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }

    private String getProposedComment(IResource[] resourcesToCommit) {
        StringBuffer comment = new StringBuffer();
        ChangeSet[] sets = SVNProviderPlugin.getPlugin().getChangeSetManager().getSets();
        int numMatchedSets = 0;
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (this.isUserSet(set) && this.containsOne(set, resourcesToCommit)) {
                if (numMatchedSets > 0) {
                    comment.append(System.getProperty("line.separator"));
                }
                comment.append(set.getComment());
                ++numMatchedSets;
            }
            ++i;
        }
        return comment.toString();
    }

    private boolean isUserSet(ChangeSet set) {
        if (set instanceof ActiveChangeSet) {
            ActiveChangeSet acs = (ActiveChangeSet)set;
            return acs.isUserCreated();
        }
        return false;
    }

    private boolean containsOne(ChangeSet set, IResource[] resourcesToCommit) {
        int j = 0;
        while (j < resourcesToCommit.length) {
            ActiveChangeSet acs;
            IResource resource = resourcesToCommit[j];
            if (set.contains(resource)) {
                return true;
            }
            if (set instanceof ActiveChangeSet && (acs = (ActiveChangeSet)set).getDiffTree().members(resource).length > 0) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public boolean hasOutgoingChanges() {
        try {
            return this.getModifiedResources(this.selectedResources, (IProgressMonitor)new NullProgressMonitor()).length > 0;
        }
        catch (SVNException sVNException) {
            return false;
        }
    }

    protected String getImageId() {
        return "Menu Commit";
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }
}

