/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.tigris.subversion.subclipse.core.SVNClientManager;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;

public class Preferences
implements IPropertyChangeListener {
    private IPreferenceStore store;

    public Preferences(IPreferenceStore store) {
        this.store = store;
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void initializeFromSettings() {
        this.setSvnClientConfigDir(this.store.getString("pref_svnconfigdir"));
        this.setSvnClientInterface(this.store.getString("pref_svninterface"));
        this.setSvnChangePathOnDemand(this.store.getBoolean("pref_fetch_change_path_on_Demand"));
    }

    private void setSvnClientInterface(String clientInterface) {
        SVNProviderPlugin.getPlugin().getSVNClientManager().setSvnClientInterface(clientInterface);
    }

    private void setSvnClientConfigDir(String configDir) {
        SVNProviderPlugin plugin = SVNProviderPlugin.getPlugin();
        SVNClientManager svnClientManager = plugin.getSVNClientManager();
        if (configDir == null || "".equals(configDir)) {
            svnClientManager.setConfigDir(null);
        } else {
            File configDirFile = new File(configDir);
            svnClientManager.setConfigDir(configDirFile);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == "pref_svninterface") {
            String newValue = (String)event.getNewValue();
            this.setSvnClientInterface(newValue);
        }
        if (property == "pref_svnconfigdir") {
            String configDir = (String)event.getNewValue();
            this.setSvnClientConfigDir(configDir);
        }
        if (property == "pref_fetch_change_path_on_Demand") {
            boolean fetchChangePathOnDemand = (Boolean)event.getNewValue();
            this.setSvnChangePathOnDemand(fetchChangePathOnDemand);
        }
    }

    private void setSvnChangePathOnDemand(boolean fetchChangePathOnDemand) {
        SVNProviderPlugin plugin = SVNProviderPlugin.getPlugin();
        SVNClientManager svnClientManager = plugin.getSVNClientManager();
        svnClientManager.setFetchChangePathOnDemand(fetchChangePathOnDemand);
    }
}

