/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.status;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.status.IStatusCache;
import org.tigris.subversion.subclipse.core.status.StatusCacheManager;

public class SynchronizerSyncInfoCache
implements IStatusCache {
    protected static final byte[] BYTES_REMOVED = new byte[0];
    protected SyncInfoSynchronizedAccessor accessor = new SyncInfoSynchronizedAccessor();

    public boolean hasCachedStatus(IResource resource) {
        try {
            return this.getCachedSyncBytes(resource) != null;
        }
        catch (SVNException e) {
            SVNProviderPlugin.log(e);
            return false;
        }
    }

    public LocalResourceStatus getStatus(IResource resource) {
        try {
            return LocalResourceStatus.fromBytes(this.getCachedSyncBytes(resource));
        }
        catch (SVNException e) {
            SVNProviderPlugin.log(e);
            return null;
        }
    }

    public IResource addStatus(IResource resource, LocalResourceStatus status) {
        block5: {
            try {
                if (resource != null) break block5;
                return null;
            }
            catch (SVNException e) {
                if (!"".equals(e.getMessage())) {
                    SVNProviderPlugin.log(e);
                }
                return null;
            }
        }
        if (status.isUnversioned() && !resource.exists() && !resource.isPhantom()) {
            return resource;
        }
        this.setCachedSyncBytes(resource, status.getBytes());
        return resource;
    }

    public IResource removeStatus(IResource resource) {
        try {
            this.setCachedSyncBytes(resource, null);
            return resource;
        }
        catch (SVNException e) {
            SVNProviderPlugin.log(e);
            return null;
        }
    }

    private byte[] getCachedSyncBytes(IResource resource) throws SVNException {
        try {
            byte[] bytes;
            if (this.accessor.pendingCacheContains(resource)) {
                bytes = this.accessor.readFromPendingCache(resource);
                if (bytes == BYTES_REMOVED) {
                    bytes = null;
                }
            } else {
                bytes = this.accessor.internalGetCachedSyncBytes(resource);
            }
            return bytes;
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
    }

    private void setCachedSyncBytes(IResource resource, byte[] syncBytes) throws SVNException {
        byte[] oldBytes = this.getCachedSyncBytes(resource);
        try {
            if (syncBytes == null) {
                if (oldBytes != null) {
                    boolean canModifyWorkspace;
                    boolean bl = canModifyWorkspace = !ResourcesPlugin.getWorkspace().isTreeLocked();
                    if (canModifyWorkspace) {
                        this.accessor.removeFromPendingCache(resource);
                        if (resource.exists() || resource.isPhantom()) {
                            this.accessor.internalSetCachedSyncBytes(resource, null);
                        }
                    } else if (resource.exists() || resource.isPhantom()) {
                        this.accessor.writeToPendingCache(resource, BYTES_REMOVED);
                    }
                }
            } else if (oldBytes == null || !SyncInfoSynchronizedAccessor.equals(syncBytes, oldBytes)) {
                boolean canModifyWorkspace;
                boolean bl = canModifyWorkspace = !ResourcesPlugin.getWorkspace().isTreeLocked();
                if (canModifyWorkspace) {
                    this.accessor.removeFromPendingCache(resource);
                    this.accessor.internalSetCachedSyncBytes(resource, syncBytes);
                } else {
                    LocalResourceStatus.fromBytes(oldBytes);
                    this.accessor.writeToPendingCache(resource, syncBytes);
                }
            }
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
    }

    public void purgeCache(IContainer root, boolean deep) throws SVNException {
        int depth = deep ? 2 : 0;
        try {
            if (root.exists() || root.isPhantom()) {
                ResourcesPlugin.getWorkspace().getSynchronizer().flushSyncInfo(StatusCacheManager.SVN_BC_SYNC_KEY, (IResource)root, depth);
            }
            if (deep) {
                this.accessor.removeRecursiveFromPendingCache((IResource)root);
            } else {
                this.accessor.removeFromPendingCache((IResource)root);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                return;
            }
            throw SVNException.wrapException(e);
        }
    }

    public void flushPendingStatuses() {
        if (this.accessor.isFlushFeasible()) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        SynchronizerSyncInfoCache.this.accessor.flushPendingCacheWrites();
                    }
                }, null);
            }
            catch (CoreException e) {
                SVNProviderPlugin.log(SVNException.wrapException(e));
            }
        }
    }

    protected static final class SyncInfoSynchronizedAccessor {
        private Map pendingCacheWrites = new HashMap();

        protected SyncInfoSynchronizedAccessor() {
        }

        protected byte[] internalGetCachedSyncBytes(IResource resource) throws SVNException {
            try {
                return ResourcesPlugin.getWorkspace().getSynchronizer().getSyncInfo(StatusCacheManager.SVN_BC_SYNC_KEY, resource);
            }
            catch (CoreException e) {
                throw SVNException.wrapException(e);
            }
        }

        protected void internalSetCachedSyncBytes(IResource resource, byte[] syncInfo) throws SVNException {
            try {
                ResourcesPlugin.getWorkspace().getSynchronizer().setSyncInfo(StatusCacheManager.SVN_BC_SYNC_KEY, resource, syncInfo);
            }
            catch (CoreException e) {
                throw SVNException.wrapException(e);
            }
        }

        protected void flushPendingCacheWrites() {
            if (this.pendingCacheWrites.size() > 0 && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                int count = this.pendingCacheWrites.size();
                int i = 0;
                while (i < count) {
                    Map.Entry cachedEntry = this.nextFromPendingCache();
                    if (cachedEntry != null) {
                        IResource resource = (IResource)cachedEntry.getKey();
                        byte[] value = (byte[])cachedEntry.getValue();
                        if (value == BYTES_REMOVED) {
                            value = null;
                        }
                        try {
                            ResourcesPlugin.getWorkspace().getSynchronizer().setSyncInfo(StatusCacheManager.SVN_BC_SYNC_KEY, resource, value);
                        }
                        catch (CoreException e) {
                            SVNProviderPlugin.log(SVNException.wrapException(e));
                        }
                        this.removeFromPendingCacheIfEqual((IResource)cachedEntry.getKey(), (byte[])cachedEntry.getValue());
                    }
                    ++i;
                }
            }
        }

        protected boolean isFlushFeasible() {
            return this.pendingCacheWrites.size() > 0 && !ResourcesPlugin.getWorkspace().isTreeLocked();
        }

        private synchronized Map.Entry nextFromPendingCache() {
            if (this.pendingCacheWrites.size() > 0) {
                return this.pendingCacheWrites.entrySet().iterator().next();
            }
            return null;
        }

        protected synchronized boolean pendingCacheContains(IResource resource) {
            return this.pendingCacheWrites.size() > 0 && this.pendingCacheWrites.containsKey(resource);
        }

        protected synchronized byte[] readFromPendingCache(IResource resource) {
            return (byte[])this.pendingCacheWrites.get(resource);
        }

        protected synchronized void writeToPendingCache(IResource resource, byte[] syncBytes) {
            this.pendingCacheWrites.put(resource, syncBytes);
        }

        protected synchronized void removeFromPendingCache(IResource resource) {
            this.pendingCacheWrites.remove(resource);
        }

        protected synchronized boolean removeFromPendingCacheIfEqual(IResource resource, byte[] syncBytes) {
            byte[] old = (byte[])this.pendingCacheWrites.get(resource);
            if (SyncInfoSynchronizedAccessor.equals(old, syncBytes)) {
                this.pendingCacheWrites.remove(resource);
                return true;
            }
            return false;
        }

        protected synchronized void removeRecursiveFromPendingCache(IResource resource) {
            IPath fullPath = resource.getFullPath();
            Iterator iter = this.pendingCacheWrites.keySet().iterator();
            while (iter.hasNext()) {
                if (!fullPath.isPrefixOf(((IResource)iter.next()).getFullPath())) continue;
                iter.remove();
            }
        }

        protected static boolean equals(byte[] syncBytes, byte[] oldBytes) {
            if (syncBytes == null || oldBytes == null) {
                return syncBytes == oldBytes;
            }
            if (syncBytes.length != oldBytes.length) {
                return false;
            }
            int i = 0;
            while (i < oldBytes.length) {
                if (oldBytes[i] != syncBytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

