/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resourcesListeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.status.StatusCacheManager;

public class SyncFileChangeListener
implements IResourceChangeListener {
    protected int INTERESTING_CHANGES = 323840;

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            final StatusCacheManager cacheManager = SVNProviderPlugin.getPlugin().getStatusCacheManager();
            final ChangesCollector changesCollector = new ChangesCollector();
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 8) {
                        return true;
                    }
                    if (resource.getType() == 4) {
                        if (!resource.isAccessible()) {
                            return false;
                        }
                        if (!SVNWorkspaceRoot.isManagedBySubclipse((IProject)resource)) {
                            return false;
                        }
                    }
                    String name = resource.getName();
                    int kind = delta.getKind();
                    try {
                        if (resource.getType() == 2 && kind == 1 && cacheManager.hasCachedStatus(resource) && cacheManager.getStatus(resource).isManaged()) {
                            if (Policy.DEBUG_METAFILE_CHANGES) {
                                System.out.println("[svn] duplicte ADD change event registered in SyncFileChangeListener: " + resource);
                            }
                            return false;
                        }
                    }
                    catch (SVNException sVNException) {
                        return true;
                    }
                    if (kind == 4 && (delta.getFlags() & SyncFileChangeListener.this.INTERESTING_CHANGES) == 0) {
                        return true;
                    }
                    IContainer toBeNotified = null;
                    if (SVNProviderPlugin.getPlugin().isAdminDirectory(name)) {
                        SyncFileChangeListener.this.handleSVNDir((IContainer)resource, kind);
                    }
                    if (SyncFileChangeListener.this.isEntries(resource)) {
                        toBeNotified = SyncFileChangeListener.this.handleChangedEntries(resource, kind);
                    } else if (SyncFileChangeListener.this.isDirProps(resource)) {
                        toBeNotified = SyncFileChangeListener.this.handleChangedDirProps(resource, kind);
                    } else if (SyncFileChangeListener.this.isPropFile(resource)) {
                        toBeNotified = SyncFileChangeListener.this.handleChangedPropFile(resource, kind);
                    }
                    if (toBeNotified != null) {
                        changesCollector.collectChange(toBeNotified);
                        if (Policy.DEBUG_METAFILE_CHANGES) {
                            System.out.println("[svn] metafile changed : " + resource.getFullPath());
                        }
                        return false;
                    }
                    return true;
                }
            }, 2);
            changesCollector.refreshChangedResources();
        }
        catch (CoreException e) {
            SVNProviderPlugin.log(e.getStatus());
        }
    }

    protected void handleSVNDir(IContainer svnDir, int kind) {
        IFile entriesFile;
        if ((kind & 0x1F) != 0 && kind == 1 && (entriesFile = svnDir.getFile((IPath)new Path("entries"))).exists() && !svnDir.isTeamPrivateMember()) {
            try {
                svnDir.setTeamPrivateMember(true);
                if (Policy.DEBUG_METAFILE_CHANGES) {
                    System.out.println("[svn] found a new SVN meta folder, marking as team-private: " + svnDir.getFullPath());
                }
            }
            catch (CoreException e) {
                SVNProviderPlugin.log(SVNException.wrapException((IResource)svnDir, Policy.bind("SyncFileChangeListener.errorSettingTeamPrivateFlag"), e));
            }
        }
    }

    protected boolean isEntries(IResource resource) {
        if (resource.getType() != 1 || !resource.getName().equals("entries")) {
            return false;
        }
        IContainer parent = resource.getParent();
        return parent != null && SVNProviderPlugin.getPlugin().isAdminDirectory(parent.getName()) && (parent.isTeamPrivateMember() || !parent.exists());
    }

    protected boolean isDirProps(IResource resource) {
        if (resource.getType() != 1 || !resource.getName().equals("dir-props")) {
            return false;
        }
        IContainer parent = resource.getParent();
        return parent != null && SVNProviderPlugin.getPlugin().isAdminDirectory(parent.getName()) && (parent.isTeamPrivateMember() || !parent.exists());
    }

    protected boolean isPropFile(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        IContainer parent = resource.getParent();
        if (parent == null || !parent.getName().equals("props")) {
            return false;
        }
        return (parent = parent.getParent()) != null && SVNProviderPlugin.getPlugin().isAdminDirectory(parent.getName()) && (parent.isTeamPrivateMember() || !parent.exists());
    }

    protected IContainer handleChangedEntries(IResource resource, int kind) {
        IContainer changedContainer = resource.getParent();
        IContainer parent = changedContainer.getParent();
        if (parent != null && parent.exists()) {
            return changedContainer;
        }
        return null;
    }

    protected IContainer handleChangedDirProps(IResource resource, int kind) {
        IContainer changedContainer = resource.getParent();
        IContainer parent = changedContainer.getParent();
        if (parent != null && parent.exists()) {
            return changedContainer;
        }
        return null;
    }

    protected IContainer handleChangedPropFile(IResource resource, int kind) {
        IContainer changedContainer = resource.getParent().getParent();
        IContainer parent = changedContainer.getParent();
        if (parent != null && parent.exists()) {
            return changedContainer;
        }
        return null;
    }

    protected static final class ChangesCollector {
        private Map map = new HashMap();

        protected ChangesCollector() {
        }

        protected void collectChange(IContainer svnFolder) {
            IProject project = svnFolder.getProject();
            HashSet<IContainer> changes = (HashSet<IContainer>)this.map.get(project);
            if (changes == null) {
                changes = new HashSet<IContainer>();
                this.map.put(project, changes);
            }
            changes.add(svnFolder);
        }

        protected void refreshChangedResources() throws CoreException {
            Iterator iter = this.map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry element = iter.next();
                SVNProviderPlugin.run(new ISVNRunnable(this, element){
                    final /* synthetic */ ChangesCollector this$1;
                    private final /* synthetic */ Map.Entry val$element;
                    {
                        this.this$1 = changesCollector;
                        this.val$element = entry;
                    }

                    public void run(IProgressMonitor monitor) throws SVNException {
                        this.this$1.refreshProjectFolders((Set)this.val$element.getValue(), monitor);
                    }
                }, (ISchedulingRule)((IProject)element.getKey()), null);
            }
        }

        protected void refreshProjectFolders(Set folders, IProgressMonitor monitor) throws SVNException {
            Iterator it = folders.iterator();
            while (it.hasNext()) {
                IContainer dotSvnContainer = (IContainer)it.next();
                IContainer container = dotSvnContainer.getParent();
                try {
                    container.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    throw SVNException.wrapException(e);
                }
                IResource[] refreshed = SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus(container, false);
                SVNProviderPlugin.broadcastSyncInfoChanges(refreshed);
            }
        }
    }
}

