/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.AddIgnoredPatternCommand;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.status.StatusCacheManager;
import org.tigris.subversion.subclipse.core.util.Assert;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class LocalResource
implements ISVNLocalResource,
Comparable {
    protected IResource resource;

    protected LocalResource(IResource resource) {
        Assert.isNotNull(resource);
        this.resource = resource;
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public ISVNLocalFolder getParent() {
        IContainer parent = this.resource.getParent();
        if (parent == null) {
            return null;
        }
        return new LocalFolder(parent);
    }

    public String getName() {
        return this.resource.getName();
    }

    public boolean isIgnored() throws SVNException {
        if (this.resource.isDerived() || this.resource.isTeamPrivateMember() || this.resource.isLinked()) {
            return true;
        }
        if (this.resource.getType() == 2 && SVNProviderPlugin.getPlugin().isAdminDirectory(this.getName())) {
            return true;
        }
        if (this.resource.getType() == 8 || this.resource.getType() == 4) {
            return false;
        }
        if (this.isParentInSvnIgnore()) {
            return true;
        }
        LocalResourceStatus status = this.getStatus();
        if (status.isManaged()) {
            return false;
        }
        if (status.isIgnored()) {
            return true;
        }
        if (Team.isIgnoredHint((IResource)this.resource)) {
            return true;
        }
        ISVNLocalFolder parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.isIgnored();
    }

    protected boolean isParentInSvnIgnore() throws SVNException {
        LocalResourceStatus status;
        StatusCacheManager cacheMgr = SVNProviderPlugin.getPlugin().getStatusCacheManager();
        IContainer parent = this.resource.getParent();
        while (parent != null && !cacheMgr.hasCachedStatus((IResource)parent)) {
            parent = parent.getParent();
        }
        return parent != null && (status = cacheMgr.getStatus((IResource)parent)) != null && SVNStatusKind.IGNORED.equals((Object)status.getTextStatus());
    }

    public void setIgnored() throws SVNException {
        AddIgnoredPatternCommand command = new AddIgnoredPatternCommand(this.getParent(), this.resource.getName());
        command.run(null);
    }

    public boolean isManaged() throws SVNException {
        return !this.resource.isDerived() && this.getStatus().isManaged();
    }

    public boolean isAdded() throws SVNException {
        return this.getStatus().isAdded();
    }

    public boolean hasRemote() throws SVNException {
        return !this.isLinked() && this.getStatus().hasRemote();
    }

    public boolean isLinked() {
        return SVNWorkspaceRoot.isLinkedResource(this.resource);
    }

    public LocalResourceStatus getStatus() throws SVNException {
        if (this.isLinked()) {
            return LocalResourceStatus.NONE;
        }
        LocalResourceStatus aStatus = SVNProviderPlugin.getPlugin().getStatusCacheManager().getStatus(this.resource);
        return aStatus != null ? aStatus : LocalResourceStatus.NONE;
    }

    public SVNRevision getRevision() throws SVNException {
        if (this.isLinked()) {
            return null;
        }
        return SVNProviderPlugin.getPlugin().getStatusCacheManager().getResourceRevision(this);
    }

    public int compareTo(Object arg0) {
        LocalResource other = (LocalResource)arg0;
        return this.resource.getFullPath().toString().compareTo(other.resource.getFullPath().toString());
    }

    public IResource getIResource() {
        return this.resource;
    }

    public File getFile() {
        return this.resource.getLocation().toFile();
    }

    public SVNWorkspaceRoot getWorkspaceRoot() {
        SVNTeamProvider teamProvider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)this.resource.getProject(), (String)SVNProviderPlugin.getTypeId());
        if (teamProvider == null) {
            return null;
        }
        return teamProvider.getSVNWorkspaceRoot();
    }

    public ISVNRepositoryLocation getRepository() {
        SVNWorkspaceRoot root;
        block3: {
            try {
                root = this.getWorkspaceRoot();
                if (root != null) break block3;
                SVNProviderPlugin.log(2, Policy.bind("LocalResource.errorGettingTeamProvider", this.resource.toString()), null);
                return null;
            }
            catch (SVNException e) {
                SVNProviderPlugin.log(e);
                return null;
            }
        }
        return root.getRepository();
    }

    public SVNUrl getUrl() {
        ISVNLocalFolder parent;
        block4: {
            try {
                if (this.isManaged()) {
                    return this.getStatus().getUrl();
                }
                parent = this.getParent();
                if (parent != null) break block4;
                return null;
            }
            catch (SVNException sVNException) {
                return null;
            }
        }
        return parent.getUrl().appendPath(this.resource.getName());
    }

    public ISVNRemoteResource getLatestRemoteResource() throws SVNException {
        return this.getRemoteResource(SVNRevision.HEAD);
    }

    public ISVNRemoteResource getRemoteResource(SVNRevision revision) throws SVNException {
        if (SVNRevision.BASE.equals((Object)revision)) {
            return this.getBaseResource();
        }
        GetRemoteResourceCommand command = new GetRemoteResourceCommand(this.getRepository(), this.getUrl(), revision);
        command.run(null);
        return command.getRemoteResource();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete() throws SVNException {
        try {
            try {
                ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.remove(new File[]{this.getFile()}, true);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            OperationManager.getInstance().endOperation();
            throw throwable;
        }
        {
            Object var2_5 = null;
            OperationManager.getInstance().endOperation();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void revert(boolean recurse) throws SVNException {
        try {
            try {
                try {
                    Util.saveLocalHistory(this.resource);
                }
                catch (CoreException e) {
                    SVNProviderPlugin.log(4, e.getMessage(), e);
                }
                ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.revert(this.getFile(), recurse);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            OperationManager.getInstance().endOperation();
            throw throwable;
        }
        {
            Object var3_7 = null;
            OperationManager.getInstance().endOperation();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve() throws SVNException {
        try {
            try {
                ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.resolved(this.getFile());
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            OperationManager.getInstance().endOperation();
            throw throwable;
        }
        {
            Object var2_5 = null;
            OperationManager.getInstance().endOperation();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSvnProperty(String name, String value, boolean recurse) throws SVNException {
        try {
            try {
                ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.propertySet(this.getFile(), name, value, recurse);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            OperationManager.getInstance().endOperation();
            throw throwable;
        }
        {
            Object var5_8 = null;
            OperationManager.getInstance().endOperation();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSvnProperty(String name, File value, boolean recurse) throws SVNException {
        try {
            try {
                ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.propertySet(this.getFile(), name, value, recurse);
            }
            catch (IOException e) {
                throw SVNException.wrapException(e);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            OperationManager.getInstance().endOperation();
            throw throwable;
        }
        {
            Object var5_9 = null;
            OperationManager.getInstance().endOperation();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteSvnProperty(String name, boolean recurse) throws SVNException {
        try {
            try {
                ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.propertyDel(this.getFile(), name, recurse);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            OperationManager.getInstance().endOperation();
            throw throwable;
        }
        {
            Object var4_7 = null;
            OperationManager.getInstance().endOperation();
            return;
        }
    }

    public ISVNProperty getSvnProperty(String name) throws SVNException {
        ISVNProperty iSVNProperty;
        try {
            ISVNProperty prop;
            ISVNClientAdapter svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
            SVNProviderPlugin.disableConsoleLogging();
            iSVNProperty = prop = svnClient.propertyGet(this.getFile(), name);
            Object var4_6 = null;
        }
        catch (SVNClientException e) {
            try {
                throw SVNException.wrapException((Exception)((Object)e));
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                SVNProviderPlugin.enableConsoleLogging();
                throw throwable;
            }
        }
        SVNProviderPlugin.enableConsoleLogging();
        return iSVNProperty;
    }

    public ISVNProperty[] getSvnProperties() throws SVNException {
        try {
            ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
            ISVNProperty[] properties = svnClient.getProperties(this.getFile());
            return properties;
        }
        catch (SVNClientException e) {
            throw SVNException.wrapException((Exception)((Object)e));
        }
    }

    public IResource getResource() {
        return this.resource;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this.getIResource())) {
            return this.getIResource();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalResource) {
            LocalResource resource = (LocalResource)obj;
            return resource.getResource().getFullPath().equals((Object)this.getResource().getFullPath());
        }
        return false;
    }

    public int hashCode() {
        return 23 * this.resource.getFullPath().hashCode();
    }
}

