/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.ISVNResourceVisitor;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.AddIgnoredPatternCommand;
import org.tigris.subversion.subclipse.core.resources.BaseFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResource;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;

public class LocalFolder
extends LocalResource
implements ISVNLocalFolder {
    public LocalFolder(IContainer container) {
        super((IResource)container);
    }

    public ISVNRemoteResource getBaseResource() throws SVNException {
        if (!this.isManaged()) {
            return null;
        }
        return new BaseFolder(this.resource, this.getStatus());
    }

    public ISVNResource[] members(IProgressMonitor monitor, int flags) throws SVNException {
        IResource[] resources;
        if (!this.resource.exists()) {
            return new ISVNLocalResource[0];
        }
        ArrayList<ISVNLocalResource> result = new ArrayList<ISVNLocalResource>();
        try {
            resources = ((IContainer)this.resource).members(true);
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        boolean includeUnmanaged = (flags & 8) != 0 || (flags & 0x1C) == 0;
        boolean includeIgnored = (flags & 4) != 0;
        boolean includeExisting = (flags & 0x20) != 0 || (flags & 0x60) == 0;
        boolean includePhantoms = (flags & 0x40) != 0 || (flags & 0x60) == 0;
        int i = 0;
        while (i < resources.length) {
            if (includeFiles && resources[i].getType() == 1 || includeFolders && resources[i].getType() == 2) {
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor(resources[i]);
                boolean isManaged = svnResource.isManaged();
                boolean isIgnored = svnResource.isIgnored();
                if (isManaged && includeManaged || isIgnored && includeIgnored || !isManaged && !isIgnored && includeUnmanaged) {
                    boolean exists = svnResource.exists();
                    if (includeExisting && exists || includePhantoms && !exists) {
                        result.add(svnResource);
                    }
                }
            }
            ++i;
        }
        return result.toArray(new ISVNLocalResource[result.size()]);
    }

    public boolean isFolder() {
        return true;
    }

    public void refreshStatus() throws SVNException {
        this.refreshStatus(false);
    }

    public void refreshStatus(boolean recursive) throws SVNException {
        SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus((IContainer)this.resource, recursive);
    }

    public boolean isDirty() throws SVNException {
        if (this.getStatus().isDirty()) {
            return true;
        }
        ISVNLocalResource[] children = (ISVNLocalResource[])this.members((IProgressMonitor)new NullProgressMonitor(), 123);
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirty() || children[i].exists() && !children[i].isManaged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void acceptChildren(ISVNResourceVisitor visitor) throws SVNException {
        ISVNLocalResource[] subFiles = (ISVNLocalResource[])this.members(null, 1);
        int i = 0;
        while (i < subFiles.length) {
            subFiles[i].accept(visitor);
            ++i;
        }
        ISVNLocalResource[] subFolders = (ISVNLocalResource[])this.members(null, 2);
        int i2 = 0;
        while (i2 < subFolders.length) {
            subFolders[i2].accept(visitor);
            ++i2;
        }
    }

    public void accept(ISVNResourceVisitor visitor) throws SVNException {
        visitor.visitFolder(this);
    }

    public IFolder[] getSVNFolders(IProgressMonitor monitor, final boolean unmanage) throws SVNException {
        final ArrayList svnFolders = new ArrayList();
        SVNProviderPlugin.run(new ISVNRunnable(){

            public void run(IProgressMonitor pm) throws SVNException {
                pm = Policy.monitorFor(pm);
                pm.beginTask(null, 100);
                ISVNResource[] members = LocalFolder.this.members(Policy.subMonitorFor(pm, 20), 18);
                ArrayList<IResource> dirs = new ArrayList<IResource>();
                int i = 0;
                while (i < members.length) {
                    dirs.add(((ISVNLocalResource)members[i]).getIResource());
                    ++i;
                }
                dirs.add(LocalFolder.this.getIResource());
                IProgressMonitor monitorDel = Policy.subMonitorFor(pm, 80);
                monitorDel.beginTask(null, dirs.size());
                int i2 = 0;
                while (i2 < dirs.size()) {
                    monitorDel.worked(1);
                    IContainer container = (IContainer)dirs.get(i2);
                    this.recursiveGetSVNFolders(container, monitorDel, unmanage);
                    ++i2;
                }
                monitorDel.done();
                pm.done();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void recursiveGetSVNFolders(IContainer container, IProgressMonitor pm, boolean unmanage2) {
                block13: {
                    block12: {
                        try {
                            try {
                                if (container.isLinked()) {
                                    Object var6_4 = null;
                                    break block12;
                                }
                                pm.beginTask(null, 10);
                                pm.subTask(container.getFullPath().toOSString());
                                IResource[] members = container.members(true);
                                int i = 0;
                                while (true) {
                                    if (i >= members.length) {
                                        IFolder svnFolder = container.getFolder((IPath)new Path(SVNProviderPlugin.getPlugin().getAdminDirectoryName()));
                                        if (!svnFolder.exists()) break block13;
                                        svnFolders.add(svnFolder);
                                        if (unmanage2) {
                                            try {
                                                svnFolder.delete(true, null);
                                            }
                                            catch (CoreException coreException) {}
                                        }
                                        break block13;
                                    }
                                    pm.worked(1);
                                    if (members[i].getType() != 1) {
                                        this.recursiveGetSVNFolders((IContainer)members[i], pm, unmanage2);
                                    }
                                    ++i;
                                }
                            }
                            catch (CoreException coreException) {
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_5 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return;
                }
                Object var6_6 = null;
                pm.done();
            }
        }, Policy.subMonitorFor(monitor, 99));
        IFolder[] folderArray = new IFolder[svnFolders.size()];
        svnFolders.toArray(folderArray);
        return folderArray;
    }

    public void unmanage(IProgressMonitor monitor) throws SVNException {
        this.getSVNFolders(monitor, true);
    }

    public void setIgnoredAs(String pattern) throws SVNException {
        AddIgnoredPatternCommand command = new AddIgnoredPatternCommand(this, pattern);
        command.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void revert() throws SVNException {
        super.revert(true);
    }

    public void resolve() {
    }

    public LocalResourceStatus getStatus() throws SVNException {
        if (this.getIResource().isTeamPrivateMember() && SVNProviderPlugin.getPlugin().isAdminDirectory(this.getIResource().getName())) {
            return LocalResourceStatus.NONE;
        }
        if (this.getIResource() instanceof IWorkspaceRoot) {
            return LocalResourceStatus.NONE;
        }
        return super.getStatus();
    }
}

