/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizard;
import com.collabnet.subversion.merge.wizards.MergeWizardStandardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.history.ChangePathsTreeViewer;
import org.tigris.subversion.subclipse.ui.history.HistoryFolder;
import org.tigris.subversion.subclipse.ui.history.HistoryTableProvider;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeWizardUnblockRevisionsPage
extends WizardPage {
    private MergeWizardStandardPage standardPage;
    private String fromUrl;
    private SVNRevisionRange[] revisionRanges;
    private ArrayList entryArray;
    private IDialogSettings settings;
    private SashForm sashForm;
    private HistoryTableProvider historyTableProvider;
    private ChangePathsTreeViewer changePathsViewer;
    private TableViewer tableHistoryViewer;
    private TextViewer textViewer;
    private ILogEntry[] entries;
    private IResource resource;
    private ISVNLocalResource svnResource;
    private ISVNRepositoryLocation repositoryLocation;
    private AliasManager tagManager;
    private ISVNRemoteResource remoteResource;
    private SVNRevision.Number[] allRevisions;
    private ILogEntry[] rangeEntries;
    private boolean pageShown;

    public MergeWizardUnblockRevisionsPage(String pageName, String title, ImageDescriptor titleImage, MergeWizardStandardPage standardPage) {
        super(pageName, title, titleImage);
        this.standardPage = standardPage;
        this.settings = Activator.getDefault().getDialogSettings();
    }

    public void createControl(Composite parent) {
        MergeWizard wizard = (MergeWizard)this.getWizard();
        this.resource = wizard.getResource();
        if (this.resource != null) {
            this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
            try {
                this.repositoryLocation = this.svnResource.getRepository();
            }
            catch (Exception exception) {}
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.sashForm = new SashForm(composite, 512);
        GridLayout sashLayout = new GridLayout();
        sashLayout.verticalSpacing = 0;
        sashLayout.marginHeight = 0;
        this.sashForm.setLayout((Layout)sashLayout);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        Composite historyGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout historyLayout = new GridLayout();
        historyLayout.verticalSpacing = 0;
        historyLayout.marginHeight = 0;
        historyGroup.setLayout((Layout)historyLayout);
        historyGroup.setLayoutData((Object)new GridData(1808));
        this.historyTableProvider = new HistoryTableProvider(66338, "MergeWizardUnblockRevisionsPage");
        this.historyTableProvider.setIncludeMergeRevisions(false);
        this.historyTableProvider.setIncludeTags(false);
        this.tableHistoryViewer = this.historyTableProvider.createTable(historyGroup);
        data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = 100;
        this.tableHistoryViewer.getTable().setLayoutData((Object)data);
        this.tableHistoryViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (MergeWizardUnblockRevisionsPage.this.entries == null) {
                    return new ILogEntry[0];
                }
                return MergeWizardUnblockRevisionsPage.this.entries;
            }
        });
        this.tableHistoryViewer.setInput((Object)this.fromUrl);
        this.tableHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MergeWizardUnblockRevisionsPage.this.setPageComplete(MergeWizardUnblockRevisionsPage.this.canFinish());
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    MergeWizardUnblockRevisionsPage.this.textViewer.setDocument((IDocument)new Document(""));
                    MergeWizardUnblockRevisionsPage.this.changePathsViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    MergeWizardUnblockRevisionsPage.this.textViewer.setDocument((IDocument)new Document(""));
                    MergeWizardUnblockRevisionsPage.this.changePathsViewer.setInput(null);
                    return;
                }
                LogEntry entry = (LogEntry)ss.getFirstElement();
                MergeWizardUnblockRevisionsPage.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                MergeWizardUnblockRevisionsPage.this.changePathsViewer.setCurrentLogEntry((ILogEntry)entry);
                MergeWizardUnblockRevisionsPage.this.changePathsViewer.setInput((Object)entry);
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableHistoryViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                if (!MergeWizardUnblockRevisionsPage.this.tableHistoryViewer.getSelection().isEmpty()) {
                    menuMgr.add((IAction)new ToggleSelectionAction());
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableHistoryViewer.getTable().setMenu(menu);
        Composite commentGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout commentLayout = new GridLayout();
        commentLayout.verticalSpacing = 0;
        commentLayout.marginHeight = 0;
        commentGroup.setLayout((Layout)commentLayout);
        commentGroup.setLayoutData((Object)new GridData(1808));
        this.textViewer = new TextViewer(commentGroup, 2826);
        data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 500;
        this.textViewer.getControl().setLayoutData((Object)data);
        Composite pathGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout pathLayout = new GridLayout();
        pathLayout.verticalSpacing = 0;
        pathLayout.marginHeight = 0;
        pathGroup.setLayout((Layout)pathLayout);
        pathGroup.setLayoutData((Object)new GridData(1808));
        ChangePathsTreeContentProvider contentProvider = new ChangePathsTreeContentProvider();
        this.changePathsViewer = new ChangePathsTreeViewer(pathGroup, (IContentProvider)contentProvider);
        this.setPageComplete(false);
        this.setMessage(Messages.MergeWizardUnblockRevisionsPage_specifyRevisions);
        try {
            int[] weights = new int[]{this.settings.getInt("MergeWizardRevisionsPageWeights0"), this.settings.getInt("MergeWizardRevisionsPageWeights1"), this.settings.getInt("MergeWizardRevisionsPageWeights2")};
            this.sashForm.setWeights(weights);
        }
        catch (Exception exception) {}
        this.setControl((Control)composite);
    }

    public boolean canFinish() {
        return this.getSelectedRevisions().length > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.fromUrl == null || !this.fromUrl.equals(this.standardPage.getFromUrl())) {
                this.refresh();
            }
            if (!this.pageShown) {
                this.pageShown = true;
                this.historyTableProvider.setSortColumn(this.tableHistoryViewer, 0);
                this.historyTableProvider.setSortColumn(this.tableHistoryViewer, 0);
            }
        }
    }

    private void refresh() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.setTaskName(Messages.MergeWizardUnblockRevisionsPage_retrievingRemoteResource);
                    monitor.beginTask(Messages.MergeWizardUnblockRevisionsPage_retrievingRemoteResource, 2);
                    monitor.worked(1);
                    MergeWizardUnblockRevisionsPage.this.remoteResource = (ISVNRemoteResource)MergeWizardUnblockRevisionsPage.this.repositoryLocation.getRemoteFile(new SVNUrl(MergeWizardUnblockRevisionsPage.this.fromUrl));
                    monitor.worked(1);
                    monitor.done();
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
            }
        };
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.fromUrl = this.standardPage.getFromUrl();
        ISVNMergeInfo mergeInfo = this.standardPage.getMergeInfo();
        if (mergeInfo == null) {
            this.entries = new ILogEntry[0];
            return;
        }
        this.revisionRanges = mergeInfo.getRevisionRange(this.fromUrl);
        this.remoteResource = null;
        try {
            this.getContainer().run(false, false, runnable);
            if (this.remoteResource == null) {
                this.setErrorMessage(Messages.MergeWizardUnblockRevisionsPage_errorRetrievingRemoteResource);
                this.entries = new ILogEntry[0];
            } else {
                this.getLogEntries();
            }
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            this.entries = new ILogEntry[0];
        }
        if (this.tableHistoryViewer.getInput() == null) {
            this.tableHistoryViewer.setInput((Object)this.fromUrl);
        } else {
            this.tableHistoryViewer.refresh();
        }
        this.setPageComplete(this.canFinish());
    }

    private void getLogEntries() {
        this.entryArray = new ArrayList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.setTaskName(Messages.MergeWizardUnblockRevisionsPage_retrievingRevisionLogInfo);
                    monitor.beginTask(Messages.MergeWizardUnblockRevisionsPage_retrievingRevisionLogInfo, 3);
                    if (SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_tags_in_remote")) {
                        MergeWizardUnblockRevisionsPage.this.tagManager = new AliasManager(MergeWizardUnblockRevisionsPage.this.remoteResource.getUrl());
                    }
                    SVNRevision pegRevision = MergeWizardUnblockRevisionsPage.this.remoteResource.getRevision();
                    monitor.worked(1);
                    int i = 0;
                    while (i < MergeWizardUnblockRevisionsPage.this.revisionRanges.length) {
                        MergeWizardUnblockRevisionsPage.this.rangeEntries = MergeWizardUnblockRevisionsPage.this.getLogEntries(pegRevision, MergeWizardUnblockRevisionsPage.this.revisionRanges[i].getFromRevision(), MergeWizardUnblockRevisionsPage.this.revisionRanges[i].getToRevision(), true, 0L, MergeWizardUnblockRevisionsPage.this.tagManager, true);
                        monitor.worked(1);
                        int j = 0;
                        while (j < MergeWizardUnblockRevisionsPage.this.rangeEntries.length) {
                            MergeWizardUnblockRevisionsPage.this.entryArray.add(MergeWizardUnblockRevisionsPage.this.rangeEntries[j]);
                            ++j;
                        }
                        ++i;
                    }
                    MergeWizardUnblockRevisionsPage.this.entries = new ILogEntry[MergeWizardUnblockRevisionsPage.this.entryArray.size()];
                    MergeWizardUnblockRevisionsPage.this.entryArray.toArray(MergeWizardUnblockRevisionsPage.this.entries);
                }
                catch (Exception e) {
                    MergeWizardUnblockRevisionsPage.this.setErrorMessage(e.getMessage());
                    MergeWizardUnblockRevisionsPage.this.entries = new ILogEntry[0];
                }
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (Exception e1) {
            Activator.handleError(e1);
        }
        this.setErrorMessage(this.standardPage.getErrorMessage());
    }

    private SVNRevision.Number[] getAll() {
        this.allRevisions = new SVNRevision.Number[this.entryArray.size()];
        int i = 0;
        for (ILogEntry logEntry : this.entryArray) {
            this.allRevisions[i++] = logEntry.getRevision();
        }
        return this.allRevisions;
    }

    protected ILogEntry[] getLogEntries(SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, long limit, AliasManager tagManager, boolean includeMergedRevisions) throws TeamException {
        GetLogsCommand logCmd = new GetLogsCommand(this.remoteResource, pegRevision, revisionStart, revisionEnd, stopOnCopy, limit, tagManager, includeMergedRevisions);
        logCmd.run(null);
        return logCmd.getLogEntries();
    }

    private SVNRevision.Number[] getSelectedRevisions() {
        ArrayList<SVNRevision.Number> selectedEntries = new ArrayList<SVNRevision.Number>();
        TableItem[] items = this.tableHistoryViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                ILogEntry entry = (ILogEntry)items[i].getData();
                selectedEntries.add(entry.getRevision());
            }
            ++i;
        }
        SVNRevision.Number[] entryArray = new SVNRevision.Number[selectedEntries.size()];
        selectedEntries.toArray(entryArray);
        return entryArray;
    }

    public SVNRevisionRange[] getRevisions() {
        SVNRevisionRange[] revisionRanges = SVNRevisionRange.getRevisions((SVNRevision.Number[])this.getSelectedRevisions(), (SVNRevision.Number[])this.getAll());
        SVNRevisionRange[] reversedRevisionRanges = new SVNRevisionRange[revisionRanges.length];
        int i = 0;
        while (i < revisionRanges.length) {
            reversedRevisionRanges[i] = new SVNRevisionRange(revisionRanges[i].getToRevision(), revisionRanges[i].getFromRevision());
            ++i;
        }
        return reversedRevisionRanges;
    }

    public void dispose() {
        if (this.pageShown) {
            int[] weights = this.sashForm.getWeights();
            int i = 0;
            while (i < weights.length) {
                this.settings.put("MergeWizardRevisionsPageWeights" + i, weights[i]);
                ++i;
            }
        }
        super.dispose();
    }

    public void setFromUrl(String fromUrl) {
        this.fromUrl = fromUrl;
    }

    static class ChangePathsTreeContentProvider
    implements ITreeContentProvider {
        ChangePathsTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HistoryFolder) {
                return ((HistoryFolder)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof HistoryFolder) {
                HistoryFolder folder = (HistoryFolder)element;
                return folder.getChildren().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ILogEntry logEntry = (ILogEntry)inputElement;
            return this.getGroups(logEntry.getLogEntryChangePaths());
        }

        private Object[] getGroups(LogEntryChangePath[] changePaths) {
            HashSet<String> folderNames = new HashSet<String>();
            int i = 0;
            while (i < changePaths.length) {
                folderNames.add(this.getFolderName(changePaths[i]));
                ++i;
            }
            TreeMap<String, HistoryFolder> folders = new TreeMap<String, HistoryFolder>();
            int i2 = 0;
            while (i2 < changePaths.length) {
                HistoryFolder folder;
                LogEntryChangePath changePath = changePaths[i2];
                String path = changePath.getPath();
                if (folderNames.contains(path)) {
                    folder = (HistoryFolder)folders.get(path);
                    if (folder == null) {
                        folder = new HistoryFolder(changePath);
                        folders.put(path, folder);
                    }
                } else {
                    path = this.getFolderName(changePath);
                    folder = (HistoryFolder)folders.get(path);
                    if (folder == null) {
                        folder = new HistoryFolder(path);
                        folders.put(path, folder);
                    }
                    folder.add(changePath);
                }
                ++i2;
            }
            return folders.values().toArray(new Object[folders.size()]);
        }

        private String getFolderName(LogEntryChangePath changePath) {
            String path = changePath.getPath();
            int n = path.lastIndexOf(47);
            return n > -1 ? path.substring(0, n) : path;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ToggleSelectionAction
    extends Action {
        public ToggleSelectionAction() {
            this.setText("Toggle selection");
        }

        public void run() {
            TableItem[] items = MergeWizardUnblockRevisionsPage.this.tableHistoryViewer.getTable().getSelection();
            int i = 0;
            while (i < items.length) {
                items[i].setChecked(!items[i].getChecked());
                ++i;
            }
            MergeWizardUnblockRevisionsPage.this.setPageComplete(MergeWizardUnblockRevisionsPage.this.canFinish());
        }
    }
}

