/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizard;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeWizardStandardPage
extends WizardPage {
    private Combo fromCombo;
    private Button allButton;
    private Button selectButton;
    private Composite multipleGroup;
    private Button rootButton;
    private Button separateButton;
    private IResource resource;
    private IResource[] resources;
    private ISVNLocalResource svnResource;
    private String fromUrl;
    private String repositoryLocation;
    private ISVNMergeInfo mergeInfo;
    private String[] mergeInfoPaths;
    private String[] urlStrings;
    private String commonRoot;
    private MergeResource[] mergeResources;
    private Button relativeButton;
    private IDialogSettings settings;
    private Table table;
    private TableViewer viewer;
    private String message;
    private boolean showRevisionsButtons;
    private boolean unblock;
    private boolean reintegrate;
    private String[] columnHeaders = new String[]{Messages.MergeWizardStandardPage_resource};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100, true)};

    public MergeWizardStandardPage(String pageName, String title, ImageDescriptor titleImage, String message, boolean showRevisionsButtons, boolean unblock, boolean reintegrate) {
        super(pageName, title, titleImage);
        this.message = message;
        this.showRevisionsButtons = showRevisionsButtons;
        this.settings = Activator.getDefault().getDialogSettings();
        this.unblock = unblock;
        this.reintegrate = reintegrate;
    }

    public MergeWizardStandardPage(String pageName, String title, ImageDescriptor titleImage) {
        this(pageName, title, titleImage, null, true, false, false);
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(1808));
        Label fromLabel = new Label(outerContainer, 0);
        fromLabel.setText(Messages.MergeWizardStandardPage_from);
        this.fromCombo = this.unblock ? new Combo(outerContainer, 2056) : new Combo(outerContainer, 2048);
        GridData data = new GridData(768);
        this.fromCombo.setLayoutData((Object)data);
        this.fromCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MergeWizardStandardPage.this.fromCombo.getText().startsWith("/")) {
                    MergeWizardStandardPage.this.fromUrl = String.valueOf(MergeWizardStandardPage.this.repositoryLocation) + MergeWizardStandardPage.this.fromCombo.getText().trim();
                } else {
                    MergeWizardStandardPage.this.fromUrl = MergeWizardStandardPage.this.fromCombo.getText().trim();
                }
                if (MergeWizardStandardPage.this.viewer != null) {
                    MergeWizardStandardPage.this.viewer.refresh();
                }
                MergeWizardStandardPage.this.setPageComplete(MergeWizardStandardPage.this.canFinish());
            }
        });
        Button selectFromButton = new Button(outerContainer, 8);
        selectFromButton.setText(Messages.MergeWizardStandardPage_select);
        selectFromButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(MergeWizardStandardPage.this.getShell(), MergeWizardStandardPage.this.resource);
                dialog.setIncludeBranchesAndTags(MergeWizardStandardPage.this.resources.length == 1);
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    MergeWizardStandardPage.this.fromUrl = dialog.getUrl();
                    MergeWizardStandardPage.this.fromCombo.setText(MergeWizardStandardPage.this.fromUrl.substring(MergeWizardStandardPage.this.repositoryLocation.length()));
                }
            }
        });
        if (this.unblock) {
            selectFromButton.setVisible(false);
        }
        MergeWizard wizard = (MergeWizard)this.getWizard();
        this.resources = wizard.getResources();
        if (this.resources != null) {
            this.commonRoot = this.getCommonRoot();
            if (this.resources.length > 1) {
                this.relativeButton = new Button(outerContainer, 32);
                this.relativeButton.setText(Messages.MergeWizardStandardPage_relativeTo);
                data = new GridData();
                data.horizontalSpan = 3;
                this.relativeButton.setLayoutData((Object)data);
                this.relativeButton.setSelection(true);
                this.relativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MergeWizardStandardPage.this.settings.put("MergeWizard.relativePath", MergeWizardStandardPage.this.relativeButton.getSelection());
                        MergeWizardStandardPage.this.viewer.refresh();
                    }
                });
                Label label = new Label(outerContainer, 0);
                label.setText(Messages.MergeWizardStandardPage_resources);
                data = new GridData();
                data.horizontalSpan = 3;
                label.setLayoutData((Object)data);
                this.table = new Table(outerContainer, 2816);
                this.table.setLinesVisible(false);
                this.table.setHeaderVisible(false);
                data = new GridData(768);
                data.heightHint = 85;
                data.horizontalSpan = 3;
                this.table.setLayoutData((Object)data);
                TableLayout tableLayout = new TableLayout();
                this.table.setLayout((Layout)tableLayout);
                this.viewer = new TableViewer(this.table);
                this.viewer.setContentProvider((IContentProvider)new MergeContentProvider());
                ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
                this.viewer.setLabelProvider((IBaseLabelProvider)new TableDecoratingLabelProvider((ILabelProvider)new MergeLabelProvider(), decorator));
                int i = 0;
                while (i < this.columnHeaders.length) {
                    tableLayout.addColumnData(this.columnLayouts[i]);
                    TableColumn tc = new TableColumn(this.table, 0, i);
                    tc.setResizable(this.columnLayouts[i].resizable);
                    tc.setText(this.columnHeaders[i]);
                    ++i;
                }
                this.viewer.setInput((Object)this);
            }
        }
        Group revisionsGroup = new Group(outerContainer, 0);
        revisionsGroup.setText(Messages.MergeWizardStandardPage_revisions);
        GridLayout revisionsLayout = new GridLayout();
        revisionsLayout.numColumns = 1;
        revisionsGroup.setLayout((Layout)revisionsLayout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        revisionsGroup.setLayoutData((Object)data);
        this.allButton = new Button((Composite)revisionsGroup, 16);
        this.allButton.setText(Messages.MergeWizardStandardPage_allEligible);
        this.selectButton = new Button((Composite)revisionsGroup, 16);
        this.selectButton.setText(Messages.MergeWizardStandardPage_selectRevisions);
        boolean selectRevisions = false;
        try {
            selectRevisions = this.settings.getBoolean("MergeWizardStandardPage.selectRevisions");
        }
        catch (Exception exception) {}
        if (selectRevisions) {
            this.selectButton.setSelection(true);
        } else {
            this.allButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeWizardStandardPage.this.settings.put("MergeWizardStandardPage.selectRevisions", MergeWizardStandardPage.this.selectButton.getSelection());
                MergeWizardStandardPage.this.setPageComplete(MergeWizardStandardPage.this.canFinish());
                if (MergeWizardStandardPage.this.multipleGroup != null) {
                    MergeWizardStandardPage.this.multipleGroup.setEnabled(MergeWizardStandardPage.this.selectButton.getSelection());
                    MergeWizardStandardPage.this.rootButton.setEnabled(MergeWizardStandardPage.this.selectButton.getSelection());
                    MergeWizardStandardPage.this.separateButton.setEnabled(MergeWizardStandardPage.this.selectButton.getSelection());
                }
            }
        };
        this.allButton.addSelectionListener((SelectionListener)selectionListener);
        this.selectButton.addSelectionListener((SelectionListener)selectionListener);
        if (this.resources.length > 1) {
            this.multipleGroup = new Composite((Composite)revisionsGroup, 0);
            GridLayout multipleLayout = new GridLayout();
            multipleLayout.numColumns = 1;
            multipleLayout.marginLeft = 20;
            this.multipleGroup.setLayout((Layout)multipleLayout);
            data = new GridData(768);
            this.multipleGroup.setLayoutData((Object)data);
            this.rootButton = new Button(this.multipleGroup, 16);
            this.rootButton.setText(Messages.MergeWizardStandardPage_0);
            this.separateButton = new Button(this.multipleGroup, 16);
            this.separateButton.setText(Messages.MergeWizardStandardPage_1);
            this.multipleGroup.setEnabled(this.selectButton.getSelection());
            this.rootButton.setEnabled(this.selectButton.getSelection());
            this.separateButton.setEnabled(this.selectButton.getSelection());
            boolean retrieveEligibleRevisionsSeparately = false;
            try {
                retrieveEligibleRevisionsSeparately = this.settings.getBoolean("MergeWizard.retrieveEligibleRevisionsSeparately");
            }
            catch (Exception exception) {
                this.settings.put("MergeWizard.retrieveEligibleRevisionsSeparately", false);
            }
            if (retrieveEligibleRevisionsSeparately) {
                this.separateButton.setSelection(true);
            } else {
                this.rootButton.setSelection(true);
            }
            SelectionAdapter multipleListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    MergeWizardStandardPage.this.settings.put("MergeWizard.retrieveEligibleRevisionsSeparately", MergeWizardStandardPage.this.separateButton.getSelection());
                    ((MergeWizard)MergeWizardStandardPage.this.getWizard()).setRetrieveRevisionsMethodChanged(true);
                }
            };
            this.rootButton.addSelectionListener((SelectionListener)multipleListener);
            this.separateButton.addSelectionListener((SelectionListener)multipleListener);
        }
        if (!this.showRevisionsButtons) {
            revisionsGroup.setVisible(false);
        }
        this.setPageComplete(this.canFinish());
        if (this.message == null) {
            this.setMessage(Messages.MergeWizardStandardPage_specifyLocation);
        } else {
            this.setMessage(this.message);
        }
        this.setControl((Control)outerContainer);
    }

    public String getMergeFrom() {
        return this.fromCombo.getText().trim();
    }

    public boolean selectRevisions() {
        return this.selectButton.getSelection();
    }

    private boolean canFinish() {
        this.setErrorMessage(null);
        if (this.fromCombo.getText().trim().length() == 0) {
            return false;
        }
        if (!this.validateUrl()) {
            this.setErrorMessage(Messages.MergeWizardStandardPage_invalidUrl);
            return false;
        }
        return true;
    }

    private boolean validateUrl() {
        if (!this.fromCombo.getText().startsWith("/")) {
            try {
                new SVNUrl(this.fromCombo.getText().trim());
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return true;
    }

    public String getFromUrl() {
        return this.fromUrl;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fromUrl == null) {
            this.initializeLocations();
        }
        super.setVisible(visible);
    }

    private void initializeLocations() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block12: {
                    monitor.setTaskName(Messages.MergeWizardStandardPage_retrievingMergeSourceInfo);
                    monitor.beginTask(Messages.MergeWizardStandardPage_retrievingMergeSourceInfo, -1);
                    monitor.subTask("");
                    MergeWizard wizard = (MergeWizard)MergeWizardStandardPage.this.getWizard();
                    MergeWizardStandardPage.this.resource = wizard.getResource();
                    MergeWizardStandardPage.this.resources = wizard.getResources();
                    MergeWizardStandardPage.this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)MergeWizardStandardPage.this.resource);
                    MergeWizardStandardPage.this.mergeInfoPaths = null;
                    try {
                        MergeWizardStandardPage.this.fromUrl = MergeWizardStandardPage.this.svnResource.getStatus().getUrlString();
                    }
                    catch (Exception e) {
                        Activator.handleError(e);
                    }
                    MergeWizardStandardPage.this.repositoryLocation = MergeWizardStandardPage.this.svnResource.getRepository().getLocation();
                    try {
                        ISVNClientAdapter svnClient = MergeWizardStandardPage.this.svnResource.getRepository().getSVNClient();
                        try {
                            if (MergeWizardStandardPage.this.unblock) {
                                try {
                                    MergeWizardStandardPage.this.mergeInfo = svnClient.getMergeInfo(new SVNUrl(MergeWizardStandardPage.this.commonRoot), SVNRevision.HEAD);
                                }
                                catch (Exception exception) {}
                                if (MergeWizardStandardPage.this.mergeInfo != null) {
                                    MergeWizardStandardPage.this.mergeInfoPaths = MergeWizardStandardPage.this.mergeInfo.getPaths();
                                }
                                if (MergeWizardStandardPage.this.mergeInfoPaths == null || MergeWizardStandardPage.this.mergeInfoPaths.length == 0) {
                                    MergeWizardStandardPage.this.setErrorMessage(Messages.MergeWizardStandardPage_noRevisionsToUnblock);
                                }
                                break block12;
                            }
                            if (!MergeWizardStandardPage.this.reintegrate) {
                                MergeWizardStandardPage.this.mergeInfoPaths = svnClient.suggestMergeSources(new SVNUrl(MergeWizardStandardPage.this.commonRoot), SVNRevision.HEAD);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception e) {
                        Activator.handleError(e);
                    }
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (Exception e2) {
            Activator.handleError(e2);
        }
        boolean valueAdded = false;
        ArrayList<String> fromUrls = new ArrayList<String>();
        if (this.mergeInfoPaths != null) {
            int i = 0;
            while (i < this.mergeInfoPaths.length) {
                String url = this.mergeInfoPaths[i].substring(this.repositoryLocation.length());
                if (!fromUrls.contains(url)) {
                    fromUrls.add(url);
                }
                valueAdded = true;
                ++i;
            }
        }
        String previousFromUrls = null;
        String previousFromUrl = null;
        try {
            previousFromUrls = Activator.getDefault().getDialogSettings().get("mergeFromUrls_" + this.commonRoot);
        }
        catch (Exception exception) {}
        if (previousFromUrls != null) {
            String[] urls;
            String[] stringArray = urls = previousFromUrls.split("\\,");
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                if (!fromUrls.contains(url)) {
                    fromUrls.add(url);
                }
                valueAdded = true;
                ++n2;
            }
            if (urls.length > 0) {
                previousFromUrl = urls[0];
            }
        }
        if (!valueAdded && !this.unblock) {
            fromUrls.add(this.commonRoot.substring(this.repositoryLocation.length()));
        }
        for (String url : fromUrls) {
            this.fromCombo.add(url);
        }
        if (previousFromUrl != null) {
            this.fromCombo.setText(previousFromUrl);
        } else if (this.fromCombo.getItemCount() > 0) {
            this.fromCombo.setText(this.fromCombo.getItem(0));
        }
    }

    public IResource getResource() {
        return this.resource;
    }

    public IResource[] getResources() {
        return this.resources;
    }

    public SVNUrl getUrl() {
        SVNUrl url = null;
        try {
            url = new SVNUrl(this.fromUrl);
        }
        catch (MalformedURLException e) {
            Activator.handleError(e);
        }
        return url;
    }

    public SVNUrl[] getUrls() {
        if (this.resources.length == 1) {
            SVNUrl[] urls = new SVNUrl[]{this.getUrl()};
            return urls;
        }
        final boolean[] useRelativePath = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                useRelativePath[0] = MergeWizardStandardPage.this.relativeButton != null && MergeWizardStandardPage.this.relativeButton.getSelection();
            }
        });
        SVNUrl[] urls = new SVNUrl[this.mergeResources.length];
        int i = 0;
        while (i < this.mergeResources.length) {
            try {
                urls[i] = !useRelativePath[0] ? new SVNUrl(this.fromUrl) : (this.fromUrl.endsWith("/") ? new SVNUrl(String.valueOf(this.fromUrl) + this.mergeResources[i].getPartialPath()) : new SVNUrl(String.valueOf(this.fromUrl) + "/" + this.mergeResources[i].getPartialPath()));
            }
            catch (MalformedURLException e) {
                Activator.handleError(e);
            }
            ++i;
        }
        return urls;
    }

    private String getCommonRoot() {
        this.commonRoot = ((MergeWizard)this.getWizard()).getCommonRoot();
        this.urlStrings = ((MergeWizard)this.getWizard()).getUrlStrings();
        this.mergeResources = new MergeResource[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            this.mergeResources[i] = this.urlStrings[i].length() <= this.commonRoot.length() ? new MergeResource(this.resources[i], this.commonRoot) : new MergeResource(this.resources[i], this.urlStrings[i].substring(this.commonRoot.length() + 1));
            ++i;
        }
        return this.commonRoot;
    }

    public String getCommonRoot(boolean calculateRoot) {
        if (calculateRoot) {
            return this.getCommonRoot();
        }
        return this.commonRoot;
    }

    public ISVNMergeInfo getMergeInfo() {
        return this.mergeInfo;
    }

    class MergeContentProvider
    implements IStructuredContentProvider {
        MergeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object obj) {
            return MergeWizardStandardPage.this.mergeResources;
        }
    }

    class MergeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        MergeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }

        public String getText(Object element) {
            MergeResource mergeResource = (MergeResource)element;
            if (MergeWizardStandardPage.this.relativeButton.getSelection()) {
                return String.valueOf(mergeResource.getPartialPath()) + " [" + MergeWizardStandardPage.this.fromCombo.getText() + "/" + mergeResource.getPartialPath() + "]";
            }
            return String.valueOf(mergeResource.getPartialPath()) + " [" + MergeWizardStandardPage.this.fromCombo.getText() + "]";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public Image getImage(Object element) {
            MergeResource mergeResource = (MergeResource)element;
            return this.workbenchLabelProvider.getImage((Object)mergeResource.getResource());
        }
    }

    private class MergeResource
    implements IAdaptable {
        private IResource resource;
        private String partialPath;

        public MergeResource(IResource resource, String partialPath) {
            this.resource = resource;
            this.partialPath = partialPath;
        }

        public IResource getResource() {
            return this.resource;
        }

        public void setResource(IResource resource) {
            this.resource = resource;
        }

        public String getPartialPath() {
            return this.partialPath;
        }

        public void setPartialPath(String partialPath) {
            this.partialPath = partialPath;
        }

        public Object getAdapter(Class adapter) {
            if (IResource.class == adapter) {
                return this.resource;
            }
            return null;
        }
    }

    class TableDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        ITableLabelProvider provider;
        ILabelDecorator decorator;

        public TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
            this.provider = (ITableLabelProvider)provider;
            this.decorator = decorator;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image decorated;
            Image image = this.provider.getColumnImage(element, columnIndex);
            if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
                return decorated;
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = this.provider.getColumnText(element, columnIndex);
            return text;
        }
    }
}

