/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.UndoMergeCommand;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;

public class UndoMergeOperation
extends SVNOperation {
    private IResource[] mergedResources;

    public UndoMergeOperation(IWorkbenchPart part, IResource[] resources) {
        super(part);
        this.mergedResources = resources;
    }

    protected String getTaskName() {
        return Messages.UndoMergeOperation_undo;
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return String.valueOf(Messages.UndoMergeOperation_undo2) + provider.getProject().getName();
    }

    protected boolean canRunAsJob() {
        return false;
    }

    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(this.getTaskName(), this.mergedResources.length);
        try {
            try {
                int i = 0;
                while (i < this.mergedResources.length) {
                    monitor.subTask(this.mergedResources[i].getName());
                    UndoMergeCommand command = new UndoMergeCommand(this.mergedResources[i]);
                    command.run(Policy.subMonitorFor((IProgressMonitor)monitor, (int)100));
                    monitor.worked(1);
                    ++i;
                }
            }
            catch (SVNException e) {
                this.collectStatus(e.getStatus());
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

