/* Copyright (c) 2004 Something Software Ltd. All rights reserved.*/ 
package com.something.eclipse.shelled.ui.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;

import com.something.eclipse.script.editors.ScriptEditorDocumentProvider;
import com.something.eclipse.shelled.ui.text.SHPartitionScanner;

/**
 * 
 * @author Doug Satchwell
 * @version $Id: SHDocumentProvider.java,v 1.2 2005/11/13 19:44:15 dougsatch Exp $
 */
public class SHDocumentProvider extends ScriptEditorDocumentProvider
{
	private SHEditor editor;
	
	public SHDocumentProvider(SHEditor editor)
	{
		super();
		this.editor = editor;
	}
	
	protected IDocument createDocument(Object element) throws CoreException 
	{
		IDocument document = super.createDocument(element);
		if (document != null) 
		{
			IDocumentPartitioner partitioner =
				new DefaultPartitioner(
					new SHPartitionScanner(),SHPartitionScanner.CONTENT_TYPES);
			partitioner.connect(document);
			document.setDocumentPartitioner(partitioner);
		}
		return document;
	}
	
	protected IDocument createEmptyDocument() {
		return new SHDocument();
	}

}