/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.shelled.ui.text;

import com.something.eclipse.shelled.ui.editors.ColorConstants;
import com.something.eclipse.shelled.ui.editors.ColorManager;
import com.something.eclipse.shelled.ui.text.SHDoubleQuoteScanner;
import com.something.eclipse.shelled.ui.text.SHScanner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.RGB;

public class SHScannerManager {
    private int shellType;
    private ColorManager colorManager;

    public SHScannerManager(ColorManager colorManager, int shellType) {
        this.colorManager = colorManager;
        this.shellType = shellType;
    }

    public ITokenScanner getScanner(String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return this.getScriptScanner();
        }
        if ("__comment".equals(contentType)) {
            return this.getCommentScanner();
        }
        if ("__hashbang".equals(contentType)) {
            return this.getHashBangScanner();
        }
        if ("__single_quote".equals(contentType)) {
            return this.getSingleQuoteScanner();
        }
        if ("__double_quote".equals(contentType)) {
            return this.getDoubleQuoteScanner();
        }
        if ("__eval".equals(contentType)) {
            return this.getEvalScanner();
        }
        return null;
    }

    private SHScanner getScriptScanner() {
        SHScanner scanner = new SHScanner(this.colorManager, this.shellType);
        scanner.refresh();
        return scanner;
    }

    private RuleBasedPartitionScanner getCommentScanner() {
        return this.createRuleBasedScanner(ColorConstants.COMMENT);
    }

    private RuleBasedPartitionScanner getHashBangScanner() {
        return this.createRuleBasedScanner(ColorConstants.HASHBANG);
    }

    private SHDoubleQuoteScanner getDoubleQuoteScanner() {
        SHDoubleQuoteScanner scanner = new SHDoubleQuoteScanner(this.colorManager, this.shellType);
        scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorConstants.DOUBLE_QUOTE))));
        scanner.refresh();
        return scanner;
    }

    private RuleBasedPartitionScanner getSingleQuoteScanner() {
        return this.createRuleBasedScanner(ColorConstants.SINGLE_QUOTE);
    }

    private RuleBasedPartitionScanner getEvalScanner() {
        return this.createRuleBasedScanner(ColorConstants.EVAL_TYPE);
    }

    private RuleBasedPartitionScanner createRuleBasedScanner(RGB colour) {
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
        scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(colour))));
        return scanner;
    }
}

