/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.shelled.ui.text;

import com.something.eclipse.script.text.ScriptScanner;
import com.something.eclipse.script.text.WhitespaceDetector;
import com.something.eclipse.shelled.ui.UIPlugin;
import com.something.eclipse.shelled.ui.editors.ColorConstants;
import com.something.eclipse.shelled.ui.editors.ColorManager;
import com.something.eclipse.shelled.ui.text.SHAssignmentRule;
import com.something.eclipse.shelled.ui.text.SHDollarRule;
import com.something.eclipse.shelled.ui.text.SHWords;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class SHScanner
extends ScriptScanner {
    private int shellType;
    private ColorManager manager;

    public SHScanner(ColorManager manager, int shellType) {
        this.shellType = shellType;
        this.manager = manager;
    }

    protected IRule[] createRules() {
        ArrayList<Object> rules = new ArrayList<Object>(50);
        Token keywordToken = new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.KEYWORD), null, 1));
        Token commandToken = new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.FUNCTION)));
        Token defaultToken = new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.DEFAULT)));
        Token varToken = new Token((Object)new TextAttribute(this.manager.getColor(ColorConstants.VARIABLE_TYPE)));
        IWordDetector wordDetector = new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        };
        IWordDetector dollarDetector = new IWordDetector(){

            public boolean isWordStart(char c) {
                return c == '$';
            }

            public boolean isWordPart(char c) {
                return Character.isLetterOrDigit(c);
            }
        };
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new SHAssignmentRule(wordDetector, Token.UNDEFINED, (IToken)varToken));
        rules.add(new SHDollarRule(dollarDetector, Token.UNDEFINED, (IToken)varToken, false, '{', '}'));
        WordRule wordRule = new WordRule(wordDetector, (IToken)defaultToken);
        SHWords words = UIPlugin.getDefault().getWords(this.shellType);
        SHScanner.addWords((WordRule)wordRule, (String[])words.getCommands(), (IToken)commandToken);
        SHScanner.addWords((WordRule)wordRule, (String[])words.getKeywords(), (IToken)keywordToken);
        rules.add(wordRule);
        IRule[] rule = new IRule[rules.size()];
        return rules.toArray(rule);
    }
}

