/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.shelled.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class TextHoverFocusAction
extends TextEditorAction {
    private final TextOperationAction textOperationAction;
    private ISourceViewer sourceViewer;
    private InformationPresenter informationPresenter;

    public TextHoverFocusAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction, ITextEditor editor, ISourceViewer sourceViewer, InformationPresenter informationPresenter) {
        super(resourceBundle, prefix, editor);
        if (textOperationAction == null) {
            throw new IllegalArgumentException();
        }
        this.textOperationAction = textOperationAction;
        this.sourceViewer = sourceViewer;
        this.informationPresenter = informationPresenter;
    }

    public void run() {
        ITextViewerExtension4 extension4;
        if (this.sourceViewer == null) {
            this.textOperationAction.run();
            return;
        }
        if (this.sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)this.sourceViewer).moveFocusToWidgetToken()) {
            return;
        }
        ITextViewerExtension2 textViewerExtension2 = (ITextViewerExtension2)this.sourceViewer;
        ITextHover textHover = textViewerExtension2.getCurrentTextHover();
        if (textHover == null) {
            this.textOperationAction.run();
            return;
        }
        Point hoverEventLocation = textViewerExtension2.getHoverEventLocation();
        int offset = this.computeOffsetAtLocation((ITextViewer)this.sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
        if (offset == -1) {
            this.textOperationAction.run();
            return;
        }
        try {
            String contentType = TextUtilities.getContentType((IDocument)this.sourceViewer.getDocument(), (String)"__dftl_partition_content_type", (int)offset, (boolean)true);
            IRegion hoverRegion = textHover.getHoverRegion((ITextViewer)this.sourceViewer, offset);
            if (hoverRegion == null) {
                return;
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)this.sourceViewer, hoverRegion);
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            private class InformationProvider
            implements IInformationProvider,
            IInformationProviderExtension2 {
                private IRegion fHoverRegion;
                private String fHoverInfo;
                private IInformationControlCreator fControlCreator;

                InformationProvider(IRegion hoverRegion, String hoverInfo, IInformationControlCreator controlCreator) {
                    this.fHoverRegion = hoverRegion;
                    this.fHoverInfo = hoverInfo;
                    this.fControlCreator = controlCreator;
                }

                public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
                    return this.fHoverRegion;
                }

                public String getInformation(ITextViewer textViewer, IRegion subject) {
                    return this.fHoverInfo;
                }

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return this.fControlCreator;
                }
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            this.informationPresenter.setOffset(offset);
            this.informationPresenter.setDocumentPartitioning("__dftl_partition_content_type");
            this.informationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            this.informationPresenter.showInformation();
        }
        catch (BadLocationException badLocationException) {}
    }

    private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
        StyledText styledText = textViewer.getTextWidget();
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return -1;
        }
        try {
            int widgetLocation = styledText.getOffsetAtLocation(new Point(x, y));
            if (textViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                return extension.widgetOffset2ModelOffset(widgetLocation);
            }
            IRegion visibleRegion = textViewer.getVisibleRegion();
            return widgetLocation + visibleRegion.getOffset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }
}

