/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.freebsd;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.os.freebsd.Activator;
import org.eclipse.wb.internal.os.freebsd.IScreenshotCallback;
import org.eclipse.wb.os.OSSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OSSupportFreeBSD<H extends Number>
extends OSSupport {
    private static final Color TITLE_BORDER_COLOR_DARKEST;
    private static final Color TITLE_BORDER_COLOR_DARKER;
    protected static final OSSupport INSTANCE;
    private String m_oldShellText;
    private Map<H, Control> m_controlsRegistry;
    private boolean m_eclipseToggledOnTop;
    private Shell m_eclipseShell;

    static {
        System.loadLibrary("wbp");
        TITLE_BORDER_COLOR_DARKEST = DrawUtils.getShiftedColor((Color)IColorConstants.titleBackground, (int)-24);
        TITLE_BORDER_COLOR_DARKER = DrawUtils.getShiftedColor((Color)IColorConstants.titleBackground, (int)-16);
        INSTANCE = EnvironmentUtils.IS_64BIT_OS ? new Impl64() : new Impl32();
    }

    private void prepareScreenshot(Shell shell) throws Exception {
        this.createRegistry();
        this.registerControl((Control)shell);
        this.registerByHandle((Control)shell, "shellHandle");
    }

    private void createRegistry() {
        this.m_controlsRegistry = Maps.newHashMap();
    }

    private void registerControl(Control control) throws Exception {
        Point size = control.getSize();
        if (size.x == 0 || size.y == 0) {
            return;
        }
        this.registerByHandle(control, "fixedHandle");
        this.registerByHandle(control, "handle");
        control.setData("WBP_IMAGE", null);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.registerControl(child);
                ++n2;
            }
        }
    }

    private void registerByHandle(Control control, String handleName) throws Exception {
        H handle = this.getHandleValue(control, handleName);
        if (handle != null) {
            this.m_controlsRegistry.put(handle, control);
        }
    }

    private Shell getShell(Object controlObject) {
        Assert.instanceOf(Control.class, (Object)controlObject);
        Control control = (Control)controlObject;
        return control.getShell();
    }

    public void beginShot(Object controlObject) {
        Shell shell = this.getShell(controlObject);
        this.changeTitle(shell);
        if (!this.isWorkaroundsDisabled()) {
            OSSupportFreeBSD._begin_shot(this.getShellHandle(shell));
            try {
                ReflectionUtils.invokeMethod((Object)shell, (String)"adjustTrim()", (Object[])new Object[0]);
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
            this.m_eclipseShell = DesignerPlugin.getShell();
            if (this.m_eclipseShell != null) {
                this.m_eclipseToggledOnTop = OSSupportFreeBSD._toggle_above(this.getShellHandle(this.m_eclipseShell), false);
            }
        } else {
            shell.setLocation(10000, 10000);
            shell.setVisible(true);
        }
    }

    public void endShot(Object controlObject) {
        Shell shell = this.getShell(controlObject);
        shell.setVisible(false);
        this.restoreTitle(shell);
        if (!this.isWorkaroundsDisabled()) {
            OSSupportFreeBSD._end_shot(this.getShellHandle(shell));
            if (this.m_eclipseShell != null) {
                OSSupportFreeBSD._toggle_above(this.getShellHandle(this.m_eclipseShell), this.m_eclipseToggledOnTop);
            }
        }
    }

    private void changeTitle(Shell shell) {
        this.m_oldShellText = shell.getText();
        shell.setText("__wbp_preview_window");
    }

    private void restoreTitle(Shell shell) {
        shell.setText(this.m_oldShellText);
    }

    public void makeShots(Object controlObject) throws Exception {
        Shell shell = this.getShell(controlObject);
        this.makeShots0(shell);
        this.drawDecorations(shell, shell.getDisplay());
    }

    private void makeShots0(Shell shell) throws Exception {
        this.prepareScreenshot(shell);
        H shellHandle = this.getShellHandle(shell);
        final HashSet disposePixmaps = Sets.newHashSet();
        OSSupportFreeBSD._makeShot(shellHandle, new IScreenshotCallback<H>(){

            @Override
            public void storeImage(H handle, H pixmap) {
                Control imageForControl = (Control)OSSupportFreeBSD.this.m_controlsRegistry.get(handle);
                if (imageForControl == null || !OSSupportFreeBSD.this.bindImage(imageForControl, pixmap)) {
                    disposePixmaps.add(pixmap);
                }
            }
        });
        for (Number pixmap : disposePixmaps) {
            OSSupportFreeBSD._g_object_unref(pixmap);
        }
    }

    private boolean bindImage(final Control control, final H pixmap) {
        return (Boolean)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

            public Boolean runObject() throws Exception {
                if (control.getData("WBP_NEED_IMAGE") != null && control.getData("WBP_IMAGE") == null) {
                    Image image = OSSupportFreeBSD.this.createImage(pixmap);
                    control.setData("WBP_IMAGE", (Object)image);
                    return true;
                }
                return false;
            }
        });
    }

    public Image makeShot(Control control) throws Exception {
        Shell shell = this.getShell(control);
        shell.setLocation(10000, 10000);
        shell.setVisible(true);
        this.changeTitle(shell);
        Rectangle controlBounds = control.getBounds();
        if (controlBounds.width == 0 || controlBounds.height == 0) {
            return null;
        }
        try {
            H widgetHandle = this.getHandleValue(shell, "fixedHandle");
            if (widgetHandle == null) {
                widgetHandle = this.getHandleValue(shell, "handle");
            }
            H pixmap = OSSupportFreeBSD._makeShot(widgetHandle, null);
            Image image = this.createImage(pixmap);
            return image;
        }
        finally {
            shell.setVisible(false);
            this.restoreTitle(shell);
        }
    }

    private void drawDecorations(Shell shell, Display display) {
        Rectangle shellBounds = shell.getBounds();
        Image shellImage = (Image)shell.getData("WBP_IMAGE");
        if (shellImage != null) {
            Rectangle imageBounds = shellImage.getBounds();
            if (imageBounds.width != shellBounds.width || imageBounds.height != shellBounds.height) {
                Point offset = shell.toControl(shell.getLocation());
                offset.x = -offset.x;
                offset.y = -offset.y;
                if (shell.getMenuBar() != null) {
                    offset.y -= this.getWidgetBounds((Object)shell.getMenuBar()).height;
                }
                Image decoratedShellImage = new Image((Device)display, shellBounds);
                GC gc = new GC((Drawable)decoratedShellImage);
                gc.setBackground(IColorConstants.titleBackground);
                gc.fillRectangle(0, 0, shellBounds.width, shellBounds.height);
                if ((shell.getStyle() & 0x20) != 0) {
                    gc.setForeground(IColorConstants.titleGradient);
                    gc.fillGradientRectangle(0, 0, shellBounds.width, offset.y, true);
                    int buttonGapX = offset.x - 1;
                    Image buttonImage = Activator.getImage("decorations/button-menu-icon.png");
                    Rectangle buttonImageBounds = buttonImage.getBounds();
                    int buttonOffsetY = offset.y / 2 - buttonImageBounds.height / 2;
                    gc.drawImage(buttonImage, buttonGapX, buttonOffsetY);
                    int nextPositionX = buttonGapX + buttonImageBounds.width + buttonGapX;
                    String shellTitle = this.m_oldShellText;
                    if (!StringUtils.isEmpty((String)shellTitle)) {
                        gc.setForeground(IColorConstants.titleForeground);
                        Point titleExtent = gc.stringExtent(shellTitle);
                        gc.drawString(shellTitle, nextPositionX, offset.y / 2 - titleExtent.y / 2, true);
                    }
                    buttonImage = Activator.getImage("decorations/button-close-icon.png");
                    buttonImageBounds = buttonImage.getBounds();
                    nextPositionX = shellBounds.width - buttonImageBounds.width - buttonGapX;
                    buttonOffsetY = offset.y / 2 - buttonImageBounds.height / 2;
                    gc.drawImage(buttonImage, nextPositionX, buttonOffsetY);
                    buttonImage = Activator.getImage("decorations/button-max-icon.png");
                    buttonImageBounds = buttonImage.getBounds();
                    buttonOffsetY = offset.y / 2 - buttonImageBounds.height / 2;
                    gc.drawImage(buttonImage, nextPositionX -= buttonGapX + buttonImageBounds.width, buttonOffsetY);
                    buttonImage = Activator.getImage("decorations/button-min-icon.png");
                    buttonImageBounds = buttonImage.getBounds();
                    buttonOffsetY = offset.y / 2 - buttonImageBounds.height / 2;
                    gc.drawImage(buttonImage, nextPositionX -= buttonGapX + buttonImageBounds.width, buttonOffsetY);
                }
                gc.setForeground(TITLE_BORDER_COLOR_DARKEST);
                gc.drawRectangle(offset.x - 1, offset.y - 1, imageBounds.width + 1, imageBounds.height + 1);
                gc.setForeground(TITLE_BORDER_COLOR_DARKER);
                gc.drawRectangle(offset.x - 2, offset.y - 2, imageBounds.width + 3, imageBounds.height + 3);
                gc.drawImage(shellImage, offset.x, offset.y);
                gc.dispose();
                shellImage.dispose();
                shell.setData("WBP_IMAGE", (Object)decoratedShellImage);
            }
        }
    }

    private Rectangle getWidgetBounds(Object widget) {
        H widgetHandle = this.getHandleValue(widget, "handle");
        int[] sizes = new int[4];
        OSSupportFreeBSD._getWidgetBounds(widgetHandle, sizes);
        return new Rectangle(sizes[0], sizes[1], sizes[2], sizes[3]);
    }

    private H getShellHandle(Shell shell) {
        H widgetHandle = this.getHandleValue(shell, "fixedHandle");
        if (widgetHandle == null) {
            widgetHandle = this.getHandleValue(shell, "shellHandle");
        }
        return widgetHandle;
    }

    protected abstract H getHandleValue(Object var1, String var2);

    protected abstract Image createImage0(H var1) throws Exception;

    private Image createImage(H pixmap) throws Exception {
        Image image = this.createImage0(pixmap);
        try {
            Number surfaceValue = (Number)ReflectionUtils.getFieldObject((Object)image, (String)"surface");
            if (surfaceValue.longValue() != 0L) {
                image.getImageData();
            }
        }
        catch (Throwable throwable) {}
        return image;
    }

    public Image getMenuPopupVisualData(Menu menu, int[] bounds) throws Exception {
        H handle = this.getHandleValue(menu, "handle");
        H pixmap = OSSupportFreeBSD._fetchMenuVisualData(handle, bounds);
        return this.createImage(pixmap);
    }

    public Image getMenuBarVisualData(Menu menu, List<Rectangle> bounds) {
        int i = 0;
        while (i < menu.getItemCount()) {
            MenuItem item = menu.getItem(i);
            bounds.add(this.getWidgetBounds(item));
            ++i;
        }
        return null;
    }

    public final Rectangle getMenuBarBounds(Menu menu) {
        Rectangle bounds = this.getWidgetBounds(menu);
        Shell shell = menu.getShell();
        Point p = shell.toControl(shell.getLocation());
        p.x = -p.x;
        p.y = -p.y - bounds.height;
        return new Rectangle(p.x, p.y, bounds.width, bounds.height);
    }

    public final int getDefaultMenuBarHeight() {
        return 24;
    }

    public final Rectangle getTabItemBounds(Object tabItem) {
        return this.getWidgetBounds(tabItem);
    }

    private boolean isWorkaroundsDisabled() {
        return Boolean.parseBoolean(System.getProperty("__wbp.freebsd.disableScreenshotWorkarounds"));
    }

    public void setAlpha(Shell shell, int alpha) {
        OSSupportFreeBSD._setAlpha(this.getShellHandle(shell), alpha);
    }

    public int getAlpha(Shell shell) {
        return OSSupportFreeBSD._getAlpha(this.getShellHandle(shell));
    }

    public boolean isPlusMinusTreeClick(Tree tree, int x, int y) {
        return OSSupportFreeBSD._isPlusMinusTreeClick(this.getHandleValue(tree, "handle"), x, y);
    }

    private static native <H extends Number> boolean _isPlusMinusTreeClick(H var0, int var1, int var2);

    private static native <H extends Number> void _setAlpha(H var0, int var1);

    private static native <H extends Number> int _getAlpha(H var0);

    private static native <H extends Number> void _getWidgetBounds(H var0, int[] var1);

    private static native <H extends Number> H _fetchMenuVisualData(H var0, int[] var1);

    private static native <H extends Number> H _makeShot(H var0, IScreenshotCallback<H> var1);

    private static native <H extends Number> void _g_object_unref(H var0);

    private static native <H extends Number> boolean _toggle_above(H var0, boolean var1);

    private static native <H extends Number> boolean _begin_shot(H var0);

    private static native <H extends Number> boolean _end_shot(H var0);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Impl32
    extends OSSupportFreeBSD<Integer> {
        private Impl32() {
        }

        @Override
        protected Integer getHandleValue(Object widget, String fieldName) {
            int value = ReflectionUtils.getFieldInt((Object)widget, (String)fieldName);
            if (value != 0) {
                return value;
            }
            return null;
        }

        @Override
        protected Image createImage0(Integer pixmap) throws Exception {
            return (Image)ReflectionUtils.invokeMethod2(Image.class, (String)"gtk_new", Device.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, null, (Object)0, (Object)pixmap, (Object)0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Impl64
    extends OSSupportFreeBSD<Long> {
        private Impl64() {
        }

        @Override
        protected Long getHandleValue(Object widget, String fieldName) {
            long value = ReflectionUtils.getFieldLong((Object)widget, (String)fieldName);
            if (value != 0L) {
                return value;
            }
            return null;
        }

        @Override
        protected Image createImage0(Long pixmap) throws Exception {
            return (Image)ReflectionUtils.invokeMethod2(Image.class, (String)"gtk_new", Device.class, Integer.TYPE, Long.TYPE, Long.TYPE, null, (Object)0, (Object)pixmap, (Object)0);
        }
    }
}

