/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.sybase.actions;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sourceforge.sqlexplorer.IConstants;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class ViewEdit
extends Action {
    SessionTreeNode sessionNode;
    IDbModel node;

    public ViewEdit(SessionTreeNode sessionTreeNode, IDbModel node) {
        this.sessionNode = sessionTreeNode;
        this.node = node;
    }

    public String getText() {
        return "Edit an existing View...";
    }

    public void run() {
        try {
            TableNode tn = (TableNode)this.node;
            String dbName = ((IDbModel)tn.getParent()).getParent().toString();
            String sql = "SELECT sc.text, sc.id, sc.colid FROM " + dbName + "..sysobjects so, " + dbName + "..syscomments sc WHERE so.type='V' AND so.name=? AND sc.id=so.id order by 2,3";
            SQLConnection conn = this.sessionNode.getConnection();
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setString(1, tn.toString());
            StringBuffer result1 = new StringBuffer(1000);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                result1.append(rs.getString(1));
            }
            String finalResult = result1.toString();
            rs.close();
            stmt.close();
            SQLEditorInput input = new SQLEditorInput("EDIT VIEW (" + tn.toString() + ").sql");
            input.setSessionNode(this.sessionNode);
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, IConstants.SQL_EDITOR_CLASS);
            editorPart.setText(finalResult);
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error((String)"Error creating sql editor", (Throwable)e);
        }
    }
}

