/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.sybase;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.sqlexplorer.URLUtil;
import net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.ext.DefaultSessionPlugin;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.ext.sybase.ProcNode;
import net.sourceforge.sqlexplorer.ext.sybase.ProcTypeNode;
import net.sourceforge.sqlexplorer.ext.sybase.TriggerNode;
import net.sourceforge.sqlexplorer.ext.sybase.TriggerTypeNode;
import net.sourceforge.sqlexplorer.ext.sybase.actions.CreateProcedureEdit;
import net.sourceforge.sqlexplorer.ext.sybase.actions.CreateTriggerEdit;
import net.sourceforge.sqlexplorer.ext.sybase.actions.CreateViewEdit;
import net.sourceforge.sqlexplorer.ext.sybase.actions.ProcedureEdit;
import net.sourceforge.sqlexplorer.ext.sybase.actions.TriggerEdit;
import net.sourceforge.sqlexplorer.ext.sybase.actions.ViewEdit;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;

public class SybasePlugin
extends DefaultSessionPlugin {
    private static final ILogger s_log;
    HashMap classMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.ext.sybase.SybasePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_log = LoggerController.createLogger((Class)clazz);
    }

    public SybasePlugin() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.sybase.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classMap.put(clazz, "plugins/icons/test.gif");
    }

    public void load() {
    }

    public String getInternalName() {
        return "sybase Plugin";
    }

    public String getDescriptiveName() {
        return "Sybase Plugin for JFaceDbc";
    }

    public String getAuthor() {
        return "cpotter@sybase.com";
    }

    public String getWebSite() {
        return "http://jfacedbc.sourceforge.net";
    }

    public String getVersion() {
        return "0.1";
    }

    private boolean isSybase(SessionTreeNode session) {
        String SYBASE = "adaptive server";
        String SYBASE2 = "sybase sql server";
        String dbms = null;
        try {
            dbms = session.getSQLConnection().getSQLMetaData().getDatabaseProductName();
        }
        catch (SQLException ex) {
            s_log.debug((Object)"Error in getDatabaseProductName()", (Throwable)ex);
        }
        return dbms != null && (dbms.toLowerCase().startsWith("adaptive server") || dbms.toLowerCase().startsWith("sybase sql server"));
    }

    public IDbModel[] getCatalogAddedTypes(CatalogNode catalogNode, SessionTreeNode sessionNode) {
        if (this.isSybase(sessionNode)) {
            ArrayList<Object> ls = new ArrayList<Object>();
            SQLConnection conn = sessionNode.getConnection();
            ls.add(new ProcTypeNode((IDbModel)catalogNode, "PROCEDURE", conn));
            ls.add(new TriggerTypeNode((IDbModel)catalogNode, "TRIGGER", conn));
            return ls.toArray(new IDbModel[0]);
        }
        return null;
    }

    private ImageDescriptor getIcon(Class clazz) {
        URL url = null;
        String string = (String)this.classMap.get(clazz);
        URL baseURL = URLUtil.getBaseURL();
        try {
            url = new URL(baseURL, string);
            url = PluginManager.asLocalURL((URL)url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageDescriptor des = ImageDescriptor.createFromURL(url);
        return des;
    }

    public Map getIconMap() {
        Class<?> clazz;
        HashMap map = new HashMap();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.sybase.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("net.sourceforge.sqlexplorer.ext.sybase.ProcNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz2, this.getIcon(clazz));
        return map;
    }

    public IAction[] getTypeActionsAdded(SessionTreeNode sessionTreeNode, IDbModel node, TreeViewer tv) {
        ArrayList<Action> ls = new ArrayList<Action>();
        if (node instanceof ProcNode) {
            ls.add(new ProcedureEdit(sessionTreeNode, node));
        } else if (node instanceof ProcTypeNode) {
            ls.add(new CreateProcedureEdit(sessionTreeNode, node));
        } else if (node instanceof TriggerNode) {
            ls.add(new TriggerEdit(sessionTreeNode, node));
        } else if (node instanceof TriggerTypeNode) {
            ls.add(new CreateTriggerEdit(sessionTreeNode, node));
        }
        return ls.toArray(new IAction[0]);
    }

    public IAction[] getAddedActions(SessionTreeNode sessionNode, IDbModel node, TreeViewer tv) {
        ArrayList<Action> ls = new ArrayList<Action>();
        if (this.isSybase(sessionNode)) {
            TableObjectTypeNode tNode;
            if (node instanceof TableNode) {
                TableNode tNode2 = (TableNode)node;
                if (tNode2.getParent().toString().equalsIgnoreCase("VIEW")) {
                    ls.add(new ViewEdit(sessionNode, node));
                }
            } else if (node instanceof TableObjectTypeNode && (tNode = (TableObjectTypeNode)node).toString().equalsIgnoreCase("VIEW")) {
                ls.add(new CreateViewEdit(sessionNode, tNode));
            }
        }
        return ls.toArray(new IAction[0]);
    }
}

