/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.util.List;
import net.sf.hibernate.util.DTDEntityResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class XMLHelper {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$util$XMLHelper == null ? (class$net$sf$hibernate$util$XMLHelper = XMLHelper.class$("net.sf.hibernate.util.XMLHelper")) : class$net$sf$hibernate$util$XMLHelper));
    private static final EntityResolver DTD_RESOLVER = new DTDEntityResolver();
    static /* synthetic */ Class class$net$sf$hibernate$util$XMLHelper;

    public static SAXReader createSAXReader(String file, List errorsList) {
        SAXReader reader = new SAXReader();
        reader.setEntityResolver(DTD_RESOLVER);
        reader.setErrorHandler((ErrorHandler)new ErrorLogger(file, errorsList));
        reader.setMergeAdjacentText(true);
        reader.setValidation(true);
        return reader;
    }

    public static DOMReader createDOMReader() {
        DOMReader reader = new DOMReader();
        return reader;
    }

    private XMLHelper() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private String file;
        private List errors;

        ErrorLogger(String file, List errors) {
            this.file = file;
            this.errors = errors;
        }

        public void error(SAXParseException error) {
            log.error((Object)("Error parsing XML: " + this.file + '(' + error.getLineNumber() + ") " + error.getMessage()));
            this.errors.add(error);
        }

        public void fatalError(SAXParseException error) {
            this.error(error);
        }

        public void warning(SAXParseException warn) {
            log.warn((Object)("Warning parsing XML: " + this.file + '(' + warn.getLineNumber() + ") " + warn.getMessage()));
        }
    }
}

