/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.cfg.NamingStrategy;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.tool.hbm2ddl.DatabaseMetadata;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemaUpdate {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$tool$hbm2ddl$SchemaUpdate == null ? (class$net$sf$hibernate$tool$hbm2ddl$SchemaUpdate = SchemaUpdate.class$("net.sf.hibernate.tool.hbm2ddl.SchemaUpdate")) : class$net$sf$hibernate$tool$hbm2ddl$SchemaUpdate));
    private ConnectionProvider connectionProvider;
    private Configuration configuration;
    private Dialect dialect;
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2ddl$SchemaUpdate;

    public SchemaUpdate(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaUpdate(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionProvider = ConnectionProviderFactory.newConnectionProvider(props);
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean doUpdate = true;
            String propFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (args[i].startsWith("--text")) {
                        doUpdate = false;
                        continue;
                    }
                    if (!args[i].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    continue;
                }
                cfg.addFile(args[i]);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.load(new FileInputStream(propFile));
                new SchemaUpdate(cfg, props).execute(script, doUpdate);
            } else {
                new SchemaUpdate(cfg).execute(script, doUpdate);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error running schema update", (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(boolean script, boolean doUpdate) {
        block27: {
            DatabaseMetadata meta;
            log.info((Object)"Running hbm2ddl schema update");
            Connection connection = null;
            Statement stmt = null;
            boolean autoCommitWasEnabled = true;
            try {
                log.info((Object)"fetching database metadata");
                connection = this.connectionProvider.getConnection();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                    connection.setAutoCommit(true);
                    autoCommitWasEnabled = false;
                }
                meta = new DatabaseMetadata(connection, this.dialect);
                stmt = connection.createStatement();
            }
            catch (SQLException sqle) {
                log.error((Object)"could not get database metadata", (Throwable)sqle);
                throw sqle;
            }
            log.info((Object)"updating schema");
            String[] createSQL = this.configuration.generateSchemaUpdateScript(this.dialect, meta);
            for (int j = 0; j < createSQL.length; ++j) {
                String sql = createSQL[j];
                try {
                    if (script) {
                        System.out.println(sql);
                    }
                    if (!doUpdate) continue;
                    log.debug((Object)sql);
                    stmt.executeUpdate(sql);
                    continue;
                }
                catch (SQLException e) {
                    log.error((Object)("Unsuccessful: " + sql));
                    log.error((Object)e.getMessage());
                }
            }
            log.info((Object)"schema update complete");
            Object var12_13 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (!autoCommitWasEnabled) {
                    connection.setAutoCommit(false);
                }
                if (connection != null) {
                    connection.close();
                }
                if (this.connectionProvider != null) {
                    this.connectionProvider.close();
                }
                break block27;
            }
            catch (Exception e2) {
                log.error((Object)"Error closing connection", (Throwable)e2);
            }
            break block27;
            {
                catch (Exception e) {
                    log.error((Object)"could not complete schema update", (Throwable)e);
                    Object var12_14 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (!autoCommitWasEnabled) {
                            connection.setAutoCommit(false);
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        if (this.connectionProvider != null) {
                            this.connectionProvider.close();
                        }
                        break block27;
                    }
                    catch (Exception e2) {
                        log.error((Object)"Error closing connection", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (!autoCommitWasEnabled) {
                        connection.setAutoCommit(false);
                    }
                    if (connection != null) {
                        connection.close();
                    }
                    if (this.connectionProvider != null) {
                        this.connectionProvider.close();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)"Error closing connection", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

