/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.persister;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.collection.BasicCollectionPersister;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.OneToManyPersister;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.EntityPersister;
import net.sf.hibernate.persister.NormalizedEntityPersister;

public final class PersisterFactory {
    private static final Class[] PERSISTER_CONSTRUCTOR_ARGS = new Class[]{class$net$sf$hibernate$mapping$PersistentClass == null ? (class$net$sf$hibernate$mapping$PersistentClass = PersisterFactory.class$("net.sf.hibernate.mapping.PersistentClass")) : class$net$sf$hibernate$mapping$PersistentClass, class$net$sf$hibernate$engine$SessionFactoryImplementor == null ? (class$net$sf$hibernate$engine$SessionFactoryImplementor = PersisterFactory.class$("net.sf.hibernate.engine.SessionFactoryImplementor")) : class$net$sf$hibernate$engine$SessionFactoryImplementor};
    private static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{class$net$sf$hibernate$mapping$Collection == null ? (class$net$sf$hibernate$mapping$Collection = PersisterFactory.class$("net.sf.hibernate.mapping.Collection")) : class$net$sf$hibernate$mapping$Collection, class$net$sf$hibernate$cfg$Configuration == null ? (class$net$sf$hibernate$cfg$Configuration = PersisterFactory.class$("net.sf.hibernate.cfg.Configuration")) : class$net$sf$hibernate$cfg$Configuration, class$net$sf$hibernate$engine$SessionFactoryImplementor == null ? (class$net$sf$hibernate$engine$SessionFactoryImplementor = PersisterFactory.class$("net.sf.hibernate.engine.SessionFactoryImplementor")) : class$net$sf$hibernate$engine$SessionFactoryImplementor};
    static /* synthetic */ Class class$net$sf$hibernate$mapping$PersistentClass;
    static /* synthetic */ Class class$net$sf$hibernate$engine$SessionFactoryImplementor;
    static /* synthetic */ Class class$net$sf$hibernate$mapping$Collection;
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Configuration;
    static /* synthetic */ Class class$net$sf$hibernate$persister$EntityPersister;
    static /* synthetic */ Class class$net$sf$hibernate$persister$NormalizedEntityPersister;

    private PersisterFactory() {
    }

    public static ClassPersister createClassPersister(PersistentClass model, SessionFactoryImplementor factory) throws HibernateException {
        Class persisterClass = model.getClassPersisterClass();
        if (persisterClass == null || persisterClass == (class$net$sf$hibernate$persister$EntityPersister == null ? (class$net$sf$hibernate$persister$EntityPersister = PersisterFactory.class$("net.sf.hibernate.persister.EntityPersister")) : class$net$sf$hibernate$persister$EntityPersister)) {
            return new EntityPersister(model, factory);
        }
        if (persisterClass == (class$net$sf$hibernate$persister$NormalizedEntityPersister == null ? (class$net$sf$hibernate$persister$NormalizedEntityPersister = PersisterFactory.class$("net.sf.hibernate.persister.NormalizedEntityPersister")) : class$net$sf$hibernate$persister$NormalizedEntityPersister)) {
            return new NormalizedEntityPersister(model, factory);
        }
        return PersisterFactory.create(persisterClass, model, factory);
    }

    public static CollectionPersister createCollectionPersister(Configuration cfg, Collection model, SessionFactoryImplementor factory) throws HibernateException {
        Class persisterClass = model.getCollectionPersisterClass();
        if (persisterClass == null) {
            return model.isOneToMany() ? new OneToManyPersister(model, cfg, factory) : new BasicCollectionPersister(model, cfg, factory);
        }
        return PersisterFactory.create(persisterClass, cfg, model, factory);
    }

    private static ClassPersister create(Class persisterClass, PersistentClass model, SessionFactoryImplementor factory) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
        try {
            return (ClassPersister)pc.newInstance(model, factory);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof HibernateException) {
                throw (HibernateException)e;
            }
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
    }

    private static CollectionPersister create(Class persisterClass, Configuration cfg, Collection model, SessionFactoryImplementor factory) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
        try {
            return (CollectionPersister)pc.newInstance(model, cfg, factory);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof HibernateException) {
                throw (HibernateException)e;
            }
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

