/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.type.Type;

public class Column {
    private static final int DEFAULT_PROPERTY_LENGTH = 255;
    private int length = 255;
    private Type type;
    private int typeIndex = 0;
    private String name;
    private boolean nullable = true;
    private boolean unique = false;
    private String sqlType;
    private boolean quoted = false;
    int uniqueInteger;
    private String checkConstraint;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        char firstChar = name.charAt(0);
        if (firstChar == '`' | "`\"[".indexOf(firstChar) > -1) {
            this.quoted = true;
            this.name = name.substring(1, name.length() - 1);
        } else {
            this.name = name;
        }
    }

    public String getQuotedName(Dialect d) {
        return this.quoted ? d.openQuote() + this.name + d.closeQuote() : this.name;
    }

    public String getAlias() {
        char first = this.name.charAt(0);
        if (this.quoted || first == '\'' || Character.isDigit(first)) {
            return "y" + Integer.toString(this.uniqueInteger) + '_';
        }
        if (this.name.length() < 11) {
            return this.name;
        }
        return new Alias(10, Integer.toString(this.uniqueInteger) + '_').toAliasString(this.name);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public void setTypeIndex(int typeIndex) {
        this.typeIndex = typeIndex;
    }

    private int getAutoSqlType(Mapping mapping) throws MappingException {
        try {
            return this.getType().sqlTypes(mapping)[this.getTypeIndex()];
        }
        catch (Exception e) {
            throw new MappingException("Could not determine type for column " + this.name + " of type " + this.type.getClass().getName() + ": " + e.getClass().getName(), e);
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getSqlType(Dialect dialect, Mapping mapping) throws HibernateException {
        return this.sqlType == null ? dialect.getTypeName(this.getAutoSqlType(mapping), this.getLength()) : this.sqlType;
    }

    public boolean equals(Object object) {
        return object instanceof Column && this.equals((Column)object);
    }

    public boolean equals(Column column) {
        if (null == column) {
            return false;
        }
        if (this == column) {
            return true;
        }
        return this.name.equals(column.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.name + ":" + this.sqlType;
    }

    public String getCheckConstraint() {
        return this.checkConstraint;
    }

    public void setCheckConstraint(String checkConstraint) {
        this.checkConstraint = checkConstraint;
    }

    public boolean hasCheckConstraint() {
        return this.checkConstraint != null;
    }
}

