/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.exception;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.exception.ConstraintViolationException;
import net.sf.hibernate.exception.GenericJDBCException;
import net.sf.hibernate.exception.JDBCConnectionException;
import net.sf.hibernate.exception.JDBCExceptionHelper;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.exception.SQLGrammarException;
import net.sf.hibernate.exception.ViolatedConstraintNameExtracter;

public class SQLStateConverter
implements SQLExceptionConverter {
    private ViolatedConstraintNameExtracter extracter;
    private static final Set SQL_GRAMMAR_CATEGORIES = new HashSet();
    private static final Set INTEGRITY_VIOLATION_CATEGORIES = new HashSet();
    private static final Set CONNECTION_CATEGORIES = new HashSet();

    public SQLStateConverter(ViolatedConstraintNameExtracter extracter) {
        this.extracter = extracter;
    }

    public JDBCException convert(SQLException sqlException, String message) {
        String sqlStateClassCode = JDBCExceptionHelper.extractSqlStateClassCode(sqlException);
        if (sqlStateClassCode != null) {
            if (SQL_GRAMMAR_CATEGORIES.contains(sqlStateClassCode)) {
                return new SQLGrammarException(message, sqlException);
            }
            if (INTEGRITY_VIOLATION_CATEGORIES.contains(sqlStateClassCode)) {
                String constraintName = this.extracter.extractConstraintName(sqlException);
                return new ConstraintViolationException(message, sqlException, constraintName);
            }
            if (CONNECTION_CATEGORIES.contains(sqlStateClassCode)) {
                return new JDBCConnectionException(message, sqlException);
            }
        }
        return this.handledNonSpecificException(sqlException, message);
    }

    protected JDBCException handledNonSpecificException(SQLException sqlException, String message) {
        return new GenericJDBCException(message, sqlException);
    }

    static {
        SQL_GRAMMAR_CATEGORIES.add("07");
        SQL_GRAMMAR_CATEGORIES.add("37");
        SQL_GRAMMAR_CATEGORIES.add("42");
        SQL_GRAMMAR_CATEGORIES.add("65");
        SQL_GRAMMAR_CATEGORIES.add("S0");
        INTEGRITY_VIOLATION_CATEGORIES.add("23");
        INTEGRITY_VIOLATION_CATEGORIES.add("27");
        INTEGRITY_VIOLATION_CATEGORIES.add("44");
        CONNECTION_CATEGORIES.add("08");
    }
}

