/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.exception;

import java.sql.SQLException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.util.JDBCExceptionReporter;

public final class JDBCExceptionHelper {
    private JDBCExceptionHelper() {
    }

    public static JDBCException convert(SQLExceptionConverter converter, SQLException sqlException, String message) {
        JDBCExceptionReporter.logExceptions(sqlException, message);
        return converter.convert(sqlException, message);
    }

    public static int extractErrorCode(SQLException sqlException) {
        int errorCode = sqlException.getErrorCode();
        for (SQLException nested = sqlException.getNextException(); errorCode == 0 && nested != null; nested = nested.getNextException()) {
            errorCode = sqlException.getErrorCode();
        }
        return errorCode;
    }

    public static String extractSqlState(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        for (SQLException nested = sqlException.getNextException(); sqlState == null && nested != null; nested = nested.getNextException()) {
            sqlState = nested.getSQLState();
        }
        return sqlState;
    }

    public static String extractSqlStateClassCode(SQLException sqlException) {
        String sqlState = JDBCExceptionHelper.extractSqlState(sqlException);
        if (sqlState == null || sqlState.length() < 2) {
            return sqlState;
        }
        return sqlState.substring(0, 2);
    }
}

