/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqlpanel;

import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.views.SqlResultsView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.sqlpanel.SQLTableSorter;
import net.sourceforge.sqlexplorer.sqlpanel.SqlTableModel;
import net.sourceforge.squirrel_sql.fw.sql.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SqlExecProgress
implements IRunnableWithProgress {
    private String _sql;
    SQLEditor txtComp;
    int maxRows;
    private SessionTreeNode sessionTreeNode;
    boolean sqlError;
    Throwable exception;

    public SqlExecProgress(String sqlString, SQLEditor txtComp, int maxRows, SessionTreeNode sessionTreeNode) {
        this._sql = sqlString;
        this.txtComp = txtComp;
        this.maxRows = maxRows;
        this.sessionTreeNode = sessionTreeNode;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final long startTime = System.currentTimeMillis();
        QueryTokenizer qt = new QueryTokenizer(this._sql, ";", "#");
        ArrayList<String> queryStrings = new ArrayList<String>();
        while (qt.hasQuery()) {
            String querySql = qt.nextQuery();
            if (querySql.startsWith("--")) continue;
            queryStrings.add(querySql);
        }
        final ArrayList<SqlTableModel> rsLis = new ArrayList<SqlTableModel>();
        SqlTableModel sqlTbModel = null;
        while (!queryStrings.isEmpty()) {
            String querySql = (String)queryStrings.remove(0);
            if (querySql == null) continue;
            sqlTbModel = this.processQuery(querySql, monitor);
            if (sqlTbModel != null) {
                rsLis.add(sqlTbModel);
            }
            SQLExplorerPlugin.getDefault().addSQLtoHistory(querySql);
        }
        this.txtComp.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    SqlResultsView resultsView = (SqlResultsView)SqlExecProgress.this.txtComp.getSite().getPage().showView("net.sourceforge.sqlexplorer.plugin.views.SqlResultsView");
                    resultsView.setData(rsLis.toArray(new SqlTableModel[rsLis.size()]));
                    long endTime = System.currentTimeMillis();
                    String message = String.valueOf(Messages.getString("Time__1")) + " " + (int)(endTime - startTime) + Messages.getString("_ms");
                    SqlExecProgress.this.txtComp.setMessage(message);
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error displaying data", e);
                    SqlExecProgress.this.txtComp.setMessage(e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SqlTableModel processQuery(String sql, IProgressMonitor monitor) {
        final long startTime = System.currentTimeMillis();
        LocalThread lt = null;
        try {
            try {
                final Statement stmt = this.sessionTreeNode.getConnection().createStatement();
                lt = new LocalThread(monitor, stmt);
                lt.start();
                boolean b = stmt.execute(sql);
                if (b) {
                    ResultSet rs = stmt.getResultSet();
                    if (rs != null) {
                        ResultSetMetaData metaData = rs.getMetaData();
                        int count = metaData.getColumnCount();
                        String[] ss = new String[count];
                        int i = 0;
                        while (true) {
                            if (i >= count) {
                                SQLTableSorter sorter = new SQLTableSorter(count, metaData);
                                ResultSetReader reader = new ResultSetReader(rs);
                                SqlTableModel md = new SqlTableModel(reader, metaData, this.maxRows, this.sessionTreeNode.getConnection(), ss, sorter);
                                lt.endMonitor();
                                SqlTableModel sqlTableModel = md;
                                Object var15_18 = null;
                                lt.endMonitor();
                                return sqlTableModel;
                            }
                            ss[i] = metaData.getColumnName(i + 1);
                            ++i;
                        }
                    }
                } else {
                    lt.endMonitor();
                    this.txtComp.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                long endTime = System.currentTimeMillis();
                                String message = String.valueOf(Messages.getString("Time__1")) + " " + (int)(endTime - startTime) + Messages.getString("_ms");
                                SqlExecProgress.this.txtComp.setMessage(String.valueOf(message) + Messages.getString("SqlExecProgress._updated_rowcount__5") + stmt.getUpdateCount());
                            }
                            catch (Throwable e) {
                                SQLExplorerPlugin.error("Error displaying data ", e);
                                SqlExecProgress.this.txtComp.setMessage(e.getMessage());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                if (!monitor.isCanceled()) {
                    SQLExplorerPlugin.error("Error processing query ", e);
                    this.exception = e;
                    this.sqlError = true;
                }
                SqlTableModel sqlTableModel = null;
                Object var15_19 = null;
                lt.endMonitor();
                return sqlTableModel;
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            lt.endMonitor();
            throw throwable;
        }
        {
            Object var15_21 = null;
            lt.endMonitor();
            return null;
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isSqlError() {
        return this.sqlError;
    }

    private class LocalThread
    extends Thread {
        IProgressMonitor monitor;
        Statement stmt;
        boolean end = false;

        public void run() {
            try {
                while (!this.end) {
                    if (this.monitor.isCanceled()) {
                        try {
                            this.stmt.cancel();
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Throwable throwable) {}
        }

        public LocalThread(IProgressMonitor monitor, Statement stmt) {
            this.monitor = monitor;
            this.stmt = stmt;
        }

        public void endMonitor() {
            this.end = true;
        }
    }
}

