/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqleditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.Assert;

public class UnsignedWordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    public Map fWords = new HashMap();
    private StringBuffer fBuffer = new StringBuffer();
    private IToken fTableToken;
    private IToken fColumnToken;
    private Dictionary dictionary;

    public UnsignedWordRule(IWordDetector detector) {
        this(detector, Token.UNDEFINED, null, null, null);
    }

    public UnsignedWordRule(IWordDetector detector, IToken defaultToken, IToken tableToken, IToken columnToken, Dictionary dictionary) {
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)defaultToken);
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
        this.fTableToken = tableToken;
        this.fColumnToken = columnToken;
        this.dictionary = dictionary;
    }

    public void addWord(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        if (word != null) {
            word = word.toLowerCase();
        }
        this.fWords.put(word, token);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String tokenName = this.fBuffer.substring(0, this.fBuffer.length()).toLowerCase();
            IToken token = (IToken)this.fWords.get(tokenName);
            if (token != null) {
                ArrayList list;
                if (token == this.fTableToken && this.dictionary != null && (list = (ArrayList)this.dictionary.getByTableName(tokenName)) != null) {
                    int j = 0;
                    while (j < list.size()) {
                        TableNode nd = (TableNode)list.get(j);
                        ArrayList ls = null;
                        try {
                            ls = nd.getColumnNames();
                        }
                        catch (Throwable e) {
                            SQLExplorerPlugin.error("Error getting columns names", e);
                        }
                        if (ls != null) {
                            TreeSet<String> colTree = (TreeSet<String>)this.dictionary.getColumnListByTableName(tokenName);
                            if (colTree == null && j == 0) {
                                colTree = new TreeSet<String>();
                                this.dictionary.putColumnsByTableName(tokenName, colTree);
                                int i = 0;
                                while (i < ls.size()) {
                                    String lo = (String)ls.get(i);
                                    this.addWord(lo, this.fColumnToken);
                                    colTree.add(lo);
                                    ++i;
                                }
                            } else if (colTree != null) {
                                // empty if block
                            }
                        }
                        ++j;
                    }
                }
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }

    public int getMapSize() {
        return this.fWords.size();
    }
}

