/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqleditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.sqlexplorer.sqleditor.ExtendedCompletionProposal;
import net.sourceforge.sqlexplorer.sqleditor.ICompletionProposalComparator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class SQLCompletionProcessor
implements IContentAssistProcessor {
    private Image colImage;
    private Image tableImage;
    private Image viewImage;
    private Image keywordImage;
    private Image catalogImage;
    static String sep = System.getProperty("line.separator");
    private Dictionary dictionary;
    private char[] fProposalAutoActivationSet;

    public void dispose() {
        if (this.catalogImage != null) {
            try {
                this.catalogImage.dispose();
                this.catalogImage = null;
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error disposing images", e);
            }
        }
        if (this.keywordImage != null) {
            try {
                this.keywordImage.dispose();
                this.keywordImage = null;
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error disposing images", e);
            }
        }
        if (this.colImage != null) {
            try {
                this.colImage.dispose();
                this.colImage = null;
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error disposing images", e);
            }
        }
        if (this.tableImage != null) {
            try {
                this.tableImage.dispose();
                this.tableImage = null;
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error disposing images", e);
            }
        }
        if (this.viewImage != null) {
            try {
                this.viewImage.dispose();
                this.viewImage = null;
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error disposing images", e);
            }
        }
    }

    public SQLCompletionProcessor(Dictionary dictionary) {
        this.dictionary = dictionary;
        try {
            this.colImage = new Image(null, SqlexplorerImages.getColumnIcon().openStream());
            this.tableImage = new Image(null, SqlexplorerImages.getTableIcon().openStream());
            this.viewImage = new Image(null, SqlexplorerImages.getViewIcon().openStream());
            this.keywordImage = new Image(null, SqlexplorerImages.getKeywordIcon().openStream());
            this.catalogImage = new Image(null, SqlexplorerImages.getDatabaseNodeIcon().openStream());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error creating images", e);
        }
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        if (this.dictionary == null) {
            return null;
        }
        String text = viewer.getDocument().get();
        String string = text.substring(0, documentOffset);
        if (string.equals("")) {
            return null;
        }
        int position = string.length() - 1;
        while (position > 0) {
            char character = string.charAt(position);
            if (!Character.isJavaIdentifierPart(character) && character != '.') break;
            --position;
        }
        if (position == 0) {
            position = -1;
        }
        if ((string = string.substring(position + 1)) == null || string.equals("")) {
            return null;
        }
        int length = (string = string.toLowerCase()).length();
        if (length < 1) {
            return null;
        }
        int dotIndex = string.lastIndexOf(".");
        if (string.charAt(length - 1) == ' ') {
            return null;
        }
        if (string.charAt(length - 1) == '.') {
            String name = string.substring(0, length - 1);
            if (name == null) {
                return null;
            }
            int otherDot = name.lastIndexOf(".");
            if (otherDot != -1) {
                name = name.substring(otherDot + 1);
            }
            if (name == null || name.equals("")) {
                return null;
            }
            TreeSet st = (TreeSet)this.dictionary.getColumnListByTableName(name);
            if (st != null) {
                ArrayList list = (ArrayList)this.dictionary.getByTableName(name);
                if (list == null) {
                    return null;
                }
                TableNode nd = null;
                if (list.size() != 1) {
                    return null;
                }
                nd = (TableNode)list.get(0);
                Object[] obj = st.toArray();
                String[] arr = new String[obj.length];
                System.arraycopy(obj, 0, arr, 0, obj.length);
                ICompletionProposal[] result = new ICompletionProposal[arr.length];
                String tableDesc = null;
                if (nd != null) {
                    tableDesc = nd.getTableDesc();
                }
                int i = 0;
                while (i < arr.length) {
                    result[i] = new CompletionProposal(arr[i], documentOffset, 0, arr[i].length(), this.colImage, arr[i], null, tableDesc);
                    ++i;
                }
                return result;
            }
            IDbModel node = (IDbModel)this.dictionary.getByCatalogSchemaName(name);
            if (node != null) {
                Object[] children = node.getChildren();
                ArrayList<ExtendedCompletionProposal> propList = new ArrayList<ExtendedCompletionProposal>();
                int i = 0;
                while (i < children.length) {
                    String childName = children[i].toString().toLowerCase();
                    if (childName.equals("table") || childName.equals("view")) {
                        Object[] tables = ((IDbModel)children[i]).getChildren();
                        int j = 0;
                        while (j < tables.length) {
                            Image tmpImage = null;
                            String tableName = tables[j].toString();
                            if (tables[j] instanceof TableNode) {
                                if (((TableNode)tables[j]).isTable()) {
                                    tmpImage = this.tableImage;
                                } else if (((TableNode)tables[j]).isView()) {
                                    tmpImage = this.viewImage;
                                }
                                propList.add(new ExtendedCompletionProposal(tableName, documentOffset, 0, tableName.length(), tmpImage, tableName, (TableNode)tables[j]));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                ICompletionProposal[] res = new ICompletionProposal[propList.size()];
                System.arraycopy(propList.toArray(), 0, res, 0, propList.size());
                Arrays.sort(res, new ICompletionProposalComparator());
                return res;
            }
        } else {
            if (dotIndex == -1) {
                String[] keywordProposal = Dictionary.matchKeywordsPrefix(string);
                ICompletionProposal[] resKey = new ICompletionProposal[keywordProposal.length];
                int i = 0;
                while (i < keywordProposal.length) {
                    resKey[i] = new CompletionProposal(keywordProposal[i], documentOffset - length, length, keywordProposal[i].length(), this.keywordImage, keywordProposal[i], null, null);
                    ++i;
                }
                String[] proposalsString = this.dictionary.matchTablePrefix(string.toLowerCase());
                ArrayList<ExtendedCompletionProposal> propList = new ArrayList<ExtendedCompletionProposal>();
                int i2 = 0;
                while (i2 < proposalsString.length) {
                    ArrayList ls = this.dictionary.getTableObjectList(proposalsString[i2]);
                    int j = 0;
                    while (j < ls.size()) {
                        TableNode tbNode = (TableNode)ls.get(j);
                        Image tmpImage = null;
                        if (tbNode.isView()) {
                            tmpImage = this.viewImage;
                        } else if (tbNode.isTable()) {
                            tmpImage = this.tableImage;
                        }
                        ExtendedCompletionProposal cmp = new ExtendedCompletionProposal(proposalsString[i2], documentOffset - length, length, proposalsString[i2].length(), tmpImage, proposalsString[i2], tbNode);
                        propList.add(cmp);
                        ++j;
                    }
                    ++i2;
                }
                String[] proposalsString2 = this.dictionary.matchCatalogSchemaPrefix(string.toLowerCase());
                ICompletionProposal[] resKey2 = new ICompletionProposal[proposalsString2.length];
                int i3 = 0;
                while (i3 < proposalsString2.length) {
                    resKey2[i3] = new CompletionProposal(proposalsString2[i3], documentOffset - length, length, proposalsString2[i3].length(), this.catalogImage, proposalsString2[i3], null, null);
                    ++i3;
                }
                ICompletionProposal[] res = new ICompletionProposal[propList.size() + keywordProposal.length + resKey2.length];
                System.arraycopy(resKey, 0, res, 0, resKey.length);
                System.arraycopy(propList.toArray(), 0, res, resKey.length, propList.size());
                System.arraycopy(resKey2, 0, res, resKey.length + propList.size(), resKey2.length);
                Arrays.sort(res, new ICompletionProposalComparator());
                return res;
            }
            if (dotIndex != -1) {
                String lastPart;
                String firstPart = string.substring(0, dotIndex);
                int otherDot = firstPart.indexOf(".");
                if (otherDot != -1) {
                    firstPart = firstPart.substring(otherDot + 1);
                }
                if ((lastPart = string.substring(dotIndex + 1)) == null || firstPart == null || lastPart.equals("") || firstPart.equals("")) {
                    return null;
                }
                TreeSet st = (TreeSet)this.dictionary.getColumnListByTableName(firstPart);
                if (st != null) {
                    Iterator iter = st.iterator();
                    ArrayList<CompletionProposal> propList = new ArrayList<CompletionProposal>();
                    while (iter.hasNext()) {
                        String colName = (String)iter.next();
                        int length2 = lastPart.length();
                        if (colName.length() < length2 || !colName.substring(0, lastPart.length()).equalsIgnoreCase(lastPart)) continue;
                        CompletionProposal cmp = new CompletionProposal(colName, documentOffset - length2, length2, colName.length(), this.colImage, colName, null, null);
                        propList.add(cmp);
                    }
                    ICompletionProposal[] res = new ICompletionProposal[propList.size()];
                    System.arraycopy(propList.toArray(), 0, res, 0, propList.size());
                    return res;
                }
                IDbModel node = (IDbModel)this.dictionary.getByCatalogSchemaName(firstPart);
                if (node != null) {
                    String[] proposalsString = this.dictionary.matchTablePrefix(lastPart.toLowerCase());
                    ArrayList<ExtendedCompletionProposal> propList = new ArrayList<ExtendedCompletionProposal>();
                    int i = 0;
                    while (i < proposalsString.length) {
                        ArrayList ls = this.dictionary.getTableObjectList(proposalsString[i]);
                        int j = 0;
                        while (j < ls.size()) {
                            TableNode tbNode = (TableNode)ls.get(j);
                            Image tmpImage = null;
                            TableObjectTypeNode totn = (TableObjectTypeNode)tbNode.getParent();
                            IDbModel catSchema = (IDbModel)totn.getParent();
                            if (catSchema == node) {
                                if (tbNode.isView()) {
                                    tmpImage = this.viewImage;
                                } else if (tbNode.isTable()) {
                                    tmpImage = this.tableImage;
                                }
                                ExtendedCompletionProposal cmp = new ExtendedCompletionProposal(proposalsString[i], documentOffset - lastPart.length(), lastPart.length(), proposalsString[i].length(), tmpImage, proposalsString[i], tbNode);
                                propList.add(cmp);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    ICompletionProposal[] res = new ICompletionProposal[propList.size()];
                    System.arraycopy(propList.toArray(), 0, res, 0, propList.size());
                    return res;
                }
            }
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer arg0, int arg1) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

