/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.ui;

import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.ConnectionInfo;
import net.sourceforge.sqlexplorer.plugin.views.DBView;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeContentProvider;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeLabelProvider;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModel;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModelChangedListener;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;

public class SessionViewer
extends TreeViewer {
    SessionTreeModel md;

    public SessionViewer(final Composite parent, int style, SessionTreeModel md, IViewPart viewPart) {
        super(parent, style);
        this.md = md;
        this.setContentProvider((IContentProvider)new SessionTreeContentProvider());
        final SessionTreeLabelProvider stlp = new SessionTreeLabelProvider();
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                stlp.dispose();
            }
        });
        this.setLabelProvider((IBaseLabelProvider)stlp);
        this.setUseHashlookup(true);
        this.setInput(md);
        md.addListener(new SessionTreeModelChangedListener(){

            public void modelChanged(SessionTreeNode node_) {
                parent.getDisplay().asyncExec(new Runnable(this, node_){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ SessionTreeNode val$node_;
                    {
                        this.this$1 = var1_1;
                        this.val$node_ = sessionTreeNode;
                    }

                    public void run() {
                        2.access$0(this.this$1).refresh();
                        2.access$0(this.this$1).expandAll();
                        if (this.val$node_ != null) {
                            2.access$0(this.this$1).setSelection((ISelection)new StructuredSelection((Object)this.val$node_));
                        }
                    }
                });
            }

            static /* synthetic */ SessionViewer access$0(2 var0) {
                return var0.SessionViewer.this;
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent ev) {
                IStructuredSelection sel = (IStructuredSelection)ev.getSelection();
                if (!sel.isEmpty()) {
                    if (sel.getFirstElement() instanceof SessionTreeNode) {
                        SessionTreeNode node = (SessionTreeNode)sel.getFirstElement();
                        try {
                            ConnectionInfo connInfo = (ConnectionInfo)SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("net.sourceforge.sqlexplorer.plugin.views.ConnectionInfo");
                            if (connInfo != null) {
                                connInfo.setInput(node);
                            }
                        }
                        catch (Throwable e) {
                            SQLExplorerPlugin.error("Error opening connection info view", e);
                        }
                        try {
                            DBView dbView = (DBView)SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("net.sourceforge.sqlexplorer.plugin.views.DBView");
                            if (dbView != null) {
                                dbView.setInput(node);
                            }
                        }
                        catch (Throwable e) {
                            SQLExplorerPlugin.error("Error opening db view", e);
                        }
                    } else if (sel.getFirstElement() instanceof RootSessionTreeNode) {
                        try {
                            DBView dbView = (DBView)SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("net.sourceforge.sqlexplorer.plugin.views.DBView");
                            dbView.setInput(null);
                        }
                        catch (Throwable throwable) {}
                        try {
                            ConnectionInfo connInfo = (ConnectionInfo)SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("net.sourceforge.sqlexplorer.plugin.views.ConnectionInfo");
                            if (connInfo != null) {
                                connInfo.setInput(null);
                            }
                        }
                        catch (Throwable e) {
                            SQLExplorerPlugin.error("Error opening connection info view", e);
                        }
                    }
                }
            }
        });
    }
}

