/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.sqlexplorer.dbviewer.DatabaseContentProvider;
import net.sourceforge.sqlexplorer.dbviewer.DatabaseLabelProvider;
import net.sourceforge.sqlexplorer.dbviewer.DetailManager;
import net.sourceforge.sqlexplorer.dbviewer.actions.DatabaseActionGroup;
import net.sourceforge.sqlexplorer.dbviewer.model.DatabaseModel;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.TableNodeTransfer;
import net.sourceforge.sqlexplorer.sessiontree.model.ISessionTreeClosedListener;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.part.ViewPart;

public class DBView
extends ViewPart {
    SessionTreeNode node_;
    TabFolder tabFolder;
    HashMap nodeTabItemsMap = new HashMap();

    private Couple createItem(SessionTreeNode sessionTreeNode) {
        TabItem ti = new TabItem(this.tabFolder, 0);
        ti.setText(sessionTreeNode.toString());
        SashForm sash = new SashForm((Composite)this.tabFolder, 512);
        ti.setControl((Control)sash);
        sash.setLayout((Layout)new FillLayout());
        final TreeViewer tv = new TreeViewer((Composite)sash, 68354);
        tv.setUseHashlookup(true);
        Transfer[] transfers = new Transfer[]{TableNodeTransfer.getInstance()};
        tv.addDragSupport(1, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                boolean bl = event.doit = !tv.getSelection().isEmpty();
                if (event.doit) {
                    Object sel = ((IStructuredSelection)tv.getSelection()).getFirstElement();
                    if (!(sel instanceof TableNode)) {
                        event.doit = false;
                    } else {
                        TableNode tn = (TableNode)sel;
                        TableNodeTransfer.getInstance().setSelection(tn);
                        if (!tn.isTable()) {
                            event.doit = false;
                        }
                    }
                }
            }

            public void dragSetData(DragSourceEvent event) {
                Object sel;
                event.data = sel = ((IStructuredSelection)tv.getSelection()).getFirstElement();
            }

            public void dragFinished(DragSourceEvent event) {
                TableNodeTransfer.getInstance().setSelection(null);
            }
        });
        Composite c = new Composite((Composite)sash, 2048);
        c.setLayout((Layout)new FillLayout());
        final DetailManager dm = new DetailManager(tv, c, SQLExplorerPlugin.getDefault().getPreferenceStore(), sessionTreeNode);
        tv.setContentProvider((IContentProvider)new DatabaseContentProvider());
        final DatabaseLabelProvider tlp = new DatabaseLabelProvider(SQLExplorerPlugin.getDefault().pluginManager);
        tv.setLabelProvider((IBaseLabelProvider)tlp);
        sash.setWeights(new int[]{3, 1});
        tv.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                tlp.dispose();
            }
        });
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent ev) {
                IStructuredSelection sel = (IStructuredSelection)ev.getSelection();
                if (!sel.isEmpty()) {
                    try {
                        dm.activate((IDbModel)sel.getFirstElement());
                    }
                    catch (Throwable e) {
                        SQLExplorerPlugin.error("Error managing selection changed ", e);
                    }
                }
            }
        });
        final DatabaseActionGroup actGroup = new DatabaseActionGroup(this, tv);
        MenuManager menuMgr = new MenuManager("#DbPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu fDbContextMenu = menuMgr.createContextMenu((Control)tv.getTree());
        tv.getTree().setMenu(fDbContextMenu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                actGroup.fillContextMenu(manager);
            }
        });
        return new Couple(ti, tv);
    }

    public void createPartControl(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DBView.this.node_ = DBView.this.getSessionTreeNode();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        parent.setLayout((Layout)new FillLayout());
    }

    public void setFocus() {
    }

    public void setInput(SessionTreeNode node) {
        if (node == this.node_) {
            return;
        }
        if (node != null) {
            Couple cp = (Couple)this.nodeTabItemsMap.get(node);
            if (cp == null) {
                cp = this.createItem(node);
                this.nodeTabItemsMap.put(node, cp);
                final TabItem ti = cp.ti;
                node.addListener(new ISessionTreeClosedListener(){

                    public void sessionTreeClosed() {
                        ti.dispose();
                    }
                });
                DatabaseModel dbModel = node.dbModel;
                cp.tv.setInput((Object)dbModel);
            }
            this.tabFolder.setSelection(new TabItem[]{cp.ti});
            this.node_ = node;
        }
    }

    public SessionTreeNode getSessionTreeNode() {
        TabItem[] items = this.tabFolder.getSelection();
        if (items.length == 0) {
            return null;
        }
        TabItem ti = items[0];
        Iterator it = this.nodeTabItemsMap.keySet().iterator();
        while (it.hasNext()) {
            SessionTreeNode nd = (SessionTreeNode)it.next();
            Couple cp = (Couple)this.nodeTabItemsMap.get(nd);
            if (ti != cp.ti) continue;
            return nd;
        }
        return null;
    }

    public void refresh() {
        if (this.node_ != null) {
            this.node_.dbModel = new DatabaseModel(this.node_, SQLExplorerPlugin.getDefault().pluginManager);
            Couple cp = (Couple)this.nodeTabItemsMap.get(this.node_);
            if (cp != null) {
                cp.tv.setInput((Object)this.node_.dbModel);
                cp.tv.refresh();
            } else {
                cp = this.createItem(this.node_);
                this.nodeTabItemsMap.put(this.node_, cp);
                final TabItem ti = cp.ti;
                this.node_.addListener(new ISessionTreeClosedListener(){

                    public void sessionTreeClosed() {
                        ti.dispose();
                    }
                });
                DatabaseModel dbModel = this.node_.dbModel;
                cp.tv.setInput((Object)dbModel);
                cp.tv.refresh();
            }
        }
    }

    public void tryToSelect(SessionTreeNode sessionNode, IDbModel activeTableNode) {
        if (activeTableNode instanceof TableNode) {
            Couple cp = (Couple)this.nodeTabItemsMap.get(sessionNode);
            cp.tv.reveal(((IDbModel)activeTableNode.getParent()).getParent());
            cp.tv.expandToLevel(activeTableNode.getParent(), 2);
            cp.tv.reveal((Object)activeTableNode);
            cp.tv.setSelection((ISelection)new StructuredSelection(new Object[]{activeTableNode}), true);
        }
    }

    class Couple {
        TabItem ti;
        TreeViewer tv;

        public Couple(TabItem ti, TreeViewer tv) {
            this.ti = ti;
            this.tv = tv;
        }
    }
}

