/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.ConnectionsView;
import net.sourceforge.sqlexplorer.sessiontree.actions.CloseAllConnections;
import net.sourceforge.sqlexplorer.sessiontree.actions.CloseConnection;
import net.sourceforge.sqlexplorer.sessiontree.actions.NewConnection;
import net.sourceforge.sqlexplorer.sessiontree.actions.NewSQLEditor;
import net.sourceforge.sqlexplorer.sessiontree.model.ISessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.actions.ActionGroup;

public class ConnectionsActionGroup
extends ActionGroup {
    ConnectionsView view;
    IAction closeAll;
    IAction closeConn;
    IAction openEditor;

    public ConnectionsActionGroup(ConnectionsView view) {
        this.view = view;
    }

    public void fillContextMenu(IMenuManager menuMgr) {
        ISessionTreeNode treeNode = this.getSelectedNode();
        Object[] aliases = SQLExplorerPlugin.getDefault().getAliasModel().getElements();
        if (aliases != null && aliases.length > 0) {
            MenuManager manager = new MenuManager("New Connection...");
            int i = 0;
            while (i < aliases.length) {
                ISQLAlias alias = (ISQLAlias)aliases[i];
                manager.add((IAction)new NewConnection(alias));
                ++i;
            }
            menuMgr.add((IContributionItem)manager);
        }
        if (treeNode == null) {
            return;
        }
        if (treeNode instanceof RootSessionTreeNode) {
            this.closeAll = new CloseAllConnections((RootSessionTreeNode)treeNode);
            this.openEditor = new NewSQLEditor(null);
            menuMgr.add(this.closeAll);
            menuMgr.add(this.openEditor);
        } else if (treeNode instanceof SessionTreeNode) {
            this.closeConn = new CloseConnection((SessionTreeNode)treeNode);
            this.openEditor = new NewSQLEditor((SessionTreeNode)treeNode);
            menuMgr.add(this.closeConn);
            menuMgr.add(this.openEditor);
        }
    }

    ISessionTreeNode getSelectedNode() {
        TreeViewer viewer = this.view.getTreeViewer();
        ISelection sel = viewer.getSelection();
        if (sel != null) {
            IStructuredSelection iSel = (IStructuredSelection)sel;
            ISessionTreeNode node = (ISessionTreeNode)iSel.getFirstElement();
            return node;
        }
        return null;
    }
}

