/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import java.sql.DatabaseMetaData;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.ISessionTreeClosedListener;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;

public class ConnectionInfo
extends ViewPart {
    Table table;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.table = new Table(parent, 68352);
        this.table.setHeaderVisible(true);
        TableColumn tc = new TableColumn(this.table, 0);
        tc.setText(Messages.getString("Property_2"));
        tc = new TableColumn(this.table, 0);
        tc.setText(Messages.getString("Value_3"));
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < 2) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
            ++i;
        }
        this.table.setLayout((Layout)tableLayout);
        this.table.layout();
    }

    public void setFocus() {
    }

    public void setInput(SessionTreeNode node) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        this.table.removeAll();
        if (node == null) {
            return;
        }
        SQLConnection conn = node.getSQLConnection();
        node.addListener(new ISessionTreeClosedListener(){

            public void sessionTreeClosed() {
                ConnectionInfo.this.table.removeAll();
            }
        });
        TableItem ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("Database_Product_Name_4"));
        SQLDatabaseMetaData metaData = null;
        DatabaseMetaData metaData_ = null;
        try {
            metaData = conn.getSQLMetaData();
            metaData_ = conn.getSQLMetaData().getJDBCMetaData();
        }
        catch (Throwable e) {
            MessageDialog.openInformation(null, (String)"No metadata", (String)"");
            SQLExplorerPlugin.error("Error getting database metadata ", e);
            return;
        }
        try {
            ti.setText(1, metaData.getDatabaseProductName());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting database product name ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("Database_Product_Version_5"));
        try {
            ti.setText(1, metaData.getDatabaseProductVersion());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting database product version ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("Driver_Major_Version_6"));
        try {
            ti.setText(1, "" + metaData_.getDriverMajorVersion());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting driver major version ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("Driver_Minor_Version_8"));
        try {
            ti.setText(1, "" + metaData_.getDriverMinorVersion());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting driver minor version ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("Driver_Name_10"));
        try {
            ti.setText(1, metaData.getDriverName());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting driver name ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("Driver_Version_12"));
        try {
            ti.setText(1, metaData_.getDriverVersion());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting driver version ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("User_Name_14"));
        try {
            ti.setText(1, metaData.getUserName());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting user name ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("URL_16"));
        try {
            ti.setText(1, metaData_.getURL());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting database URL ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, Messages.getString("SessionTreeNode.AutoCommit_Mode_1"));
        try {
            ti.setText(1, "" + metaData_.getConnection().getAutoCommit());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting database autocommit mode ", e);
        }
        ti = new TableItem(this.table, 0);
        ti.setText(0, "All Procedures Are Callable");
        try {
            ti.setText(1, "" + metaData_.allProceduresAreCallable());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "All Tables Are Selectable");
        try {
            ti.setText(1, "" + metaData_.allTablesAreSelectable());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Nulls are sorted High");
        try {
            ti.setText(1, "" + metaData_.nullsAreSortedHigh());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Nulls are sorted Low");
        try {
            ti.setText(1, "" + metaData_.nullsAreSortedLow());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Nulls are sorted at Start");
        try {
            ti.setText(1, "" + metaData_.nullsAreSortedAtStart());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Nulls are sorted at End");
        try {
            ti.setText(1, "" + metaData_.nullsAreSortedAtEnd());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Is Read Only");
        try {
            ti.setText(1, "" + metaData_.isReadOnly());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Result Set Holdability");
        try {
            ti.setText(1, "" + metaData_.getResultSetHoldability());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Uses Local Files");
        try {
            ti.setText(1, "" + metaData_.usesLocalFiles());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Uses Local File per Table");
        try {
            ti.setText(1, "" + metaData_.usesLocalFilePerTable());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Mixed Case Identifiers");
        try {
            ti.setText(1, "" + metaData_.supportsMixedCaseIdentifiers());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Stores Upper Case Identifiers");
        try {
            ti.setText(1, "" + metaData_.storesUpperCaseIdentifiers());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Stores Lower Case Identifiers");
        try {
            ti.setText(1, "" + metaData_.storesLowerCaseIdentifiers());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Stores Mixed Case Identifiers");
        try {
            ti.setText(1, "" + metaData_.storesMixedCaseIdentifiers());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Mixed Case Quoted Identifiers");
        try {
            ti.setText(1, "" + metaData_.supportsMixedCaseQuotedIdentifiers());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Stores Upper Case Quoted Identifiers");
        try {
            ti.setText(1, "" + metaData_.storesUpperCaseQuotedIdentifiers());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Stores Lower Case Quoted Identifiers");
        try {
            ti.setText(1, "" + metaData_.storesLowerCaseQuotedIdentifiers());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Stores Mixed Case Quoted Identifiers");
        try {
            ti.setText(1, "" + metaData_.storesMixedCaseQuotedIdentifiers());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Identifier Quote");
        try {
            ti.setText(1, metaData_.getIdentifierQuoteString());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Search String Escape");
        try {
            ti.setText(1, metaData_.getSearchStringEscape());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Extra Name Characters");
        try {
            ti.setText(1, metaData_.getExtraNameCharacters());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Alter Table With Add Column");
        try {
            ti.setText(1, "" + metaData_.supportsAlterTableWithAddColumn());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Alter Table With Drop Column");
        try {
            ti.setText(1, "" + metaData_.supportsAlterTableWithDropColumn());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Column Aliasing");
        try {
            ti.setText(1, "" + metaData_.supportsColumnAliasing());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Null Plus Non Null Is Null");
        try {
            ti.setText(1, "" + metaData_.nullPlusNonNullIsNull());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Convert");
        try {
            ti.setText(1, "" + metaData_.supportsConvert());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Table Correlation Names");
        try {
            ti.setText(1, "" + metaData_.supportsTableCorrelationNames());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Different Table Correlation Names");
        try {
            ti.setText(1, "" + metaData_.supportsDifferentTableCorrelationNames());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Expressions in Order By");
        try {
            ti.setText(1, "" + metaData_.supportsExpressionsInOrderBy());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Order By Unrelated");
        try {
            ti.setText(1, "" + metaData_.supportsOrderByUnrelated());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Group By");
        try {
            ti.setText(1, "" + metaData_.supportsGroupBy());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Group By Unrelated");
        try {
            ti.setText(1, "" + metaData_.supportsGroupByUnrelated());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Group By Beyond Select");
        try {
            ti.setText(1, "" + metaData_.supportsGroupByBeyondSelect());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Like Escape Clause");
        try {
            ti.setText(1, "" + metaData_.supportsLikeEscapeClause());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Multiple Result Sets");
        try {
            ti.setText(1, "" + metaData_.supportsMultipleResultSets());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Multiple Open Results ");
        try {
            ti.setText(1, "" + metaData_.supportsMultipleOpenResults());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Multiple Transactions");
        try {
            ti.setText(1, "" + metaData_.supportsMultipleTransactions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Non Nullable Columns");
        try {
            ti.setText(1, "" + metaData_.supportsNonNullableColumns());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Minimum SQL Grammar");
        try {
            ti.setText(1, "" + metaData_.supportsMinimumSQLGrammar());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Core SQL Grammar");
        try {
            ti.setText(1, "" + metaData_.supportsCoreSQLGrammar());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Extended SQL Grammar");
        try {
            ti.setText(1, "" + metaData_.supportsExtendedSQLGrammar());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports ANSI92 Entry Level SQL");
        try {
            ti.setText(1, "" + metaData_.supportsANSI92EntryLevelSQL());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports ANSI92 Intermediate SQL");
        try {
            ti.setText(1, "" + metaData_.supportsANSI92IntermediateSQL());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports ANSI92 Full SQL");
        try {
            ti.setText(1, "" + metaData_.supportsANSI92FullSQL());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Integrity Enhancement Facility");
        try {
            ti.setText(1, "" + metaData_.supportsIntegrityEnhancementFacility());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Outer Joins");
        try {
            ti.setText(1, "" + metaData_.supportsOuterJoins());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Full Outer Joins");
        try {
            ti.setText(1, "" + metaData_.supportsFullOuterJoins());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Limited Outer Joins");
        try {
            ti.setText(1, "" + metaData_.supportsLimitedOuterJoins());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Schema Term");
        try {
            ti.setText(1, metaData_.getSchemaTerm());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Procedure Term");
        try {
            ti.setText(1, metaData_.getProcedureTerm());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Catalog Term");
        try {
            ti.setText(1, metaData_.getCatalogTerm());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Is Catalog at Start");
        try {
            ti.setText(1, "" + metaData_.isCatalogAtStart());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Catalog Separator");
        try {
            ti.setText(1, metaData_.getCatalogSeparator());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Schemas In Data Manipulation");
        try {
            ti.setText(1, "" + metaData_.supportsSchemasInDataManipulation());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Schemas In Procedure Calls");
        try {
            ti.setText(1, "" + metaData_.supportsSchemasInProcedureCalls());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Schemas In Table Definitions");
        try {
            ti.setText(1, "" + metaData_.supportsSchemasInTableDefinitions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Schemas In Index Definitions");
        try {
            ti.setText(1, "" + metaData_.supportsSchemasInIndexDefinitions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Schemas In Privilege Definitions");
        try {
            ti.setText(1, "" + metaData_.supportsSchemasInPrivilegeDefinitions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Catalogs In Data Manipulation");
        try {
            ti.setText(1, "" + metaData_.supportsCatalogsInDataManipulation());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Catalogs In Procedure Calls");
        try {
            ti.setText(1, "" + metaData_.supportsCatalogsInProcedureCalls());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Catalogs In Table Definitions");
        try {
            ti.setText(1, "" + metaData_.supportsCatalogsInTableDefinitions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Catalogs In Index Definitions");
        try {
            ti.setText(1, "" + metaData_.supportsCatalogsInIndexDefinitions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Catalogs In Privilege Definitions");
        try {
            ti.setText(1, "" + metaData_.supportsCatalogsInPrivilegeDefinitions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Positioned Delete");
        try {
            ti.setText(1, "" + metaData_.supportsPositionedDelete());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Positioned Update");
        try {
            ti.setText(1, "" + metaData_.supportsPositionedUpdate());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Stored Procedures");
        try {
            ti.setText(1, "" + metaData_.supportsStoredProcedures());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Subqueries In Comparisons");
        try {
            ti.setText(1, "" + metaData_.supportsSubqueriesInComparisons());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Subqueries In Exists");
        try {
            ti.setText(1, "" + metaData_.supportsSubqueriesInExists());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Subqueries in IN Statements");
        try {
            ti.setText(1, "" + metaData_.supportsSubqueriesInIns());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Subqueries in Quantified Expressions");
        try {
            ti.setText(1, "" + metaData_.supportsSubqueriesInQuantifieds());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Correlated Subqueries");
        try {
            ti.setText(1, "" + metaData_.supportsCorrelatedSubqueries());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Union");
        try {
            ti.setText(1, "" + metaData_.supportsUnion());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Union All");
        try {
            ti.setText(1, "" + metaData_.supportsUnionAll());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Open Cursors Across Commit");
        try {
            ti.setText(1, "" + metaData_.supportsOpenCursorsAcrossCommit());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Open Cursors Across Rollback");
        try {
            ti.setText(1, "" + metaData_.supportsOpenCursorsAcrossRollback());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Open Statements Across Commit");
        try {
            ti.setText(1, "" + metaData_.supportsOpenStatementsAcrossCommit());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Open Statements Across Rollback");
        try {
            ti.setText(1, "" + metaData_.supportsOpenStatementsAcrossRollback());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Binary Literal Length");
        try {
            ti.setText(1, "" + metaData_.getMaxBinaryLiteralLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Char Literal Length");
        try {
            ti.setText(1, "" + metaData_.getMaxCharLiteralLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Column Name Length");
        try {
            ti.setText(1, "" + metaData_.getMaxColumnNameLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Columns In Group By");
        try {
            ti.setText(1, "" + metaData_.getMaxColumnsInGroupBy());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Columns In Index");
        try {
            ti.setText(1, "" + metaData_.getMaxColumnsInIndex());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Columns In Order By");
        try {
            ti.setText(1, "" + metaData_.getMaxColumnsInOrderBy());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Columns In Select");
        try {
            ti.setText(1, "" + metaData_.getMaxColumnsInSelect());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Columns In Table");
        try {
            ti.setText(1, "" + metaData_.getMaxColumnsInTable());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Connections");
        try {
            ti.setText(1, "" + metaData_.getMaxConnections());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Cursor Name Length");
        try {
            ti.setText(1, "" + metaData_.getMaxCursorNameLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Index Length");
        try {
            ti.setText(1, "" + metaData_.getMaxIndexLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Schema Name Length");
        try {
            ti.setText(1, "" + metaData_.getMaxSchemaNameLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Procedure Name Length");
        try {
            ti.setText(1, "" + metaData_.getMaxProcedureNameLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Catalog Name Length");
        try {
            ti.setText(1, "" + metaData_.getMaxCatalogNameLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Row Size");
        try {
            ti.setText(1, "" + metaData_.getMaxRowSize());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Row Size Include Blobs");
        try {
            ti.setText(1, "" + metaData_.doesMaxRowSizeIncludeBlobs());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Statement Length");
        try {
            ti.setText(1, "" + metaData_.getMaxStatementLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Statements");
        try {
            ti.setText(1, "" + metaData_.getMaxStatements());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Table Name Length");
        try {
            ti.setText(1, "" + metaData_.getMaxTableNameLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max Tables In Select");
        try {
            ti.setText(1, "" + metaData_.getMaxTablesInSelect());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Max User Name Length");
        try {
            ti.setText(1, "" + metaData_.getMaxUserNameLength());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Default Transaction Isolation");
        try {
            int isol = metaData_.getDefaultTransactionIsolation();
            String is = null;
            switch (isol) {
                case 0: {
                    is = "TRANSACTION_NONE";
                    break;
                }
                case 2: {
                    is = "TRANSACTION_READ_COMMITTED";
                    break;
                }
                case 1: {
                    is = "TRANSACTION_READ_UNCOMMITTED";
                    break;
                }
                case 4: {
                    is = "TRANSACTION_REPEATABLE_READ";
                    break;
                }
                case 8: {
                    is = "TRANSACTION_SERIALIZABLE";
                    break;
                }
                default: {
                    is = "";
                }
            }
            ti.setText(1, is);
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Transactions");
        try {
            ti.setText(1, "" + metaData_.supportsTransactions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Data Definition and Data Manipulation Transactions");
        try {
            ti.setText(1, "" + metaData_.supportsDataDefinitionAndDataManipulationTransactions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Data Manipulation Transactions Only");
        try {
            ti.setText(1, "" + metaData_.supportsDataManipulationTransactionsOnly());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Data Definition Causes Transaction Commit");
        try {
            ti.setText(1, "" + metaData_.dataDefinitionCausesTransactionCommit());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Data Definition Ignored in Transactions");
        try {
            ti.setText(1, "" + metaData_.dataDefinitionIgnoredInTransactions());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Batch Updates");
        try {
            ti.setText(1, "" + metaData_.supportsBatchUpdates());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Savepoints");
        try {
            ti.setText(1, "" + metaData_.supportsSavepoints());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Named Parameters");
        try {
            ti.setText(1, "" + metaData_.supportsNamedParameters());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Get Generated Keys");
        try {
            ti.setText(1, "" + metaData_.supportsGetGeneratedKeys());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Database Major Version");
        try {
            ti.setText(1, "" + metaData_.getDatabaseMajorVersion());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Database Minor Version");
        try {
            ti.setText(1, "" + metaData_.getDatabaseMinorVersion());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "JDBC Minor Version");
        try {
            ti.setText(1, "" + metaData_.getJDBCMinorVersion());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "JDBC Major Version");
        try {
            ti.setText(1, "" + metaData_.getJDBCMajorVersion());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "SQL State Type");
        try {
            ti.setText(1, "" + metaData_.getSQLStateType());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Locators Update Copy");
        try {
            ti.setText(1, "" + metaData_.locatorsUpdateCopy());
        }
        catch (Throwable throwable) {}
        ti = new TableItem(this.table, 0);
        ti.setText(0, "Supports Statement Pooling");
        try {
            ti.setText(1, "" + metaData_.supportsStatementPooling());
        }
        catch (Throwable throwable) {}
        this.table.redraw();
    }
}

