/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.SqlResultsView;
import net.sourceforge.sqlexplorer.plugin.views.TableCellModifier;
import net.sourceforge.sqlexplorer.sqlpanel.SqlTableContentProvider;
import net.sourceforge.sqlexplorer.sqlpanel.actions.CloseSQLResultTab;
import net.sourceforge.sqlexplorer.sqlpanel.actions.ExportToClipboard;
import net.sourceforge.sqlexplorer.sqlpanel.actions.MoreRowsAction;
import net.sourceforge.sqlexplorer.sqlpanel.actions.RetrieveAllRowsAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;

public class CompositeSQLResultsViewer
extends Composite {
    TableViewer tableViewer;
    SqlResultsView sqlResultsView;
    MoreRowsAction moreRowsAction;
    RetrieveAllRowsAction getAllRowsAction;
    ExportToClipboard clipAction;
    StatusLineManager statusMgr;
    Label lb;
    private CloseSQLResultTab closeSQLResultTab;

    public CompositeSQLResultsViewer(SqlResultsView sqlResultsView, Composite parent, int style, int ii, TabItem tabItem) {
        super(parent, style);
        this.sqlResultsView = sqlResultsView;
        this.setLayout((Layout)new FillLayout());
        Composite myParent = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        myParent.setLayout((Layout)layout);
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        toolBarMgr.createControl(myParent);
        this.moreRowsAction = new MoreRowsAction(sqlResultsView, ii);
        this.getAllRowsAction = new RetrieveAllRowsAction(sqlResultsView, ii);
        this.clipAction = new ExportToClipboard(sqlResultsView, SQLExplorerPlugin.getDefault().getPreferenceStore(), ii);
        this.closeSQLResultTab = new CloseSQLResultTab(tabItem);
        toolBarMgr.add((IAction)this.moreRowsAction);
        toolBarMgr.add((IAction)this.getAllRowsAction);
        toolBarMgr.add((IAction)this.clipAction);
        toolBarMgr.add((IAction)this.closeSQLResultTab);
        toolBarMgr.update(true);
        GridData gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        toolBarMgr.getControl().setLayoutData((Object)gid);
        gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        Label label = new Label(myParent, 0);
        label.setText("QQ coisa");
        this.tableViewer = new TableViewer(myParent, 66304);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getControl().setLayoutData((Object)gid);
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent evt) {
                CompositeSQLResultsViewer.this.handleDoubleClick(evt);
            }
        });
        this.tableViewer.setCellModifier((ICellModifier)new TableCellModifier());
        this.tableViewer.setContentProvider((IContentProvider)new SqlTableContentProvider());
        this.tableViewer.setUseHashlookup(true);
        this.statusMgr = new StatusLineManager();
        this.statusMgr.createControl(myParent);
        this.lb = new Label((Composite)this.statusMgr.getControl(), 0);
        gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        this.statusMgr.getControl().setLayoutData((Object)gid);
        myParent.layout();
    }

    protected void handleDoubleClick(MouseEvent evt) {
        Table t = (Table)evt.widget;
        int index = t.getSelectionIndex();
        if (index != -1) {
            int i = 0;
            while (i < t.getColumnCount()) {
                if (t.getItem(index).getBounds(i).contains(evt.x, evt.y)) {
                    try {
                        this.tableViewer.editElement(this.tableViewer.getElementAt(index), i);
                    }
                    catch (Exception e) {
                        SQLExplorerPlugin.error("Error editing the table element ", e);
                    }
                    break;
                }
                ++i;
            }
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void enableMoreRows(boolean b) {
        this.moreRowsAction.setEnabled(b);
        this.getAllRowsAction.setEnabled(b);
    }

    public void setMessagePanel1(String s) {
        this.statusMgr.setMessage(s);
    }

    public void setMessagePanel2(String s) {
        this.lb.setText(s);
        ((Composite)this.statusMgr.getControl()).layout();
    }
}

