/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.gef.model.AbstractModelObject;
import net.sourceforge.sqlexplorer.gef.model.Column;
import net.sourceforge.sqlexplorer.gef.model.Fk;
import net.sourceforge.sqlexplorer.gef.model.IGefObject;
import net.sourceforge.sqlexplorer.gef.model.Link;
import net.sourceforge.sqlexplorer.gef.model.Pk;
import net.sourceforge.sqlexplorer.gef.model.Schema;
import net.sourceforge.sqlexplorer.gef.model.TablePropertyManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class Table
extends AbstractModelObject {
    static final long serialVersionUID = 1L;
    private String schemaName;
    private String catalogName;
    private String qualifiedName;
    private TablePropertyManager tpm;
    private IGefObject schema;
    private String simpleName;
    private Point _point;
    private Dimension _dimension;
    private boolean showColumnDetail = true;
    private boolean showQualifiedName = true;
    public static String TERMINAL_1_IN = "A";
    public static String TERMINAL_1_OUT = "1";
    private List columns = Collections.EMPTY_LIST;
    private Pk pk = null;
    private List fkList = Collections.EMPTY_LIST;

    public List getSourceConnections() {
        return (List)this.outputs.clone();
    }

    public List getTargetConnections() {
        return (List)this.inputs.clone();
    }

    public boolean isPrimaryKey(Column column) {
        if (this.pk == null) {
            return false;
        }
        return this.pk.containsColumn(column.columnName);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.tpm.getPropertyDescriptors();
    }

    public Object getPropertyValue(Object propName) {
        return this.tpm.getPropertyValue(propName);
    }

    public void setPropertyValue(Object id, Object value) {
        this.tpm.setPropertyValue(id, value);
    }

    public Table(String label) {
        this.tpm = new TablePropertyManager(this);
        this.simpleName = label;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setShowColumnDetail(boolean val) {
        boolean oldVal = this.showColumnDetail;
        this.showColumnDetail = val;
        this.firePropertyChange("showColumnDetail", oldVal, val);
    }

    public Point getLocation() {
        return this._point;
    }

    public Dimension getSize() {
        return this._dimension;
    }

    public void setLocation(Point point) {
        this.setLocation(point, true);
    }

    public void setLocation(Point point, boolean fire) {
        Point point1 = this._point;
        this._point = point;
        this.firePropertyChange("location", point1, point);
    }

    public void setSize(Dimension dimension) {
        Dimension dimension1 = this._dimension;
        this._dimension = dimension;
        this.firePropertyChange("size", dimension1, dimension);
    }

    public String getName() {
        return this.getQualifiedName();
    }

    public IGefObject getElementAt(int i) {
        return null;
    }

    public int getElementsCount() {
        return 0;
    }

    public int indexOf(IGefObject inamedobject) {
        return -1;
    }

    public boolean removeChild(AbstractModelObject inamedobject) {
        return false;
    }

    public void addChild(int i, AbstractModelObject inamedobject) {
    }

    public IGefObject getParent() {
        return this.schema;
    }

    public String[] getColumnNames() {
        ArrayList<String> ls = new ArrayList<String>();
        Iterator it = this.columns.iterator();
        while (it.hasNext()) {
            ls.add(((Column)it.next()).columnName);
        }
        return ls.toArray(new String[ls.size()]);
    }

    public void setColumns(List columns) {
        this.columns = columns;
    }

    public Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    public boolean isShowColumnDetail() {
        return this.showColumnDetail;
    }

    public IGefObject[] getElements() {
        return null;
    }

    public void setParent(IGefObject schema) {
        this.schema = schema;
    }

    public void addChild(AbstractModelObject tb) {
    }

    public void setFkList(ArrayList list) {
        this.fkList = list;
    }

    public List getFkList() {
        return this.fkList;
    }

    public void setFkList(List list) {
        this.fkList = list;
    }

    public void setQualifiedName(String string) {
        this.qualifiedName = string;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean isShowQualifiedName() {
        return this.showQualifiedName;
    }

    public void setShowQualifiedName(boolean val) {
        boolean oldVal = this.showQualifiedName;
        this.showQualifiedName = val;
        this.firePropertyChange("showQualifiedName", oldVal, val);
    }

    public Pk getPk() {
        return this.pk;
    }

    public void setPk(Pk pk) {
        this.pk = pk;
    }

    public void createLinks(Schema schema) {
        Pk pk = this.getPk();
        IGefObject[] objects = schema.getElements();
        if (pk != null) {
            int j = 0;
            while (j < objects.length) {
                IGefObject obj2 = objects[j];
                if (obj2 instanceof Table) {
                    Table source = (Table)obj2;
                    Iterator fkIterator = source.getFkList().iterator();
                    while (fkIterator.hasNext()) {
                        Fk fk = (Fk)fkIterator.next();
                        if (!fk.isRelated(pk, this)) continue;
                        Link wire = new Link(fk);
                        wire.setSource(source);
                        wire.setSourceTerminal(TERMINAL_1_OUT);
                        wire.setTarget(this);
                        wire.setTargetTerminal(TERMINAL_1_IN);
                        wire.attachSource();
                        wire.attachTarget();
                    }
                }
                ++j;
            }
        }
        Iterator itFk = this.getFkList().iterator();
        while (itFk.hasNext()) {
            Fk fk = (Fk)itFk.next();
            int j = 0;
            while (j < objects.length) {
                Table source;
                Pk pk_;
                IGefObject obj2 = objects[j];
                if (obj2 instanceof Table && (pk_ = (source = (Table)obj2).getPk()) != null && fk.isRelated(pk_, source)) {
                    j = objects.length;
                    Link wire = new Link(fk);
                    wire.setSource(this);
                    wire.setSourceTerminal(TERMINAL_1_OUT);
                    wire.setTarget(source);
                    wire.setTargetTerminal(TERMINAL_1_IN);
                    wire.attachSource();
                    wire.attachTarget();
                }
                ++j;
            }
        }
    }

    public void removeLinks(Schema schema) {
        Link ln;
        int i = 0;
        while (i < this.inputs.size()) {
            ln = (Link)this.inputs.get(i);
            ln.detachSource();
            ++i;
        }
        i = 0;
        while (i < this.outputs.size()) {
            ln = (Link)this.outputs.get(i);
            ln.detachTarget();
            ++i;
        }
        this.inputs.clear();
        this.outputs.clear();
    }
}

