/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.EventObject;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.gef.editors.SchemaEditorContextMenuProvider;
import net.sourceforge.sqlexplorer.gef.editors.SchemaPartFactory;
import net.sourceforge.sqlexplorer.gef.editors.SchemaTreePartFactory;
import net.sourceforge.sqlexplorer.gef.editors.TableFactory;
import net.sourceforge.sqlexplorer.gef.model.Schema;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.TableNodeTransfer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;

public class SchemaEditor
extends GraphicalEditor
implements CommandStackListener {
    Schema schema;
    private ResourceTracker resourceListener = new ResourceTracker();
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part != SchemaEditor.this) {
                return;
            }
            if (!((FileEditorInput)SchemaEditor.this.getEditorInput()).getFile().exists()) {
                Shell shell = SchemaEditor.this.getSite().getShell();
                String title = "Deleted";
                String message = "File Deleted without Saving";
                String[] buttons = new String[]{"Save", "Close"};
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttons, 0);
                if (dialog.open() == 0) {
                    if (!SchemaEditor.this.performSaveAs()) {
                        this.partActivated(part);
                    }
                } else {
                    SchemaEditor.this.closeEditor(false);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private boolean savePreviouslyNeeded = false;
    public static final String ID = "net.sf.gef.editors.SchemaEditor";
    private KeyHandler keyHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SchemaEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer scrollinggraphicalviewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart scalablefreeformrooteditpart = new ScalableFreeformRootEditPart();
        ZoomInAction zoominaction = new ZoomInAction(scalablefreeformrooteditpart.getZoomManager());
        ZoomOutAction zoomoutaction = new ZoomOutAction(scalablefreeformrooteditpart.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoominaction);
        this.getActionRegistry().registerAction((IAction)zoomoutaction);
        try {
            SchemaEditor pt = this;
            PrintAction act = new PrintAction((IWorkbenchPart)pt){

                public String getText() {
                    return Messages.getString("SchemaEditor.Print..._1");
                }
            };
            this.getActionRegistry().registerAction((IAction)act);
        }
        catch (Throwable throwable) {}
        this.getSite().getKeyBindingService().registerAction((IAction)zoominaction);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomoutaction);
        scrollinggraphicalviewer.setRootEditPart((RootEditPart)scalablefreeformrooteditpart);
        scrollinggraphicalviewer.setEditPartFactory((EditPartFactory)new SchemaPartFactory());
        SchemaEditorContextMenuProvider schemaContextMenuProvider = new SchemaEditorContextMenuProvider((EditPartViewer)scrollinggraphicalviewer, this.getActionRegistry(), this);
        scrollinggraphicalviewer.setContextMenu((MenuManager)schemaContextMenuProvider);
        this.getSite().registerContextMenu((MenuManager)schemaContextMenuProvider, (ISelectionProvider)scrollinggraphicalviewer);
        scrollinggraphicalviewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)scrollinggraphicalviewer).setParent(this.getCommonKeyHandler()));
        Font font1 = JFaceResources.getDefaultFont();
        scrollinggraphicalviewer.getControl().setFont(font1);
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new AbstractTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), (Transfer)TableNodeTransfer.getInstance()){
            TableFactory factory = new TableFactory();

            protected Request createTargetRequest() {
                CreateRequest request = new CreateRequest();
                request.setFactory((CreationFactory)this.factory);
                this.factory.setTableNode((TableNode)TableNodeTransfer.getInstance().getSelection());
                return request;
            }

            protected void updateTargetRequest() {
                ((CreateRequest)this.getTargetRequest()).setLocation(this.getDropLocation());
            }

            protected void handleDrop() {
                super.handleDrop();
            }

            protected void handleDragOver() {
                DropTargetEvent ev = this.getCurrentEvent();
                ev.detail = 1;
                ev.data = TableNodeTransfer.getInstance().getSelection();
                super.handleDragOver();
            }

            public boolean isEnabled(DropTargetEvent dte) {
                if (TableNodeTransfer.getInstance().getSelection() != null) {
                    return true;
                }
                return super.isEnabled(dte);
            }
        });
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'c', (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'v', (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'C', (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'V', (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId()));
        }
        return this.keyHandler;
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.getSchema());
    }

    Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema();
        }
        return this.schema;
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry actionregistry = this.getActionRegistry();
        IAction iaction = actionregistry.getAction((Object)"print");
        if (iaction != null) {
            actionregistry.removeAction(iaction);
        }
        AlignmentAction obj = null;
        obj = new AlignmentAction((IWorkbenchPart)this, 1);
        actionregistry.registerAction((IAction)obj);
        this.getSelectionActions().add(((IAction)obj).getId());
        obj = new AlignmentAction((IWorkbenchPart)this, 4);
        actionregistry.registerAction((IAction)obj);
        this.getSelectionActions().add(((IAction)obj).getId());
        obj = new AlignmentAction((IWorkbenchPart)this, 8);
        actionregistry.registerAction((IAction)obj);
        this.getSelectionActions().add(((IAction)obj).getId());
        obj = new AlignmentAction((IWorkbenchPart)this, 32);
        actionregistry.registerAction((IAction)obj);
        this.getSelectionActions().add(((IAction)obj).getId());
        obj = new AlignmentAction((IWorkbenchPart)this, 2);
        actionregistry.registerAction((IAction)obj);
        this.getSelectionActions().add(((IAction)obj).getId());
        obj = new AlignmentAction((IWorkbenchPart)this, 16);
        actionregistry.registerAction((IAction)obj);
        this.getSelectionActions().add(((IAction)obj).getId());
    }

    protected GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public void setInput(IEditorInput input) {
        this.superSetInput(input);
        IFile file = ((IFileEditorInput)input).getFile();
        try {
            InputStream is = file.getContents(false);
            ObjectInputStream ois = new ObjectInputStream(is);
            this.setSchema((Schema)ois.readObject());
            ois.close();
        }
        catch (Exception exception) {}
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    protected void superSetInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        } else {
            this.setTitle(Messages.getString("SchemaEditor.Schema_Viewer__2"));
        }
    }

    protected void setSite(IWorkbenchPartSite iworkbenchpartsite) {
        super.setSite(iworkbenchpartsite);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            IFile ifile = ((IFileEditorInput)this.getEditorInput()).getFile();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.createOutputStream(out);
            ifile.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, progressMonitor);
            out.close();
            this.getCommandStack().markSaveLocation();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error saving", e);
        }
    }

    public void doSaveAs() {
        this.performSaveAs();
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    protected boolean performSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    SchemaEditor.this.createOutputStream(out);
                    file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), true, monitor);
                    out.close();
                }
                catch (Exception e) {
                    SQLExplorerPlugin.error("Error performing save as", e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error performing save as", e);
        }
        return true;
    }

    protected void createOutputStream(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.getSchema());
        out.close();
    }

    public void gotoMarker(IMarker imarker) {
    }

    protected void updateMarkers(IResource iresource, IProgressMonitor iprogressmonitor) throws CoreException {
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public void commandStackChanged(EventObject eventobject) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(eventobject);
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    protected void closeEditor(boolean flag) {
        this.getSite().getPage().closeEditor((IEditorPart)this, flag);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.partListener = null;
        ((FileEditorInput)this.getEditorInput()).getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        super.dispose();
    }

    static DefaultEditDomain getEditDomain(SchemaEditor schemaEditor) {
        return schemaEditor.getEditDomain();
    }

    static ActionRegistry getActionRegistry(SchemaEditor schemaEditor) {
        return schemaEditor.getActionRegistry();
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.ui.stackview.CommandStackInspectorPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return new CommandStackInspectorPage(this.getCommandStack());
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return new OutlinePage((EditPartViewer)new TreeViewer());
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((FileEditorInput)SchemaEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!SchemaEditor.this.isDirty()) {
                        SchemaEditor.this.closeEditor(false);
                    }
                } else {
                    IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = SchemaEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(this, newFile){
                        final /* synthetic */ ResourceTracker this$1;
                        private final /* synthetic */ IFile val$newFile;
                        {
                            this.this$1 = resourceTracker;
                            this.val$newFile = iFile;
                        }

                        public void run() {
                            ResourceTracker.access$0(this.this$1).superSetInput((IEditorInput)new FileEditorInput(this.val$newFile));
                        }
                    });
                }
            }
            return false;
        }

        static /* synthetic */ SchemaEditor access$0(ResourceTracker resourceTracker) {
            return resourceTracker.SchemaEditor.this;
        }
    }

    protected class OutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        private PageBook pageBook;
        private Control outline;
        private Canvas overview;
        private IAction showOutlineAction;
        private IAction showOverviewAction;
        static final int ID_OUTLINE = 0;
        static final int ID_OVERVIEW = 1;
        private boolean overviewInitialized;
        private Thumbnail thumbnail;
        private SchemaTreePartFactory schemaTreePartFactory = new SchemaTreePartFactory();
        static /* synthetic */ Class class$0;

        public void init(IPageSite ipagesite) {
            super.init(ipagesite);
            ActionRegistry actionregistry = SchemaEditor.getActionRegistry(SchemaEditor.this);
            IActionBars iactionbars = ipagesite.getActionBars();
            String s = "undo";
            iactionbars.setGlobalActionHandler(s, actionregistry.getAction((Object)s));
            s = "redo";
            iactionbars.setGlobalActionHandler(s, actionregistry.getAction((Object)s));
            s = "delete";
            iactionbars.setGlobalActionHandler(s, actionregistry.getAction((Object)s));
            iactionbars.updateActionBars();
        }

        protected void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)SchemaEditor.getEditDomain(SchemaEditor.this));
            this.getViewer().setEditPartFactory((EditPartFactory)this.schemaTreePartFactory);
            this.getViewer().setKeyHandler(SchemaEditor.this.getCommonKeyHandler());
            IToolBarManager itoolbarmanager = this.getSite().getActionBars().getToolBarManager();
            this.showOutlineAction = new Action(this){
                final /* synthetic */ OutlinePage this$1;
                {
                    this.this$1 = outlinePage;
                }

                public void run() {
                    this.this$1.showPage(0);
                }
            };
            this.showOutlineAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)SqlexplorerImages.getOutline()));
            itoolbarmanager.add(this.showOutlineAction);
            this.showOverviewAction = new Action(this){
                final /* synthetic */ OutlinePage this$1;
                {
                    this.this$1 = outlinePage;
                }

                public void run() {
                    this.this$1.showPage(1);
                }
            };
            this.showOverviewAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)SqlexplorerImages.getOverview()));
            itoolbarmanager.add(this.showOverviewAction);
            this.showPage(0);
        }

        public void createControl(Composite composite) {
            this.pageBook = new PageBook(composite, 0);
            this.outline = this.getViewer().createControl((Composite)this.pageBook);
            this.overview = new Canvas((Composite)this.pageBook, 0);
            this.pageBook.showPage(this.outline);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
        }

        public void dispose() {
            this.unhookOutlineViewer();
            super.dispose();
        }

        public Object getAdapter(Class key) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (key == clazz) {
                return ((ScalableFreeformRootEditPart)SchemaEditor.this.getGraphicalViewer().getRootEditPart()).getZoomManager();
            }
            return null;
        }

        public Control getControl() {
            return this.pageBook;
        }

        protected void hookOutlineViewer() {
            SchemaEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        protected void unhookOutlineViewer() {
            SchemaEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
        }

        protected void initializeOutlineViewer() {
            this.getViewer().setContents((Object)SchemaEditor.this.getSchema());
        }

        protected void initializeOverview() {
            LightweightSystem lws = new LightweightSystem(this.overview);
            RootEditPart rep = SchemaEditor.this.getGraphicalViewer().getRootEditPart();
            if (rep instanceof ScalableFreeformRootEditPart) {
                ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
                this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
                this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
                lws.setContents((IFigure)this.thumbnail);
            }
        }

        protected void showPage(int id) {
            if (id == 0) {
                this.showOutlineAction.setChecked(true);
                this.showOverviewAction.setChecked(false);
                this.pageBook.showPage(this.outline);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(false);
                }
            } else if (id == 1) {
                if (!this.overviewInitialized) {
                    this.initializeOverview();
                }
                this.showOutlineAction.setChecked(false);
                this.showOverviewAction.setChecked(true);
                this.pageBook.showPage((Control)this.overview);
                this.thumbnail.setVisible(true);
            }
        }

        public OutlinePage(EditPartViewer editpartviewer) {
            super(editpartviewer);
        }
    }
}

