/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.sqlexplorer.gef.editors.SchemaComponentEditPolicy;
import net.sourceforge.sqlexplorer.gef.editors.SchemaContainerEditPolicy;
import net.sourceforge.sqlexplorer.gef.editors.SchemaDirectEditPolicy;
import net.sourceforge.sqlexplorer.gef.editors.SchemaXYLayoutEditPolicy;
import net.sourceforge.sqlexplorer.gef.model.Schema;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gef.tools.MarqueeDragTracker;

public class SchemaEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    protected List getModelChildren() {
        Schema schema = (Schema)this.getModel();
        return Arrays.asList(schema.getElements());
    }

    protected IFigure createFigure() {
        FreeformLayer freeformlayer = new FreeformLayer();
        freeformlayer.setLayoutManager((LayoutManager)new FreeformLayout());
        freeformlayer.setBorder((Border)new MarginBorder(5));
        freeformlayer.setBackgroundColor(ColorConstants.white);
        freeformlayer.setOpaque(true);
        return freeformlayer;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new SchemaComponentEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new SchemaContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SchemaXYLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new SchemaDirectEditPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new MarqueeDragTracker();
    }

    public void exec() {
        CommandStack commandstack = this.getRoot().getViewer().getEditDomain().getCommandStack();
        Command command = this.getCommand((Request)new DirectEditRequest());
        if (command != null && command.canExecute()) {
            commandstack.execute(command);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.exec();
            return;
        }
        super.performRequest(request);
    }

    protected void refreshVisuals() {
        this.refreshStructure();
        this.refreshLayout();
    }

    protected void refreshLayout() {
    }

    protected void refreshStructure() {
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        ((Schema)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        ((Schema)this.getModel()).removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        this.refresh();
    }
}

