/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.commands;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.gef.model.AbstractModelObject;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class MoveObjectFigureCommand
extends Command {
    private AbstractModelObject table;
    private Point location;
    private Dimension dimension;
    private Point old_location;
    private Dimension old_dimension;

    public void setModelObject(AbstractModelObject table) {
        this.table = table;
    }

    public void setSize(Dimension dim) {
        this.dimension = dim;
    }

    public void setLocation(Rectangle rectangle) {
        this.setLocation(new Point(rectangle.x, rectangle.y));
        this.setSize(new Dimension(rectangle.width, rectangle.height));
    }

    private void setLocation(Point point) {
        if (point != null) {
            this.location = new Point(point);
        }
    }

    public String getLabel() {
        return String.valueOf(Messages.getString("MoveObjectFigureCommand.Move__1")) + this.table.getName();
    }

    private Point getLocation() {
        return this.location;
    }

    public void execute() {
        this.old_location = this.table.getLocation();
        this.old_dimension = this.table.getSize();
        if (this.dimension != null) {
            this.table.setSize(this.dimension);
        }
        if (this.location != null) {
            this.table.setLocation(this.getLocation());
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        if (this.old_location != null) {
            this.table.setLocation(this.old_location);
        }
        if (this.old_dimension != null) {
            this.table.setSize(this.old_dimension);
        }
    }
}

