/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.model;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.DetailManager;
import net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.swt.widgets.Composite;

public class TableObjectTypeNode
implements IDbModel {
    private IDbModel parent;
    private String txt;
    private ArrayList list = new ArrayList(10);
    private SQLConnection conn;
    private boolean loaded = false;

    public Composite getComposite(DetailManager detailManager) {
        return null;
    }

    public TableObjectTypeNode(IDbModel s, String name, SQLConnection conn) {
        this.parent = s;
        this.txt = name;
        this.conn = conn;
    }

    public void refresh() {
        this.list.clear();
        this.load();
    }

    private void load() {
        try {
            String catName = null;
            String schemaName = null;
            Dictionary dict = null;
            if (this.parent instanceof CatalogNode) {
                dict = ((CatalogNode)this.parent).getSessionNode().getDictionary();
                catName = this.parent.toString();
                if (catName.equals(Messages.getString("NoCatalog_2"))) {
                    catName = null;
                }
            } else if (this.parent instanceof SchemaNode) {
                dict = ((SchemaNode)this.parent).getSessionNode().getDictionary();
                schemaName = this.parent.toString();
            }
            ITableInfo[] tables = this.conn.getSQLMetaData().getTables(catName, schemaName, "%", new String[]{this.txt});
            int i = 0;
            while (i < tables.length) {
                this.list.add(new TableNode(this, tables[i].getSimpleName(), this.conn, tables[i]));
                ++i;
            }
            if (dict != null) {
                this.loadDict(dict);
            }
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting table information ", e);
            this.list.clear();
        }
    }

    private void loadDict(Dictionary dict) {
        int i = 0;
        while (i < this.list.size()) {
            IDbModel nd = (IDbModel)this.list.get(i);
            if (nd instanceof TableNode) {
                String name = nd.toString();
                ArrayList<IDbModel> listDict = null;
                listDict = (ArrayList<IDbModel>)dict.getByTableName(name);
                if (listDict == null) {
                    listDict = new ArrayList<IDbModel>(2);
                    dict.putTableName(name, listDict);
                }
                listDict.add(nd);
            }
            ++i;
        }
    }

    public Object[] getChildren() {
        if (!this.loaded) {
            this.load();
            this.loaded = true;
        }
        return this.list.toArray();
    }

    public Object getParent() {
        return this.parent;
    }

    public String toString() {
        return this.txt;
    }

    public void setTables(ArrayList tables) {
        this.list = tables;
        this.loaded = true;
        int i = 0;
        while (i < this.list.size()) {
            TableNode tn = (TableNode)this.list.get(i);
            tn.setParent(this);
            ++i;
        }
        Dictionary dict = null;
        if (this.parent instanceof CatalogNode) {
            dict = ((CatalogNode)this.parent).getSessionNode().getDictionary();
        } else if (this.parent instanceof SchemaNode) {
            dict = ((SchemaNode)this.parent).getSessionNode().getDictionary();
        }
        if (dict != null) {
            this.loadDict(dict);
        }
    }
}

