/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import net.sourceforge.sqlexplorer.dbviewer.DetailManager;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.swt.widgets.Composite;

public class TableNode
implements IDbModel {
    static String sep = System.getProperty("line.separator");
    private IDbModel parent;
    private String txt;
    private ArrayList list = new ArrayList(1);
    private SQLConnection conn;
    private ITableInfo iTableInfo;
    private volatile int hash = 0;
    String tableDesc = null;
    private ArrayList listColNames = null;

    public Composite getComposite(DetailManager detailManager) {
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public Object[] getChildren() {
        return this.list.toArray();
    }

    public String toString() {
        return this.txt;
    }

    public boolean isTable() {
        return this.iTableInfo.getType().equalsIgnoreCase("TABLE");
    }

    public boolean isView() {
        return this.iTableInfo.getType().equalsIgnoreCase("VIEW");
    }

    public boolean isSynonym() {
        return this.iTableInfo.getType().equalsIgnoreCase("SYNONYM");
    }

    TableNode(IDbModel s, String name, SQLConnection conn, ITableInfo iTableInfo) {
        this.conn = conn;
        this.parent = s;
        this.txt = name;
        this.iTableInfo = iTableInfo;
    }

    public long getRowCount() throws Throwable {
        Statement st = this.conn.createStatement();
        ResultSet rs = st.executeQuery("select count(*) from " + this.iTableInfo.getQualifiedName());
        long result = 0L;
        if (rs.next()) {
            result = rs.getLong(1);
        }
        rs.close();
        st.close();
        return result;
    }

    public ArrayList getColumnNames() throws Exception {
        if (this.listColNames == null) {
            this.listColNames = new ArrayList();
            ResultSet rs = this.getColumns();
            if (rs != null) {
                while (rs.next()) {
                    this.listColNames.add(rs.getString("COLUMN_NAME"));
                }
                rs.close();
            }
        }
        return this.listColNames;
    }

    public ResultSet getColumns() throws Exception {
        if (this.iTableInfo != null) {
            return this.conn.getSQLMetaData().getColumns(this.iTableInfo);
        }
        return null;
    }

    public ResultSet getIndexes() throws Exception {
        if (this.iTableInfo != null) {
            return this.conn.getSQLMetaData().getIndexInfo(this.iTableInfo);
        }
        return null;
    }

    public ResultSet getPreview(int iMaxRowCount) throws Exception {
        Statement st = this.conn.createStatement();
        try {
            st.setMaxRows(iMaxRowCount);
        }
        catch (Throwable throwable) {}
        ResultSet rs = null;
        if (this.iTableInfo != null) {
            rs = st.executeQuery("select * from " + this.iTableInfo.getQualifiedName());
        }
        return rs;
    }

    public ResultSet getPK() throws Exception {
        if (this.iTableInfo != null) {
            return this.conn.getSQLMetaData().getPrimaryKeys(this.iTableInfo);
        }
        return null;
    }

    public String[] getPrimaryKeyColumns() {
        if (this.iTableInfo != null) {
            try {
                ResultSet rs = this.conn.getSQLMetaData().getPrimaryKeys(this.iTableInfo);
                ArrayList<String> ls = new ArrayList<String>(10);
                while (rs.next()) {
                    ls.add(rs.getString("COLUMN_NAME"));
                }
                rs.close();
                return ls.toArray(new String[ls.size()]);
            }
            catch (Throwable throwable) {}
        }
        return new String[0];
    }

    public ResultSet getFK() throws Exception {
        if (this.iTableInfo != null) {
            return this.conn.getSQLMetaData().getImportedKeys(this.iTableInfo);
        }
        return null;
    }

    public ITableInfo getTableInfo() {
        return this.iTableInfo;
    }

    public String getTableDesc() {
        if (this.tableDesc == null) {
            StringBuffer sb = new StringBuffer(200);
            try {
                sb.append(" " + this.getTableInfo().getQualifiedName() + " ");
                sb.append(sep).append(sep);
                ResultSet rs = this.getColumns();
                while (rs.next()) {
                    StringBuffer line = new StringBuffer(40);
                    line.append(" " + rs.getString("COLUMN_NAME"));
                    int length = line.length();
                    if (length < 25) {
                        int i = length;
                        while (i < 25) {
                            line.append(" ");
                            ++i;
                        }
                    }
                    line.append(rs.getString("TYPE_NAME"));
                    line.append("(");
                    line.append(rs.getInt("COLUMN_SIZE"));
                    line.append(")" + sep);
                    sb.append(line);
                }
                rs.close();
            }
            catch (Throwable throwable) {}
            this.tableDesc = sb.toString();
        }
        return this.tableDesc;
    }

    public void setParent(TableObjectTypeNode node) {
        this.parent = node;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TableNode)) {
            return false;
        }
        TableNode tn = (TableNode)obj;
        return tn.txt == this.txt && this.getSchemaOrCatalog().toString().equals(tn.getSchemaOrCatalog().toString());
    }

    public IDbModel getSchemaOrCatalog() {
        if (this.parent != null) {
            IDbModel pp = this.parent;
            return (IDbModel)pp.getParent();
        }
        return null;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = 17;
            if (this.txt != null) {
                result = 37 * result + this.txt.hashCode();
            }
            if (this.parent != null) {
                result = 37 * result + this.getSchemaOrCatalog().toString().hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }
}

