/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.details;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import net.sourceforge.sqlexplorer.dbviewer.details.IDetailLogDisplay;
import net.sourceforge.sqlexplorer.dbviewer.details.PreviewDetailContentProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.PreviewDetailLabelProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.PreviewDetailTableModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PreviewDetail
implements IDetailLogDisplay {
    TableViewer viewer;
    boolean activated = false;
    TableNode node;
    private IDetailLogDisplay detailLog;
    String errorMessage = "";
    IPreferenceStore store;
    TabItem itemTab;
    TabFolder parent;

    public void setMessage(String s) {
        this.detailLog.setMessage(s);
        this.errorMessage = s;
    }

    public PreviewDetail(TabItem itemTab, TabFolder parent, IDetailLogDisplay detailLog, IPreferenceStore store) {
        this.itemTab = itemTab;
        this.parent = parent;
        this.detailLog = detailLog;
        this.store = store;
    }

    public void setNode(TableNode node) {
        this.node = node;
        this.activated = false;
        if (this.viewer != null) {
            this.itemTab.setControl(null);
            this.viewer.getTable().dispose();
            this.viewer = null;
        }
    }

    public void activate() {
        if (!this.activated) {
            Display display = this.parent.getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    PreviewDetailTableModel pdtm = null;
                    int count = 0;
                    ResultSet set = null;
                    try {
                        try {
                            int iMaxRowCount = PreviewDetail.this.store.getInt("preRowCount");
                            set = PreviewDetail.this.node.getPreview(iMaxRowCount);
                            ResultSetReader reader = new ResultSetReader(set);
                            ResultSetMetaData metaData = set.getMetaData();
                            count = metaData.getColumnCount();
                            PreviewDetail.this.viewer = new TableViewer((Composite)PreviewDetail.this.parent, 67584);
                            PreviewDetail.this.itemTab.setControl(PreviewDetail.this.viewer.getControl());
                            Table table = PreviewDetail.this.viewer.getTable();
                            table.setLinesVisible(true);
                            table.setHeaderVisible(true);
                            PreviewDetail.this.viewer.setContentProvider((IContentProvider)new PreviewDetailContentProvider());
                            int i = 0;
                            while (true) {
                                if (i >= count) break;
                                TableColumn tc = new TableColumn(PreviewDetail.this.viewer.getTable(), 0);
                                tc.setText(metaData.getColumnLabel(i + 1));
                                ++i;
                            }
                            pdtm = new PreviewDetailTableModel(reader, metaData, PreviewDetail.this, iMaxRowCount);
                            PreviewDetailLabelProvider pdlp = new PreviewDetailLabelProvider(pdtm);
                            PreviewDetail.this.viewer.setLabelProvider((IBaseLabelProvider)pdlp);
                            PreviewDetail.this.viewer.setInput((Object)pdtm);
                            int i2 = 0;
                            while (true) {
                                if (i2 >= count) {
                                    PreviewDetail.this.viewer.getTable().layout();
                                }
                                table.getColumn(i2).pack();
                                ++i2;
                            }
                        }
                        catch (Throwable e) {
                            SQLExplorerPlugin.error("Error activating preview ", e);
                            PreviewDetail.this.errorMessage = e.getMessage();
                            PreviewDetail.this.setMessage(PreviewDetail.this.errorMessage);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        try {
                            Statement st = set.getStatement();
                            if (st != null) {
                                st.close();
                            }
                            set.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {}
                        throw throwable;
                    }
                    {
                        Object var10_15 = null;
                    }
                    try {}
                    catch (Throwable throwable) {}
                    Statement st = set.getStatement();
                    if (st != null) {
                        st.close();
                    }
                    set.close();
                    PreviewDetail.this.activated = true;
                }
            });
        } else {
            this.detailLog.setMessage(this.errorMessage);
        }
    }
}

