/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.details;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.actions.CopyTableAction;
import net.sourceforge.sqlexplorer.dbviewer.details.ColumnDetailContentProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.ColumnDetailLabelProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.ColumnDetailTableModel;
import net.sourceforge.sqlexplorer.dbviewer.details.IDetailLogDisplay;
import net.sourceforge.sqlexplorer.dbviewer.details.MySQLTableSorter;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ColumnsDetail
implements IDetailLogDisplay {
    TableViewer viewer;
    boolean activated = false;
    TableNode node;
    String errorMessage;
    IDetailLogDisplay detailLog;
    Image imgAsc = null;
    Image imgDesc = null;
    MySQLTableSorter sorter;

    public void setMessage(String s) {
        this.errorMessage = s;
        this.detailLog.setMessage(s);
    }

    public ColumnsDetail(TabItem itemTab, Composite parent, IDetailLogDisplay detailLog) {
        this.detailLog = detailLog;
        this.viewer = new TableViewer(parent, 67584);
        itemTab.setControl(this.viewer.getControl());
        Table table = this.viewer.getTable();
        this.imgAsc = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getAscOrderIcon()).createImage();
        this.imgDesc = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getDescOrderIcon()).createImage();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        MenuManager menuMgr = new MenuManager("#TableMenu");
        menuMgr.setRemoveAllWhenShown(false);
        menuMgr.add((IAction)new CopyTableAction(table));
        Menu fDbContextMenu = menuMgr.createContextMenu((Control)table);
        table.setMenu(fDbContextMenu);
        TableColumn tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Column_Name_1"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Data_Type_2"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Size_3"));
        tc = new TableColumn(table, 0);
        tc.setText("Decimal Digits");
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Default_Value_4"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Accept_Null_Value_5"));
        tc = new TableColumn(table, 0);
        tc.setText("Comments");
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < 7) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        this.viewer.setContentProvider((IContentProvider)new ColumnDetailContentProvider());
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column;
                if (ColumnsDetail.this.viewer.getSorter() == null) {
                    ColumnsDetail.this.viewer.setSorter((ViewerSorter)ColumnsDetail.this.sorter);
                }
                if ((column = ColumnsDetail.this.viewer.getTable().indexOf((TableColumn)e.widget)) == ColumnsDetail.this.sorter.getTopPriority()) {
                    int k = ColumnsDetail.this.sorter.reverseTopPriority();
                    if (k == 1) {
                        ((TableColumn)e.widget).setImage(ColumnsDetail.this.imgAsc);
                    } else {
                        ((TableColumn)e.widget).setImage(ColumnsDetail.this.imgDesc);
                    }
                } else {
                    ColumnsDetail.this.sorter.setTopPriority(column);
                    ((TableColumn)e.widget).setImage(ColumnsDetail.this.imgAsc);
                }
                TableColumn[] tcArr = ColumnsDetail.this.viewer.getTable().getColumns();
                int i = 0;
                while (i < tcArr.length) {
                    if (i != column) {
                        tcArr[i].setImage(null);
                    }
                    ++i;
                }
                ColumnsDetail.this.viewer.refresh();
            }
        };
        int i2 = 0;
        while (i2 < 7) {
            tc = table.getColumn(i2);
            tc.addSelectionListener((SelectionListener)headerListener);
            ++i2;
        }
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ColumnsDetail.this.imgAsc.dispose();
                ColumnsDetail.this.imgDesc.dispose();
            }
        });
    }

    public void setNode(TableNode node) {
        this.node = node;
        this.activated = false;
        this.viewer.setSorter(null);
        int i = 0;
        while (i < 7) {
            TableColumn tc = this.viewer.getTable().getColumn(i);
            tc.setImage(null);
            ++i;
        }
    }

    public void activate() {
        if (!this.activated) {
            Display display = this.viewer.getControl().getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                public void run() {
                    ResultSet rs = null;
                    int count = 0;
                    ResultSetMetaData metaData = null;
                    ResultSetReader reader = null;
                    try {
                        rs = ColumnsDetail.this.node.getColumns();
                        metaData = rs.getMetaData();
                        count = metaData.getColumnCount();
                        reader = new ResultSetReader(rs);
                    }
                    catch (Exception e) {
                        SQLExplorerPlugin.error("Error activating columns detail view ", e);
                        ColumnsDetail.this.errorMessage = e.getMessage();
                        ColumnsDetail.this.detailLog.setMessage(ColumnsDetail.this.errorMessage);
                        return;
                    }
                    ColumnsDetail.this.sorter = new MySQLTableSorter(count, metaData);
                    ColumnDetailTableModel cdtm = new ColumnDetailTableModel(reader, ColumnsDetail.this);
                    ColumnDetailLabelProvider cdlp = new ColumnDetailLabelProvider(cdtm);
                    ColumnsDetail.this.viewer.setLabelProvider((IBaseLabelProvider)cdlp);
                    ColumnsDetail.this.viewer.setInput((Object)cdtm);
                    ColumnsDetail.this.activated = true;
                    try {
                        Statement st = rs.getStatement();
                        if (st != null) {
                            st.close();
                        }
                        rs.close();
                    }
                    catch (Throwable throwable) {}
                }
            });
        } else {
            this.detailLog.setMessage(this.errorMessage);
        }
    }
}

