/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.actions;

import java.net.URL;
import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class SelectAll
extends Action {
    SessionTreeNode node;
    TableNode tableNode;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getSqlIcon());

    public SelectAll(SessionTreeNode node, TableNode tableNode) {
        this.node = node;
        this.tableNode = tableNode;
    }

    public String getText() {
        return Messages.getString("SelectAll.Open_in_Sql_Editor_1");
    }

    public void run() {
        try {
            ArrayList ls = this.tableNode.getColumnNames();
            StringBuffer sb = new StringBuffer(100);
            sb.append("select ");
            int i = 0;
            while (i < ls.size()) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(ls.get(i));
                ++i;
            }
            String sql = String.valueOf(sb.toString()) + " from " + this.tableNode.getTableInfo().getQualifiedName();
            SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
            input.setSessionNode(this.node);
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
            editorPart.setText(sql);
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error creating sql editor", e);
        }
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.img;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }
}

