/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.actions;

import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class ExportTableScript
extends Action {
    SessionTreeNode node;
    TableNode tableNode;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getTableIcon());

    public ExportTableScript(SessionTreeNode node, TableNode tableNode) {
        this.node = node;
        this.tableNode = tableNode;
    }

    public String getText() {
        return Messages.getString("Create_Table_Script_1");
    }

    public void run() {
        StringBuffer buf = new StringBuffer(4096);
        String sep = System.getProperty("line.separator");
        try {
            ArrayList<String> pks = new ArrayList<String>();
            ResultSet rsPks = this.tableNode.getPK();
            while (rsPks.next()) {
                String name = rsPks.getString(4);
                pks.add(name);
            }
            rsPks.close();
            ResultSet rs = this.tableNode.getColumns();
            String tableName = this.tableNode.getTableInfo().getSimpleName();
            buf.append("create table ");
            buf.append(tableName);
            buf.append("(");
            while (rs.next()) {
                String columnName = rs.getString(4);
                String typeName = rs.getString(6);
                String columnSize = rs.getString(7);
                String decimalDigits = rs.getString(9);
                String defaultValue = rs.getString(13);
                boolean notNull = "NO".equalsIgnoreCase(rs.getString(18));
                String sLower = typeName.toLowerCase();
                buf.append(sep);
                buf.append(String.valueOf(columnName) + " ");
                buf.append(typeName);
                boolean bNumeric = false;
                if (sLower.equals("numeric") || sLower.equals("number") || sLower.equals("decimal")) {
                    bNumeric = true;
                }
                if (sLower.indexOf("char") != -1 || sLower.indexOf("int") != -1) {
                    buf.append("(");
                    buf.append(columnSize);
                    buf.append(")");
                } else if (bNumeric) {
                    buf.append("(");
                    buf.append(columnSize);
                    String tmp = decimalDigits;
                    if (tmp != null && !"".equals(tmp) && !"0".equals(tmp)) {
                        buf.append(",");
                        buf.append(tmp);
                    }
                    buf.append(")");
                }
                if (pks.size() == 1 && pks.get(0).equals(columnName)) {
                    buf.append(" PRIMARY KEY");
                }
                if (defaultValue != null && !defaultValue.equals("")) {
                    buf.append(" default ");
                    if (!bNumeric) {
                        buf.append("'");
                    }
                    buf.append(defaultValue);
                    if (!bNumeric) {
                        buf.append("'");
                    }
                }
                if (notNull) {
                    buf.append(" not null");
                }
                buf.append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            rs.close();
            buf.append(")" + sep);
            SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
            input.setSessionNode(this.node);
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
            editorPart.setText(buf.toString());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error creating export script", e);
        }
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.img;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }
}

