/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class LoggingProgress
implements IRunnableWithProgress {
    SQLDriverManager _driverMgr;
    ISQLDriver driver;
    ISQLAlias alias;
    String user;
    String pswd;
    String error;
    SQLConnection conn;
    Throwable th;

    public LoggingProgress(SQLDriverManager dm, ISQLDriver dv, ISQLAlias al, String user, String pswd) {
        this._driverMgr = dm;
        this.driver = dv;
        this.alias = al;
        this.user = user;
        this.pswd = pswd;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.setTaskName(Messages.getString("Logging_to_database..._1"));
        monitor.beginTask(Messages.getString("Logging_to_database..._1"), -1);
        try {
            this.conn = this._driverMgr.getConnection(this.driver, this.alias, this.user, this.pswd);
            monitor.done();
        }
        catch (Throwable e) {
            this.th = e;
            this.error = e.getMessage();
            SQLExplorerPlugin.error("Error logging to database", e);
        }
    }

    public SQLConnection getConn() {
        return this.conn;
    }

    public String getError() {
        return this.error;
    }

    public boolean isOk() {
        return this.th == null;
    }
}

